﻿var url = require("url");
var System = require("../../base/system");
module.exports = function (app) {
	app.get('/api/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
        var methodName = req.params["method"];
        var gname=req.params["gname"];
        classPath=gname+"."+classPath;
		var params = [];
        params.push(methodName);
		params.push(req.body);
        params.push(req.query);
        params.push(req);
		var p = null;
		var invokeObj = System.getObject("api." + classPath);
		if (invokeObj["doexec"]) {
			p = invokeObj["doexec"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
	app.post('/api/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
        var methodName = req.params["method"];
        var gname=req.params["gname"];
        var params = [];
        classPath=gname+"."+classPath;
		var tClientIp = System.get_client_ip(req);
		req.body.clientIp = tClientIp;
		req.body.agent= req.headers["user-agent"];
		req.body.classname=classPath;
		params.push(methodName);
		params.push(req.body);
        params.push(req.query);
        params.push(req);
		var p = null;
		var invokeObj = System.getObject("api." + classPath);
		if (invokeObj["doexec"]) {
			p = invokeObj["doexec"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
};
