var System=require("../../../system");
var settings=require("../../../../config/settings");
var pinyin = require("pinyin");
const CtlBase = require("../../ctl.base");
class tmqueryCtl extends CtlBase {
  constructor(){
    super("tmquery",CtlBase.getServiceName(tmqueryCtl));
    this.GsbByTmSearchApi=System.getObject("api.tmquery.tmsearch");
    this.utilstmSve=System.getObject("service.tmquery.utilstmSve");
    this.utilscontent=System.getObject("service.tmquery.utilscontentfilterSve");
    this.tm_type={P:"普通商标",J:"集体商标",Z:"证明商标",T:"特殊商标"};
    this.tm_status={1:"申请中",2:"已初审",3:"已注册",4:"已无效",5:"其他"};
    this.imageQueryUrl=settings.apiconfig.imageQueryUrl();
    this.tm_gjfl={1:"01类 化学原料",2:"02类 颜料油漆",3:"03类 日化用品",4:"04类 燃料油脂",5:"05类 医药",6:"06类 金属材料",7:"07类 机械设备",8:"08类 手工器械",9:"09类 科学仪器",
                  10:"10类 医疗器械",11:"11类 灯具空调",12:"12类 运输工具",13:"13类 军火烟火",14:"14类 珠宝钟表",15:"15类 乐器",16:"16类 办公用品",17:"17类 橡胶制品",18:"18类 皮革皮具",19:"19类 建筑材料",20:"20类 家具",21:"21类 厨房洁具",22:"22类 绳网袋蓬",23:"23类 纱线丝",24:"24类 布料床单",
                  25:"25类 服装鞋帽",26:"26类 钮扣拉链",27:"27类 地毯席垫",28:"28类 健身器材",29:"29类 食品",30:"30类 方便食品",31:"31类 农林生鲜",32:"32类 啤酒饮料",33:"33类 酒",34:"34类 烟草烟具",35:"35类 广告销售",36:"36类 金融物管",37:"37类 建筑修理",38:"38类 通讯服务",
                  39:"39类 运输贮藏",40:"40类 材料加工",41:"41类 教育娱乐",42:"42类 科技服务",43:"43类 餐饮住宿",44:"44类 医疗园艺",45:"45类 社会服务"};
    this.province = ["安徽省", "福建省", "甘肃省", "广东省", "广西壮族自治区", "贵州省", "海南省", "河北省", "河南省", "黑龙江省", "湖北省", "湖南省", "吉林省", "江苏省", "江西省", "辽宁省", "内蒙古自治区", "宁夏回族自治区", "青海省", "山东省", "山西省",
                      "陕西省", "四川省", "西藏自治区", "新疆维吾尔自治区", "云南省", "浙江省", "北京市", "天津市", "上海市", "重庆市","香港特别行政区","台湾省","澳门特别行政区"]
  }
  convertDate(time){
     if(time==null){
       return "";
     }
     var date =  new Date(Number(time*1000));
     var y = 1900+date.getYear();
     var m = "0"+(date.getMonth()+1);
     var d = "0"+date.getDate();
     return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
  }
  convertDate1(time){
     if(time==null){
       return "";
     }
     var date =  new Date(Number(time*1000));
     var month = date.getMonth()+4;
     var year = date.getYear();
     if(month>12){
      month = month-12;
      year = year+1;
     }
     var y = 1900+year;
     var m = "0"+month;
     var d = "0"+date.getDate();
     return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
  }
  async getSbqz(data){
    var tms=await this.utilstmSve.getGroupNclNumList(data);
    var that=this;
    var sbqz="";
    if(tms.status == 0&&tms.data.exist.length>0){
      tms.data.exist.forEach(function(c){
        sbqz+=c.code+";";
      });
    }
    return sbqz;
  }

  async findTrademarkNameIndex(query,obj){//根据商标名称模糊查询,首次查询,
    var result={rows:[],code_counts:[],count:0};
    var sources=[];
    var codes=[];
    var tmName=obj.tmName==null?"":obj.tmName;
    tmName=tmName.replace(/[&\|\\\*^%$#@\-]/g,"");
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var ncl=obj.ncl;
    var nclcode=[];
    for(var i=0;i<ncl.length;i++){
      console.log(ncl[i]);
      var num = Number(ncl[i].slice(0,2))
      console.log(num);
      nclcode.push(num);
    }
    var data={
      tmName:tmName,
      nclcode:nclcode,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbByTmSearchApi.tmNmaeSearchByNcl(data);//获取查询结果
    var tmsjuhe = await this.GsbByTmSearchApi.tmNmaeSearchByNcljuhe(data);//获取聚合结果
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      tms.data.forEach(function(tm){
        var source={
             sbmc:tm.tm_name,//商标名称
             sbpy:tm.tm_name_py,//商标拼音
             sbyw:tm.tm_name_en,//商标英文
             gjfl:tm.ncl_one_codes,//国际分类
             gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
             sbzch:tm.tm_regist_num,//商标注册号
             sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
             sbzt:that.tm_status[tm.status],//商标状态
             sqrq:that.convertDate(tm.apply_day),//申请日期
             csrq:that.convertDate(tm.first_notice_day),//初审日期
             zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
             csggym:tm.first_notice_page_num,//初审公告页码
             zcr:tm.applicant_cn,//申请人
             jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
             csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
             zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
             csgg:tm.first_notice_issue,//初审公告（期号）
             zcgg:tm.regist_notice_issue,//注册公告
             zcggym:tm.regist_notice_page_num,//注册公告页码
             yzcr:tm.original_applicant_cn,//原申请人
             zcdz:tm.applicant_cn_addr,//申请地址
             zcren:tm.applicant_en,//申请人enlish
             zcdzen:tm.applicant_en_addr,//申请地址enlish
             dljg:tm.tm_agency,//代理机构
             zxzt:"",//最新状态
             spfwxm:"",
             lcxx:"",
             logo:tm.pic_url,//商标图样
        };
        sources.push(source);

      });
      result.rows=sources;
    };
    if(tmsjuhe.status==0){
      tmsjuhe.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhe.buckets.forEach(function(buck){
            var name = that.tm_gjfl[buck.key];
            var gjfl ={//国际分类
            	"key":buck.key,
            	"keyvalue":name,
            	"keycount":buck.doc_count,
            };
            codes.push(gjfl);
      });
      result.code_counts=codes;
    }
    return System.getResult2(result,null);
  }

  async findTrademarkName(query,obj){//根据商标名称模糊查询
    var result={rows:[],code_counts:[],status_counts:[],no_code_counts:[],year_counts:[]
      ,province_counts:[],ncl_counts:[],count:0};
    var sources=[];
    var codes=[];
    var no_code=[];
    var year_count=[]
    var flztstatus=[];
    var tmName=obj.tmName==null?"":obj.tmName;
    tmName=tmName.replace(/[&\|\\\*^%$#@\-]/g,"");
    // var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    // var flzttabkey=obj.flzttabkey==null?"":obj.flzttabkey;
    // var sqnftabkey=obj.sqnftabkey==null?"":obj.sqnftabkey;
    var sqlbtabkey = obj.sqlbtabkey && obj.sqlbtabkey.length>0?obj.sqlbtabkey:[];
    var flzttabkey = obj.flzttabkey && obj.flzttabkey.length>0?obj.flzttabkey:[];
    var sqnftabkey=obj.sqnftabkey && obj.sqnftabkey.length>0?obj.sqnftabkey:[];
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var ncl=obj.ncl;
    var nclcode=[];
    for(var i=0;i<ncl.length;i++){
      var num = Number(ncl[i].slice(0,2))
      nclcode.push(num);
    };
    var nclNum=obj.nclNum;
    var nclNumcode=[];
    for(var i=0;i<nclNum.length;i++){
      var num = Number(nclNum[i])
      nclNumcode.push(num);
    }
    var ncltwocodesearch = obj.xcl;
    var ncltwo =[];
    for(var i=0;i<ncltwocodesearch.length;i++){
      var code=ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    var js="";
    var bz="";
    var tyc="";
    var py="";
    var xjz="";
    var dx="";
    var tycdata=[];
    var xjzdata=[];
    var contain="";
    //按商标检索条件进行参数---'拼音', '同义词', '形近字', '换序',"左匹配","右匹配"
    var sbtjdata = obj.sbtjdata;
    for (var i = 0; i < sbtjdata.length; i++) {
      var tmp=sbtjdata[i];
      if(tmp=="近似"){
        js="js";
      }if(tmp=="变字"){
        bz="bz";
      }
      if(tmp=="同义词"){
        tyc="tyc";
        var objd={
          name:tmName
        }
        var tms=await this.utilscontent.getSynonymsList(objd);
        if(tms.code==1){
          tycdata=tms.data;
        }
      }
      if(tmp=="拼音"){
        py="py";
        var pynamelist=pinyin(tmName,{
          heteronym: true,
          style: pinyin.STYLE_NORMAL,
        });
        var pp=[];
        console.log(pynamelist);
        pynamelist.forEach(function(c){
          pp.push(c[0]);
        });
        var pyname=pp.join("");
        // console.log("pppppppppppppppppppppppppppppppppppppppp");
        // console.log(pynamelist);
        // console.log(pyname);
      }
      if(tmp=="形近字"){
        xjz="xjz";
        var objd={
          name:tmName
        }
        var tms=await this.utilscontent.getSimilarList(objd);
        // console.log("--------------------------------------");
        // console.log(tms.data);
        if(tms.code==1){
          xjzdata=tms.data;
        }
      }
      if(tmp=="换序"){
        dx="dx";
      }
      if(tmp=="包含该商标"){
        contain="contain";
      }
    }
    var data={
      tmName:tmName,
      sqlbtabkey:sqlbtabkey,
      flzttabkey:flzttabkey,
      sqnftabkey:sqnftabkey,
      pagesize:pageSize,
      page:currentPage,
      nclcode:nclcode,
      nclNumcode:nclNumcode,
      js:js,
      bz:bz,
      tyc:tyc,
      tycdata:tycdata,
      py:py,
      pyname:pyname,
      xjz:xjz,
      xjzdata:xjzdata,
      dx:dx,
      contain:contain,
      ncltwo:ncltwo
    };
    var tms =await this.GsbByTmSearchApi.tmNameSearch(data);//获取查询结果
    // console.log(tms);
    var tmsjuhe = await this.GsbByTmSearchApi.tmNamejuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmNamejuheFlztSearch(data);//根据商标状态聚合
    // console.log(tmsjuhestatus);
    var tmsjuheyear = await this.GsbByTmSearchApi.tmNamejuheYearSearch(data);//根据商标year聚合
    // var tmsjuheprovince = await this.GsbByTmSearchApi.tmNamejuheprovinceSearch(data);//根据商标province聚合
    // var tmsjuhencl = await this.GsbByTmSearchApi.tmNamejuhenclSearch(data);//根据商标ncl聚合
    // console.log(tmsjuheyear);
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm =tms.data[i];
        if(tm!=null){
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var qunzutms=await this.utilstmSve.getGroupNclInfo(sbdata);
          // var spfwxmlist=[];
          // var codelist=[];
          // if(qunzutms.status==0){
          //   qunzutms.data.exist.forEach(function(c){
          //     if(spfwxmlist.findIndex(f => f == c.small_name) < 0){
          //       spfwxmlist.push(c.small_name)
          //     }
          //     if(codelist.findIndex(f => f ==c.code)<0){
          //       codelist.push(c.code)
          //     }
          //   });
          // }
          // var spfwxm=spfwxmlist.join(",");
          var sbqzlist=[];
          if(tm.ncl_two_codes&&tm.ncl_two_codes.length>0){
            // console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function(c){
              if(c){
                sbqzlist.push(c)
              }
            });
          }
          var sbqz=sbqzlist.join(",");
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               csgg:tm.first_notice_issue,//初审公告（期号）
               zcgg:tm.regist_notice_issue,//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               zcren:tm.applicant_en,//申请人enlish
               zcdzen:tm.applicant_en_addr,//申请地址enlish
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               sbqz:sbqz,
               logo:tm.pic_url,//商标图样
          };
          sources.push(source);
        }
      }
      result.rows=sources;
    }
    if(nclNum.length>0&&nclNum.length<45){
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
                "key":buck.key,
                "keyvalue":name,
                "keycount":buck.doc_count,
              };
              codes.push(gjfl);
        });
        result.code_counts=codes;
        result.no_code_counts=no_code;
      }
    }else{
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        Array.prototype.remove = function(val) {
          var index = this.indexOf(val);
          if (index > -1) {
            this.splice(index, 1);
          }
        };
        var num=[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
           21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45];
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
              	"key":buck.key,
              	"keyvalue":name,
              	"keycount":buck.doc_count,
              };
              codes.push(gjfl);
              num.remove(Number(buck.key));
        });
        result.code_counts=codes;
        num.forEach(function(n){
          var name = that.tm_gjfl[n];
          var no_gjfl={
            "name":name
          }
          no_code.push(no_gjfl);
        });
        result.no_code_counts=no_code;
      }
    }
    if(tmsjuhestatus.status==0){
      tmsjuhestatus.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhestatus.buckets.forEach(function(buck){
        var name = that.tm_status[buck.key];
        var st={
          "key":buck.key,
          "keyvalue":name,
          "keycount":buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts=flztstatus;
    }
    if(tmsjuheyear.status==0){
      tmsjuheyear.buckets.sort(function(a,b){
        return b.key - a.key;
      });
      tmsjuheyear.buckets.forEach(function(buck){
        var name = that.tm_status[buck.key];
        var year={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts=year_count;
    }
    // if(tmsjuheprovince.status==0){
    //   var sum = 0;
    //   var pros =[];
    //   for(var i in tmsjuheprovince.buckets){
    //     if(that.province.indexOf(tmsjuheprovince.buckets[i].key)>=0){
    //       var ss = {
    //         "province":tmsjuheprovince.buckets[i].key,
    //         "count":tmsjuheprovince.buckets[i].doc_count
    //       }
    //       sum +=tmsjuheprovince.buckets[i].doc_count;
    //       pros.push(ss);
    //     }
    //   }
    //   for(var k=0;k<pros.length;k++){
    //     var percent = parseInt(100*(pros[k].count/sum));
    //     var pp = {
    //       "province":pros[k].province,
    //       "count":pros[k].count,
    //       "percent":percent+"%"
    //     }
    //     result.province_counts.push(pp);
    //   }
    // }
    // if(tmsjuhencl.status==0){
    //   var sum =0;
    //   var ncllist =[];
    //   tmsjuhencl.buckets.forEach(function(buck){
    //     var ncl={
    //       "key":buck.key,
    //       "keycount":buck.doc_count,
    //     };
    //     sum +=buck.doc_count;
    //     ncllist.push(ncl);
    //   });
    //   for(var k=0;k<ncllist.length;k++){
    //     var percent = parseInt(100*(ncllist[k].keycount/sum));
    //     var nn = {
    //       "code":that.tm_gjfl[ncllist[k].key],
    //       "count":ncllist[k].keycount,
    //       "percent":percent+"%"
    //     }
    //     result.ncl_counts.push(nn);
    //   }
    // }
    return System.getResult2(result,null);
  }
  async findTrademarkNamejuhe(query,obj){//根据商标名称模糊查询,商标注册地域/大类分布
    var result={province_counts:[],ncl_counts:[]};
    var tmName=obj.tmName==null?"":obj.tmName;
    tmName=tmName.replace(/[&\|\\\*^%$#@\-]/g,"");
    var js="js";
    var bz="bz";
    var tyc="";
    var py="";
    var xjz="";
    var dx="dx";
    var tycdata=[];
    var xjzdata=[];
    var contain="contain";
    //按商标检索条件进行参数---'拼音', '同义词', '形近字', '换序',"左匹配","右匹配"
    if("同义词"=="同义词"){
      tyc="tyc";
      var objd={
        name:tmName
      }
      var tms=await this.utilscontent.getSynonymsList(objd);
      if(tms.code==1){
        tycdata=tms.data;
      }
    }
    if("拼音"=="拼音"){
      py="py";
      var pynamelist=pinyin(tmName,{
        heteronym: true,
        style: pinyin.STYLE_NORMAL,
      });
      var pp=[];
      console.log(pynamelist);
      pynamelist.forEach(function(c){
        pp.push(c[0]);
      });
      var pyname=pp.join("");
    }
    if("形近字"=="形近字"){
      xjz="xjz";
      var objd={
        name:tmName
      }
      var tms=await this.utilscontent.getSimilarList(objd);
      // console.log("--------------------------------------");
      // console.log(tms.data);
      if(tms.code==1){
        xjzdata=tms.data;
      }
    }
    var data={
      tmName:tmName,
      js:js,
      bz:bz,
      tyc:tyc,
      tycdata:tycdata,
      py:py,
      pyname:pyname,
      xjz:xjz,
      xjzdata:xjzdata,
      dx:dx,
      contain:contain
    };
    var tmsjuheprovince = await this.GsbByTmSearchApi.tmNamejuheprovinceSearch(data);//根据商标province聚合
    var tmsjuhencl = await this.GsbByTmSearchApi.tmNamejuhenclSearch(data);//根据商标ncl聚合
    var that=this;
    if(tmsjuheprovince.status==0){
      var sum = 0;
      var pros =[];
      for(var i in tmsjuheprovince.buckets){
        if(that.province.indexOf(tmsjuheprovince.buckets[i].key)>=0){
          var ss = {
            "province":tmsjuheprovince.buckets[i].key,
            "count":tmsjuheprovince.buckets[i].doc_count
          }
          sum +=tmsjuheprovince.buckets[i].doc_count;
          pros.push(ss);
        }
      }
      for(var k=0;k<pros.length;k++){
        var percent = parseInt(100*(pros[k].count/sum));
        var pp = {
          "province":pros[k].province,
          "count":pros[k].count,
          "percent":percent+"%"
        }
        result.province_counts.push(pp);
      }
    }
    if(tmsjuhencl.status==0){
      var sum =0;
      var ncllist =[];
      tmsjuhencl.buckets.forEach(function(buck){
        var ncl={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        sum +=buck.doc_count;
        ncllist.push(ncl);
      });
      for(var k=0;k<ncllist.length;k++){
        var percent = parseInt(100*(ncllist[k].keycount/sum));
        var nn = {
          "code":that.tm_gjfl[ncllist[k].key],
          "count":ncllist[k].keycount,
          "percent":percent+"%"
        }
        result.ncl_counts.push(nn);
      }
    }
    return System.getResult2(result,null);
  }
  async findTrademarkNameAccurate(query,obj){//通过商标名来进行精准查询
    console.log(obj);
    var result={rows:[],code_counts:[],status_counts:[],no_code_counts:[],
      year_counts:[],province_counts:[],ncl_counts:[],count:0};
    var sources=[];
    var codes=[];
    var no_code=[];
    var year_count=[];
    var flztstatus=[];
    var tmName=obj.tmName==null?"":obj.tmName;
    tmName=tmName.replace(/[&\|\\\*^%$#@\-]/g,"");
    // var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    var sqlbtabkey = obj.sqlbtabkey && obj.sqlbtabkey.length>0?obj.sqlbtabkey:[];
    var flzttabkey = obj.flzttabkey && obj.flzttabkey.length>0?obj.flzttabkey:[];
    var sqnftabkey=obj.sqnftabkey && obj.sqnftabkey.length>0?obj.sqnftabkey:[];
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var ncl=obj.ncl;
    var nclcode=[];
    for(var i=0;i<ncl.length;i++){
      console.log(ncl[i]);
      var num = Number(ncl[i].slice(0,2))
      console.log(num);
      nclcode.push(num);
    };
    var nclNum=obj.nclNum;
    var nclNumcode=[];
    for(var i=0;i<nclNum.length;i++){
      var num = Number(nclNum[i])
      nclNumcode.push(num);
    }

    var ncltwocodesearch = obj.xcl;
    var ncltwo =[];
    for(var i=0;i<ncltwocodesearch.length;i++){
      console.log(ncltwocodesearch[i]);
      var code=ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    var data={
      tmName:tmName,
      sqlbtabkey:sqlbtabkey,
      flzttabkey:flzttabkey,
      sqnftabkey:sqnftabkey,
      nclcode:nclcode,
      nclNumcode:nclNumcode,
      ncltwo:ncltwo,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbByTmSearchApi.tmAccurateSearch(data);//获取查询结果
    // console.log(tms);
    // console.log("++++++++++++++++++++++++++++++++++++++++++++++++");
    var tmsjuhe = await this.GsbByTmSearchApi.tmAccuratejuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmAccuratejuheFlztSearch(data);//根据商标状态聚合
    var tmsjuheyear = await this.GsbByTmSearchApi.tmAccuratejuheYearSearch(data);//根据商标year聚合
    // var tmsjuheprovince = await this.GsbByTmSearchApi.tmAccuratejuheprovinceSearch(data);//根据商标province聚合
    // var tmsjuhencl = await this.GsbByTmSearchApi.tmAccuratejuhenclSearch(data);//根据商标ncl聚合
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm =tms.data[i];
        if(tm!=null){
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var qunzutms=await this.utilstmSve.getGroupNclInfo(sbdata);
          // var spfwxmlist=[];
          // var codelist=[];
          // if(qunzutms.status==0){
          //   qunzutms.data.exist.forEach(function(c){
          //     if(spfwxmlist.findIndex(f => f == c.small_name) < 0){
          //       spfwxmlist.push(c.small_name)
          //     }
          //     if(codelist.findIndex(f => f ==c.code)<0){
          //       codelist.push(c.code)
          //     }
          //   });
          // }
          // var spfwxm=spfwxmlist.join(",");
          var sbqzlist=[];
          if(tm.ncl_two_codes&&tm.ncl_two_codes.length>0){
            // console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function(c){
              if(c){
                sbqzlist.push(c)
              }
            });
          }
          var sbqz=sbqzlist.join(",");
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               csgg:tm.first_notice_issue,//初审公告（期号）
               zcgg:tm.regist_notice_issue,//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               zcren:tm.applicant_en,//申请人enlish
               zcdzen:tm.applicant_en_addr,//申请地址enlish
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               sbqz:sbqz,
               logo:tm.pic_url,//商标图样
          };
        sources.push(source);
        }
      }
      result.rows=sources;
    }
    if(nclNum.length>0&&nclNum.length<45){
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
                "key":buck.key,
                "keyvalue":name,
                "keycount":buck.doc_count,
              };
              codes.push(gjfl);
        });
        result.code_counts=codes;
        result.no_code_counts=no_code;
      }
    }else{
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        Array.prototype.remove = function(val) {
          var index = this.indexOf(val);
          if (index > -1) {
            this.splice(index, 1);
          }
        };
        var num=[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
           21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45];
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
              	"key":buck.key,
              	"keyvalue":name,
              	"keycount":buck.doc_count,
              };
              codes.push(gjfl);
              num.remove(Number(buck.key));
        });
        result.code_counts=codes;
        num.forEach(function(n){
          var name = that.tm_gjfl[n];
          var no_gjfl={
            "name":name
          }
          no_code.push(no_gjfl);
        });
        result.no_code_counts=no_code;
      }
    }
    if(tmsjuhestatus.status==0){
      tmsjuhestatus.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhestatus.buckets.forEach(function(buck){
        var name = that.tm_status[buck.key];
        var st={
          "key":buck.key,
          "keyvalue":name,
          "keycount":buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts=flztstatus;
    }
    if(tmsjuheyear.status==0){
      tmsjuheyear.buckets.sort(function(a,b){
        return b.key - a.key;
      });
      tmsjuheyear.buckets.forEach(function(buck){
        var year={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts=year_count;
    }
    // var openId=obj.user.openId
    // var redisdata={
    //   openId:openId,
    //   mark:tmName
    // };
    // var rediscache =await this.GsbByTmSearchApi.redisInsert(redisdata);
    // if(tmsjuheprovince.status==0){
    //   var sum = 0;
    //   var pros =[];
    //   for(var i in tmsjuheprovince.buckets){
    //     if(that.province.indexOf(tmsjuheprovince.buckets[i].key)>=0){
    //       var ss = {
    //         "province":tmsjuheprovince.buckets[i].key,
    //         "count":tmsjuheprovince.buckets[i].doc_count
    //       }
    //       sum +=tmsjuheprovince.buckets[i].doc_count;
    //       pros.push(ss);
    //     }
    //   }
    //   console.log(pros);
    //   for(var k=0;k<pros.length;k++){
    //     var percent = parseInt(100*(pros[k].count/sum));
    //     var pp = {
    //       "province":pros[k].province,
    //       "count":pros[k].count,
    //       "percent":percent+"%"
    //     }
    //     result.province_counts.push(pp);
    //   }
    // }
    // if(tmsjuhencl.status==0){
    //   var sum =0;
    //   var ncllist =[];
    //   tmsjuhencl.buckets.forEach(function(buck){
    //     var ncl={
    //       "key":buck.key,
    //       "keycount":buck.doc_count,
    //     };
    //     sum +=buck.doc_count;
    //     ncllist.push(ncl);
    //   });
    //   for(var k=0;k<ncllist.length;k++){
    //     var percent = parseInt(100*(ncllist[k].keycount/sum));
    //     var nn = {
    //       "code":that.tm_gjfl[ncllist[k].key],
    //       "count":ncllist[k].keycount,
    //       "percent":percent+"%"
    //     }
    //     result.ncl_counts.push(nn);
    //   }
    // }

    return System.getResult2(result,null);
  }
  async findTrademarkNameAccuratejuhe(query,obj){//通过商标名来进行精准查询,商标注册地域/大类分布
    var result={province_counts:[],ncl_counts:[]};
    var tmName=obj.tmName==null?"":obj.tmName;
    tmName=tmName.replace(/[&\|\\\*^%$#@\-]/g,"");
    var data={
      tmName:tmName
    };
    var tmsjuheprovince = await this.GsbByTmSearchApi.tmAccuratejuheprovinceSearch(data);//根据商标province聚合
    var tmsjuhencl = await this.GsbByTmSearchApi.tmAccuratejuhenclSearch(data);//根据商标ncl聚合
    var that=this;
    if(tmsjuheprovince.status==0){
      var sum = 0;
      var pros =[];
      for(var i in tmsjuheprovince.buckets){
        if(that.province.indexOf(tmsjuheprovince.buckets[i].key)>=0){
          var ss = {
            "province":tmsjuheprovince.buckets[i].key,
            "count":tmsjuheprovince.buckets[i].doc_count
          }
          sum +=tmsjuheprovince.buckets[i].doc_count;
          pros.push(ss);
        }
      }
      console.log(pros);
      for(var k=0;k<pros.length;k++){
        var percent = parseInt(100*(pros[k].count/sum));
        var pp = {
          "province":pros[k].province,
          "count":pros[k].count,
          "percent":percent+"%"
        }
        result.province_counts.push(pp);
      }
    }
    if(tmsjuhencl.status==0){
      var sum =0;
      var ncllist =[];
      tmsjuhencl.buckets.forEach(function(buck){
        var ncl={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        sum +=buck.doc_count;
        ncllist.push(ncl);
      });
      for(var k=0;k<ncllist.length;k++){
        var percent = parseInt(100*(ncllist[k].keycount/sum));
        var nn = {
          "code":that.tm_gjfl[ncllist[k].key],
          "count":ncllist[k].keycount,
          "percent":percent+"%"
        }
        result.ncl_counts.push(nn);
      }
    }
    return System.getResult2(result,null);

  }
  async findTrademarkzchAccurate(query,obj){//通过商标号来进行精准查询
    var result={rows:[],code_counts:[],status_counts:[],year_counts:[],count:0};
    var sources=[];
    var codes=[];
    var flztstatus=[];
    var year_count=[];
    var regNum=obj.regNum==null?"":obj.regNum;
    // var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    // var flzttabkey = obj.flzttabkey==null?"":obj.flzttabkey;
    // var sqnftabkey = obj.sqnftabkey==null?"":obj.sqnftabkey;
    var sqlbtabkey = obj.sqlbtabkey && obj.sqlbtabkey.length>0?obj.sqlbtabkey:[];
    var flzttabkey = obj.flzttabkey && obj.flzttabkey.length>0?obj.flzttabkey:[];
    var sqnftabkey=obj.sqnftabkey && obj.sqnftabkey.length>0?obj.sqnftabkey:[];
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var ncltwocodesearch = obj.xcl;
    var ncltwo =[];
    for(var i=0;i<ncltwocodesearch.length;i++){
      var code=ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    var data={
      regNum:regNum,
      sqlbtabkey:sqlbtabkey,
      flzttabkey:flzttabkey,
      sqnftabkey:sqnftabkey,
      ncltwo:ncltwo,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbByTmSearchApi.tmzchSearch(data);//获取查询结果
    var tmsjuhe = await this.GsbByTmSearchApi.tmzchjuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmzchjuheFlztSearch(data);//根据商标状态聚合
    var tmsjuheyear = await this.GsbByTmSearchApi.tmzchjuheYearSearch(data);//根据商标year聚合
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm =tms.data[i];
        if(tm!=null){
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var qunzutms=await this.utilstmSve.getGroupNclInfo(sbdata);
          // var spfwxmlist=[];
          // var codelist=[];
          // if(qunzutms.status==0){
          //   qunzutms.data.exist.forEach(function(c){
          //     if(spfwxmlist.findIndex(f => f == c.small_name) < 0){
          //       spfwxmlist.push(c.small_name)
          //     }
          //     if(codelist.findIndex(f => f ==c.code)<0){
          //       codelist.push(c.code)
          //     }
          //   });
          // }
          // var spfwxm=spfwxmlist.join(",");
          var sbqzlist=[];
          if(tm.ncl_two_codes&&tm.ncl_two_codes.length>0){
            // console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function(c){
              if(c){
                sbqzlist.push(c)
              }
            });
          }
          var sbqz=sbqzlist.join(",");
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               csgg:tm.first_notice_issue,//初审公告（期号）
               zcgg:tm.regist_notice_issue,//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               zcren:tm.applicant_en,//申请人enlish
               zcdzen:tm.applicant_en_addr,//申请地址enlish
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               sbqz:sbqz,
               logo:tm.pic_url,//商标图样
          };
        sources.push(source);
        }
      }
      result.rows=sources;
    }
    if(tmsjuhe.status==0){
      tmsjuhe.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhe.buckets.forEach(function(buck){
            var name = that.tm_gjfl[buck.key];
            var gjfl ={//国际分类
            	"key":buck.key,
            	"keyvalue":name,
            	"keycount":buck.doc_count,
            };
            codes.push(gjfl);
      });
      result.code_counts=codes;
    }
    if(tmsjuhestatus.status==0){
      tmsjuhestatus.buckets.sort(function(a,b){
        return b.key - a.key;
      });
      tmsjuhestatus.buckets.forEach(function(buck){
        var name = that.tm_status[buck.key];
        var st={
          "key":buck.key,
          "keyvalue":name,
          "keycount":buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts=flztstatus;
    }
    if(tmsjuheyear.status==0){
      tmsjuheyear.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuheyear.buckets.forEach(function(buck){
        var year={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts=year_count;
    }
    return System.getResult2(result,null);
  }

  async findTrademarkzcr(query,obj){//通过注册人模糊查询
    console.log(obj);
    var result={rows:[],code_counts:[],status_counts:[],no_code_counts:[],year_counts:[],namecounts:[],count:0};
    var sources=[];
    var codes=[];
    var no_code=[];
    var year_count=[];
    var flztstatus=[];
    var namecount=[];
    var applier=obj.regMan==null?"":obj.regMan;
    var zcrname = obj.zcrname==null?"":obj.zcrname;
    applier=applier.replace(/[&\|\\\*^%$#@\-]/g,"");
    // var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    // var flzttabkey = obj.flzttabkey==null?"":obj.flzttabkey;
    // var sqnftabkey=obj.sqnftabkey==null?"":obj.sqnftabkey;
    var sqlbtabkey = obj.sqlbtabkey && obj.sqlbtabkey.length>0?obj.sqlbtabkey:[];
    var flzttabkey = obj.flzttabkey && obj.flzttabkey.length>0?obj.flzttabkey:[];
    var sqnftabkey=obj.sqnftabkey && obj.sqnftabkey.length>0?obj.sqnftabkey:[];
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var ncltwocodesearch = obj.xcl;
    var ncltwo =[];
    for(var i=0;i<ncltwocodesearch.length;i++){
      var code=ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    var data={
      applier:applier,
      sqlbtabkey:sqlbtabkey,
      flzttabkey:flzttabkey,
      sqnftabkey:sqnftabkey,
      ncltwo:ncltwo,
      zcrname:zcrname,
      pagesize:pageSize,
      page:currentPage
    };
    var tms =await this.GsbByTmSearchApi.tmzcrSearch(data);//获取查询结果
    var tmsjuhe = await this.GsbByTmSearchApi.tmzcrjuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmzcrjuheFlztSearch(data);//根据商标状态聚合
    var tmsjuheyear = await this.GsbByTmSearchApi.tmzcrjuheYearSearch(data);//根据商标year聚合
    var tmszcrjuhe = await this.GsbByTmSearchApi.tmzcrjuheapplierSearch(data);//根据商标申请人聚合
    var that=this;
    if(tms.status == 0){
      result.count=tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm =tms.data[i];
        if(tm!=null){
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var qunzutms=await this.utilstmSve.getGroupNclInfo(sbdata);
          // var spfwxmlist=[];
          // var codelist=[];
          // if(qunzutms.status==0){
          //   qunzutms.data.exist.forEach(function(c){
          //     if(spfwxmlist.findIndex(f => f == c.small_name) < 0){
          //       spfwxmlist.push(c.small_name)
          //     }
          //     if(codelist.findIndex(f => f ==c.code)<0){
          //       codelist.push(c.code)
          //     }
          //   });
          // }
          // var spfwxm=spfwxmlist.join(",");
          var sbqzlist=[];
          if(tm.ncl_two_codes&&tm.ncl_two_codes.length>0){
            // console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function(c){
              if(c){
                sbqzlist.push(c)
              }
            });
          }
          var sbqz=sbqzlist.join(",");
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               csgg:tm.first_notice_issue,//初审公告（期号）
               zcgg:tm.regist_notice_issue,//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               zcren:tm.applicant_en,//申请人enlish
               zcdzen:tm.applicant_en_addr,//申请地址enlish
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               sbqz:sbqz,
               logo:tm.pic_url,//商标图样
          };
        sources.push(source);
        }
      }
      result.rows=sources;
    }
    if(tmsjuhe.status==0){
      tmsjuhe.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      Array.prototype.remove = function(val) {
        var index = this.indexOf(val);
        if (index > -1) {
          this.splice(index, 1);
        }
      };
      var num=[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
         21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45];
      tmsjuhe.buckets.forEach(function(buck){
            var name = that.tm_gjfl[buck.key];
            var gjfl ={//国际分类
            	"key":buck.key,
            	"keyvalue":name,
            	"keycount":buck.doc_count,
            };
            codes.push(gjfl);
            num.remove(Number(buck.key));
      });
      result.code_counts=codes;
      num.forEach(function(n){
        var name = that.tm_gjfl[n];
        var no_gjfl={
          "name":name
        }
        no_code.push(no_gjfl);
      });
      result.no_code_counts=no_code;
    }
    if(tmsjuhestatus.status==0){
      tmsjuhestatus.buckets.sort(function(a,b){
        return a.key - b.key;
      });
      tmsjuhestatus.buckets.forEach(function(buck){
        var name = that.tm_status[buck.key];
        var st={
          "key":buck.key,
          "keyvalue":name,
          "keycount":buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts=flztstatus;
    }
    if(tmsjuheyear.status==0){
      tmsjuheyear.buckets.sort(function(a,b){
        return b.key - a.key;
      });
      tmsjuheyear.buckets.forEach(function(buck){
        var year={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts=year_count;
    }
    if(tmszcrjuhe.status==0){
      tmszcrjuhe.buckets.sort(function(a,b){
        return b.key - a.key;
      });
      tmszcrjuhe.buckets.forEach(function(buck){
        var name={
          "key":buck.key,
          "keycount":buck.doc_count,
        };
        namecount.push(name);
      });
      result.namecounts=namecount;
    }
    console.log("*********************************************");
    console.log(tmszcrjuhe.buckets);
    return System.getResult2(result,null);
  }

  async imagequery(query,obj){
    var result={rows:[],code_counts:[],status_counts:[],year_counts:[],count:0};
    var sources=[];
    var codes=[];
    var year_count=[];
    var flztstatus=[];
    var key=settings.apiconfig.imageQueryKey;
    var tmUrl=obj.imageUrl;
    var url=this.imageQueryUrl+"?imageurl="+encodeURIComponent(tmUrl)+"&appkey="+key;
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execGet({},url);
      var data=JSON.parse(rtn.stdout);
      if(data[0].length && data[0].length>0 && data[0]!=undefined){
          var d=data[0];
          result.rows=d;
          var RegistNumsAll=[];
          for(var i=0;i<d.length;i++){
            var regNum=d[i];
            RegistNumsAll.push(regNum.imageid);
          }
          var data={
            tmRegistNumsAll:RegistNumsAll,
          };
          var tmsjuhe = await this.GsbByTmSearchApi.imagesearchjuheNcl(data);//获取ncl聚合结果
          var tmsjuhestatus = await this.GsbByTmSearchApi.imagesearchjuheStatus(data);//根据商标状态聚合
          var tmsjuheyear = await this.GsbByTmSearchApi.imagesearchjuheYear(data);//根据商标year聚合
          var that=this;
          if(tmsjuhe.status==0){
            tmsjuhe.buckets.sort(function(a,b){
              return a.key - b.key;
            });
            tmsjuhe.buckets.forEach(function(buck){
                  var name = that.tm_gjfl[buck.key];
                  var gjfl ={//国际分类
                  	"key":buck.key,
                  	"keyvalue":name,
                  	"keycount":buck.doc_count,
                  };
                  codes.push(gjfl);
            });
            result.code_counts=codes;
          }
          if(tmsjuhestatus.status==0){
            tmsjuhestatus.buckets.sort(function(a,b){
              return a.key - b.key;
            });
            tmsjuhestatus.buckets.forEach(function(buck){
              var name = that.tm_status[buck.key];
              var st={
                "key":buck.key,
                "keyvalue":name,
                "keycount":buck.doc_count,
              };
              flztstatus.push(st);
            });
            result.status_counts=flztstatus;
          }
          if(tmsjuheyear.status==0){
            tmsjuheyear.buckets.sort(function(a,b){
              return b.key - a.key;
            });
            tmsjuheyear.buckets.forEach(function(buck){
              var year={
                "key":buck.key,
                "keycount":buck.doc_count,
              };
              year_count.push(year);
            });
            result.year_counts=year_count;
          }
          result.count=d.length;
          return System.getResult2(result,null);
      }
      return System.getResult2(result,null);
    }catch(e){
      console.log(e);
      return System.getResult2(result,null);
    }
    return System.getResult2(result,null);
  }
  async findImageSearch(query,obj){ //图像检索查询，
    var result={rows:[],code_counts:[],status_counts:[],year_counts:[],count:0};
    var sources=[];
    var codes=[];
    var year_count=[];
    var flztstatus=[];
    var cp = obj.pageInfo.pageNo;
    var ps = obj.pageInfo.pageSize;
    // var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    // var flzttabkey = obj.flzttabkey==null?"":obj.flzttabkey;
    // var sqnftabkey = obj.sqnftabkey==null?"":obj.sqnftabkey;
    var sqlbtabkey = obj.sqlbtabkey && obj.sqlbtabkey.length>0?obj.sqlbtabkey:[];
    var flzttabkey = obj.flzttabkey && obj.flzttabkey.length>0?obj.flzttabkey:[];
    var sqnftabkey=obj.sqnftabkey && obj.sqnftabkey.length>0?obj.sqnftabkey:[];
    var tmRegistNumsAll = obj.tmRegistNumsAll==null?"":obj.tmRegistNumsAll;
    var RegistNumsAll=[];
    for(var i=0;i<tmRegistNumsAll.length;i++){
      var regNum=tmRegistNumsAll[i];
      RegistNumsAll.push(regNum.imageid);
    }
    var from = Number((cp-1)*ps);
    var end=Number(from+ps);
    var tmRegistNums=RegistNumsAll.slice(from,end);
    var ncltwocodesearch = obj.xcl;
    var ncltwo =[];
    for(var i=0;i<ncltwocodesearch.length;i++){
      var code=ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    if(sqlbtabkey && sqlbtabkey.length<1 && flzttabkey && flzttabkey.length<1 && sqnftabkey && sqnftabkey.length<1){
      console.log("---------------------------------=========================================");
      for(var i=0;i<tmRegistNums.length;i++){
        var regNum=tmRegistNums[i];
        var data1={
          tmRegistNum:regNum
        };
        var tms =await this.GsbByTmSearchApi.imagesearch(data1);
        if(tms.status == 0 && tms.data.length>0){
          var tm=tms.data[0];
          var source={
            sbmc:tm.tm_name,//商标名称
            sbpy:tm.tm_name_py,//商标拼音
            sbyw:tm.tm_name_en,//商标英文
            gjfl:tm.ncl_one_codes,//国际分类
            gjflname:this.tm_gjfl[tm.ncl_one_codes],//国际分类名称
            sbzch:tm.tm_regist_num,//商标注册号
            sblx:this.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
            sbzt:this.tm_status[tm.status],//商标状态
            sqrq:this.convertDate(tm.apply_day),//申请日期
            csrq:this.convertDate(tm.first_notice_day),//初审日期
            zcrq:this.convertDate(tm.original_regist_notice_day),//注册日期
            csggym:tm.first_notice_page_num,//初审公告页码
            zcr:tm.applicant_cn,//申请人
            jzrq:this.convertDate(tm.tm_end_day) ,//截止日期
            csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
            zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
            csgg:tm.first_notice_issue,//初审公告（期号）
            zcgg:tm.regist_notice_issue,//注册公告
            zcggym:tm.regist_notice_page_num,//注册公告页码
            yzcr:tm.original_applicant_cn,//原申请人
            zcdz:tm.applicant_cn_addr,//申请地址
            zcren:tm.applicant_en,//申请人enlish
            zcdzen:tm.applicant_en_addr,//申请地址enlish
            dljg:tm.tm_agency,//代理机构
            zxzt:"",//最新状态
            spfwxm:"",
            lcxx:"",
            logo:tm.pic_url,//商标图样
          };
          sources.push(source);
        }
      }
      var data={
        tmRegistNumsAll:RegistNumsAll,
      };
      var tmsjuhe = await this.GsbByTmSearchApi.imagesearchjuheNcl(data);//获取ncl聚合结果
      var tmsjuhestatus = await this.GsbByTmSearchApi.imagesearchjuheStatus(data);//根据商标状态聚合
      var tmsjuheyear = await this.GsbByTmSearchApi.imagesearchjuheYear(data);//根据商标year聚合
      var that=this;
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
                "key":buck.key,
                "keyvalue":name,
                "keycount":buck.doc_count,
              };
              codes.push(gjfl);
        });
        result.code_counts=codes;
      }
      if(tmsjuhestatus.status==0){
        tmsjuhestatus.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhestatus.buckets.forEach(function(buck){
          var name = that.tm_status[buck.key];
          var st={
            "key":buck.key,
            "keyvalue":name,
            "keycount":buck.doc_count,
          };
          flztstatus.push(st);
        });
        result.status_counts=flztstatus;
      }
      if(tmsjuheyear.status==0){
        tmsjuheyear.buckets.sort(function(a,b){
          return b.key - a.key;
        });
        tmsjuheyear.buckets.forEach(function(buck){
          var year={
            "key":buck.key,
            "keycount":buck.doc_count,
          };
          year_count.push(year);
        });
        result.year_counts=year_count;
      }
      result.rows=sources;
      result.count=tmRegistNumsAll.length;
      return System.getResult2(result,null);
    }else{
      console.log("0000000000000000000000000000000000000000000000000");
      var data={
        tmRegistNumsAll:RegistNumsAll,
        sqlbtabkey:sqlbtabkey,
        flzttabkey:flzttabkey,
        sqnftabkey:sqnftabkey,
        ncltwo:ncltwo,
        pagesize:ps,
        page:cp
      };
      var tms =await this.GsbByTmSearchApi.imagesearchbycode(data);
      // console.log(tms);
      var tmsjuhe = await this.GsbByTmSearchApi.imagesearchjuheNcl(data);//获取ncl聚合结果
      console.log("tmsjuhe++++++++++++++++++++");
      console.log(tmsjuhe);
      var tmsjuhestatus = await this.GsbByTmSearchApi.imagesearchjuheStatus(data);//根据商标状态聚合
      console.log("tmsjuhestatus++++++++++++++++++++");
      console.log(tmsjuhestatus);
      // console.log(tmsjuhestatus);
      var tmsjuheyear = await this.GsbByTmSearchApi.imagesearchjuheYear(data);//根据商标year聚合
      console.log("tmsjuheyear++++++++++++++++++++");
      console.log(tmsjuheyear);
      // console.log(tmzchjuheyear);
      var that=this;
      if(tms.status == 0 && tms.data.length>0){
        result.count=tms.total;
        tms.data.forEach(function(tm){
          var source={
               sbmc:tm.tm_name,//商标名称
               sbpy:tm.tm_name_py,//商标拼音
               sbyw:tm.tm_name_en,//商标英文
               gjfl:tm.ncl_one_codes,//国际分类
               gjflname:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               sbzch:tm.tm_regist_num,//商标注册号
               sblx:that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
               sbzt:that.tm_status[tm.status],//商标状态
               sqrq:that.convertDate(tm.apply_day),//申请日期
               csrq:that.convertDate(tm.first_notice_day),//初审日期
               zcrq:that.convertDate(tm.original_regist_notice_day),//注册日期
               csggym:tm.first_notice_page_num,//初审公告页码
               zcr:tm.applicant_cn,//申请人
               jzrq:that.convertDate(tm.tm_end_day) ,//截止日期
               csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
               zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
               csgg:tm.first_notice_issue,//初审公告（期号）
               zcgg:tm.regist_notice_issue,//注册公告
               zcggym:tm.regist_notice_page_num,//注册公告页码
               yzcr:tm.original_applicant_cn,//原申请人
               zcdz:tm.applicant_cn_addr,//申请地址
               zcren:tm.applicant_en,//申请人enlish
               zcdzen:tm.applicant_en_addr,//申请地址enlish
               dljg:tm.tm_agency,//代理机构
               zxzt:"",//最新状态
               spfwxm:"",
               lcxx:"",
               logo:tm.pic_url,//商标图样
          };
          sources.push(source)
        });
          result.rows=sources;
      }
      if(tmsjuhe.status==0){
        tmsjuhe.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function(buck){
              var name = that.tm_gjfl[buck.key];
              var gjfl ={//国际分类
                "key":buck.key,
                "keyvalue":name,
                "keycount":buck.doc_count,
              };
              codes.push(gjfl);
        });
        result.code_counts=codes;
      }
      if(tmsjuhestatus.status==0){
        tmsjuhestatus.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuhestatus.buckets.forEach(function(buck){
          var name = that.tm_status[buck.key];
          var st={
            "key":buck.key,
            "keyvalue":name,
            "keycount":buck.doc_count,
          };
          flztstatus.push(st);
        });
        result.status_counts=flztstatus;
      }
      if(tmsjuheyear.status==0){
        tmsjuheyear.buckets.sort(function(a,b){
          return a.key - b.key;
        });
        tmsjuheyear.buckets.forEach(function(buck){
          var year={
            "key":buck.key,
            "keycount":buck.doc_count,
          };
          year_count.push(year);
        });
        result.year_counts=year_count;
      }
      console.log("--------------------------------------------------------------------");
      console.log(result);
      return System.getResult2(result,null);
    }
  }

  async tradeMarkDetail(query,obj){
    console.log(obj);
    var result={detaildata:[],nclexist:[],nclnotexist:[]};
    var sbzch=obj.sbzch;
    var gjfl=obj.gjfl;
    var sources=[];
    var data={
      sbzch:sbzch,
      gjfl:gjfl,
    };
    var data1={
      regNum:sbzch
    };
    var detailtms= await this.GsbByTmSearchApi.tradeMarkDetailapi(data);
    console.log("00000000000000000000000000000000000000000000000000000000");
    console.log(detailtms);
    var data2={
      reg_num:sbzch,
      nclone_code:gjfl
    }
    var qunzutms=await this.utilstmSve.getGroupNclInfo(data2);
    console.log("11111111111111111111111111111111111111111111111111111");
    console.log(qunzutms.data);
    if(qunzutms.status==0){
      var qunzuexist=[];
      var qunzuexistnorepeat=[]
      qunzutms.data.exist.forEach(function(c){
        var name = c.code+" "+c.small_name;
        if(qunzuexist.indexOf(name)==-1){
          var codejson={
            code:c.code,
            small_name:c.small_name
          }
          qunzuexist.push(name)
          qunzuexistnorepeat.push(codejson)
        }

      });
      result.nclexist=qunzuexistnorepeat;
      result.nclnotexist=qunzutms.data.not_exist;
    }

    var tms =await this.GsbByTmSearchApi.getTmFlow(data1);
    var that=this;
    var lcxx=[];
    if(tms.status == 0){
      tms.data.forEach(function(c){
        console.log(c);
        var date=that.convertDate(c.notice_data)
        var lc= date+" "+c.notice_type_name
        var lcjson={
          name:lc,
          link_url:c.link_url
        }
        lcxx.push(lcjson);
      });
    }
    console.log("lcxx====================================");
    console.log(lcxx);
    if(detailtms.status == 0 && detailtms.data.length>0){
      var tm=detailtms.data[0];
      var source={
           sbmc:tm.tm_name,//商标名称
           sbpy:tm.tm_name_py,//商标拼音
           sbyw:tm.tm_name_en,//商标英文
           gjfl:tm.ncl_one_codes,//国际分类号
           gjflname:this.tm_gjfl[tm.ncl_one_codes],//国际分类名称
           sbzch:tm.tm_regist_num,//商标注册号
           sblx:this.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
           sbzt:this.tm_status[tm.status],//商标状态
           sqrq:this.convertDate(tm.apply_day),//申请日期
           csrq:this.convertDate(tm.first_notice_day),//初审日期
           zcrq:this.convertDate(tm.original_regist_notice_day),//注册日期
           csggym:tm.first_notice_page_num,//初审公告页码
           zcr:tm.applicant_cn,//申请人
           jzrq:this.convertDate(tm.tm_end_day) ,//截止日期
           csggqh:tm.first_notice_issue==null?"":"第"+tm.first_notice_issue+"期",//初审公告（期号）
           zcggqh:tm.regist_notice_issue==null?"":"第"+tm.regist_notice_issue+"期",//注册公告
           csgg:tm.first_notice_issue,//初审公告（期号）
           zcgg:tm.regist_notice_issue,//注册公告
           zcggym:tm.regist_notice_page_num,//注册公告页码
           yzcr:tm.original_applicant_cn,//原申请人
           zcdz:tm.applicant_cn_addr,//申请地址
           zcren:tm.applicant_en,//申请人enlish
           zcdzen:tm.applicant_en_addr,//申请地址enlish
           dljg:tm.tm_agency,//代理机构
           lcxx:lcxx,
           logo:tm.pic_url,//商标图样
      };
      sources.push(source);
    }
    // else{
    //   var source={
    //        sbmc:"",//商标名称
    //        sbpy:"",//商标拼音
    //        sbyw:"",//商标英文
    //        gjfl:"",//国际分类
    //        sbzch:sbzch,//商标注册号
    //        gjflname:"",//国际分类名称
    //        sblx:"",//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
    //        sbzt:"",//商标状态
    //        sqrq:"",//申请日期
    //        csrq:"",//初审日期
    //        zcrq:"",//注册日期
    //        csggym:"",//初审公告页码
    //        zcr:"",//申请人
    //        jzrq:"",//截止日期
    //        csggqh:"",//初审公告（期号）
    //        zcggqh:"",//注册公告
    //        zcggym:"",//注册公告页码
    //        yzcr:"",//原申请人
    //        zcdz:"",//申请地址
    //        dljg:"",//代理机构
    //        zxzt:"",//最新状态
    //        spfwxm:"",
    //        lcxx:"",
    //        logo:"",//商标图样
    //   };
    //   sources.push(source);
    // }
    result.detaildata=sources;
    console.log(result);
    return System.getResult2(result,null);
  }

  async nclFuwuSearch(query,obj){
    var result ={rows:[],count:0};
    var nclfuwu = obj.nclfuwu;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var sources=[];
    var data={
      nclfuwu:nclfuwu,
      pagesize:pageSize,
      page:currentPage
    }
    var fuwutms= await this.GsbByTmSearchApi.getNclByLikeName(data);
    var ncltwo={
      level:2
    }
    var tmpGetTwoNclList=await this.GsbByTmSearchApi.getNcl(ncltwo);
    var getTwoNclList=tmpGetTwoNclList.data;
    console.log("00000000000000000000000000000000000000000000000000000000");
    // console.log(fuwutms);
    // console.log(tmpGetTwoNclList);
    var that=this;
    if(fuwutms.status == 0){
      fuwutms.data.forEach(function(tm){
        // console.log(tm);
        var tmpTwoNclFind = getTwoNclList.find(f=>(f.code==tm.pid));
        // console.log(tmpTwoNclFind);
        // console.log("------------------------------------------");
          console.log(tm);
          console.log("+++++++++++++++++++++++++");
          console.log(tmpTwoNclFind);
          var source={
               nclthreecode:tm.code,//三类尼斯编号
               nclthreename:tm.name,//三类尼斯名字
               ncltwocode:tmpTwoNclFind.code,//二类尼斯编号
               ncltwoname:tmpTwoNclFind.name,//三类尼斯名字
               nclonecode:tmpTwoNclFind.pid,//国际分类
               nclonename:that.tm_gjfl[Number(tmpTwoNclFind.pid)],//国际分类名称
          };
          sources.push(source);
      });
      result.count=fuwutms.total;
      result.rows=sources;
    }
    console.log(result);
    return System.getResult2(result,null);
  }

  async gettwoNcl(query,obj){
    var result ={rows:[]};
    var pid = obj.code;
    console.log("-------------------------------");
    var sources=[];
    if(pid.length==1){
      pid="0"+pid;
    }
    var data={
      "pid":pid
    }
    var tmpGetTwoNclList=await this.GsbByTmSearchApi.gettwoNclList(data);
    var that=this;
    if(tmpGetTwoNclList.status == 0){
      tmpGetTwoNclList.data.forEach(function(tm){
          var source={
               code:tm.code,//2类尼斯编号
               name:tm.name//2类尼斯名字
          };
          sources.push(source);
      });
      result.rows=sources;
    }
    return System.getResult2(result,null);
  }

  async noticequery(query,obj){
    var result = {rows:[],count:""};
    var sources=[];
    var noticenumber=obj.noticenumber;
    var applynumber=obj.applynumber;
    var tmname=obj.tmname;
    var applier=obj.applier;
    var noticetype=obj.noticetype;
    var nclNum=obj.nclNum;
    var pageSize=obj.pageSize;
    var currentPage=obj.currentPage;
    var data ={
      noticenumber: noticenumber,
      applynumber:applynumber,
      tmname: tmname,
      applier: applier,
      noticetype: noticetype,
      nclNum: nclNum,
      pagesize:pageSize,
      page:currentPage
    }

    var notice=await this.GsbByTmSearchApi.noticeQueryAPi(data);
    console.log(notice);
    if(notice.status==0){
      result.count=notice.total;
      for (var i = 0; i < notice.data.length; i++) {
        var tm =notice.data[i];
        var ncls="";
        if(tm!=null){
          tm.ncl_ones.sort(function(a,b){
            return a - b;
          });
          console.log(tm.ncl_ones);
          tm.ncl_ones.forEach(function(c){
            ncls=ncls+c+" ";
          });
          var source={
               sbmc:tm.tm_name,//商标名称
               sbzch:tm.tm_regist_num,//商标号
               sblb:ncls,//类别
               zcr:tm.proposer,//申请人
               ggqh:tm.notice_issue,//公告期号
               ggrq:this.convertDate(tm.notice_data),//公告riqi
               pagenumber:tm.page_no,//公告页码
               gglx:tm.notice_type_name,//公告类型
               linkurl:tm.link_url,   //连接地址
               logo:tm.pic_url //图片地址
          };
        }
        sources.push(source);
      }
    }
    result.rows=sources;
    return System.getResult2(result,null);
  }

  async getNclDetail(query,obj){
    var result={classification:"",construction:"",data:[]};
    var onecode=obj.number;
    var sources=[];
    if(onecode.length==1){
      onecode="0"+onecode;
    }
    var data={
      onecode:onecode
    }
    var tmpGetOneNcl=await this.GsbByTmSearchApi.getNclOne(data);
    console.log("nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn");
    console.log(tmpGetOneNcl);
    if(tmpGetOneNcl.status==0){
      var tm = tmpGetOneNcl.data[0];
      result.classification="第"+tm.code+"类-"+tm.name;
      result.construction=tm.description;
    }
    var data1={
      pid:onecode
    }
    var that=this;
    var tmpGetTwoNclList = await this.GsbByTmSearchApi.gettwoNclList(data1);
    console.log(tmpGetTwoNclList);
    if(tmpGetTwoNclList.status==0){
      for (var i = 0; i < tmpGetTwoNclList.data.length; i++) {
        var tm =tmpGetTwoNclList.data[i];
        if(tm!=null){
          var smallclassification=tm.code+" "+tm.name;
          console.log(tm);
          var piddata={
            twopid:tm.code,
          };
          var threeNcllist= await that.GsbByTmSearchApi.getthreeNclList(piddata);
          console.log("------------------------------------------------------");
          // console.log(threeNcllist);
          var content="";
          var xinzeng="";
          if(threeNcllist.status==0){
            threeNcllist.data.forEach(function(t){
              if(t.code){
                content=t.name+t.code+","+content;
              }else{
                xinzeng=t.name+","+xinzeng;
              }
            });
          }
          var source={
            smallclassification:smallclassification,
            content:content,
            xinzeng:xinzeng
          }
        }
        sources.push(source);
      }
    }
    console.log(sources);
    result.data=sources;
    return System.getResult2(result,null);
  }

  async aibynclone(obj,pobj){
    var tmName=pobj.tmName;
    var nclonecode=pobj.nclonecode;
    var result={};
    if( tmName == null || tmName == '' || tmName == 'undefined' )
    {
      result={code:-1,msg:"参数错误",data:null};
    }
    var rate = await this.GsbByTmSearchApi.tmncloneSearch(pobj);
    result={code:1,msg:"成功",data:rate};
    return System.getResult2(result,null);
  }

  async rediscache(query,obj){
    var result={redislist:[]};
    var openId=obj.user.openId
    var mark=obj.mark;
    var data={
      openId:openId,
      mark:mark
    };
    var rediscache =await this.GsbByTmSearchApi.opCache(data);
    console.log(rediscache);
    if(rediscache.code==1){
      result.redislist=rediscache.data.reverse();
    }
    return System.getResult2(result,null);
  }

  async noticesearch(query,obj){
    var result={sbmc:"",linkurl:""};
    var sbzch=obj.sbzch;
    var csggqh=obj.csggqh;

    var data={
      sbzch:sbzch,
      csggqh:csggqh
    };
    var notice=await this.GsbByTmSearchApi.noticeSearch(data);
    console.log(notice);
    if(notice.status==0){
      if(notice.data.length>0){
        result.sbmc=notice.data[0].tm_name;
        result.linkurl=notice.data[0].link_url;
      }
    }
    return System.getResult2(result,null);
  }
  async noticezcggsearch(query,obj){
    var result={sbmc:"",linkurl:""};
    var sbzch=obj.sbzch;
    var zcggqh=obj.zcggqh;

    var data={
      sbzch:sbzch,
      zcggqh:zcggqh
    };
    var notice=await this.GsbByTmSearchApi.noticezcgg(data);
    console.log(notice);
    if(notice.status==0){
      if(notice.data.length>0){
        result.sbmc=notice.data[0].tm_name;
        result.linkurl=notice.data[0].link_url;
      }
    }
    return System.getResult2(result,null);
  }
  async sbzuixinsearch(){
    var result={zuixinshouli:"",zuixinchushen:"",zuixinxiazheng:""};
    var zuixinshouli= await this.GsbByTmSearchApi.sbzuixinsearchapi();
    var zuixinchushen= await this.GsbByTmSearchApi.sbzuixinchushen();
    var zuixinxiazheng= await this.GsbByTmSearchApi.sbzuixinxiazheng();
    console.log("============================");
    console.log(zuixinshouli);
    if(zuixinshouli.status==0){
      var shouli=zuixinshouli.data[0];
      result.zuixinshouli=shouli.apply_day_format;
    }
    if(zuixinchushen.status==0){
      var chushen=zuixinchushen.data[0];
      result.zuixinchushen=chushen.apply_day_format;
    }
    if(zuixinxiazheng.status==0){
      var xiazheng=zuixinxiazheng.data[0];
      result.zuixinxiazheng=xiazheng.apply_day_format;
    }
    console.log(result);
    return System.getResult2(result,null);
  }
  async noticequeryTMZCSQ(query,obj){
    var result = {rows:[],selectdata:[]};
    var sources=[];
    var selects=[]
    var data ={
      noticetype: "TMZCSQ"
    }
    var that=this;
    var notice=await this.GsbByTmSearchApi.noticeQueryTMZCSQ(data);
    console.log(notice);
    if(notice.status==0){
      notice.buckets.forEach(function(buck){
        var notice_issue = buck.notice_issue;
        var date = that.convertDate(buck.date);
        var enddate = that.convertDate1(buck.date);
        console.log(date+";+++++++++++++++++++++++++"+enddate);
        var sdate = new Date(); 
          　　 var now = new Date(enddate); 
          　　 var days = now.getTime() - sdate.getTime(); 
          　　 var day = parseInt(days / (1000 * 60 * 60 * 24));
        var lastday="";
        if(day>0){
          lastday="剩余"+day+"天";
        }else{
          lastday="已过期"+Math.abs(day)+"天";
        } 
        var source={
          "notice_issue":notice_issue,
          "date":date,
          "enddate":enddate,
          "lastday":lastday
        };
        sources.push(source);
        var select={
          value:notice_issue,
          label:notice_issue+" ("+date+")"
        };
        selects.push(select);
      });
    }
    result.rows=sources;
    result.selectdata=selects;
    console.log(result);
    return System.getResult2(result,null);
  }

  async getnclonedetail(query){
    var result = {nclOnes:[]};
    var ncls = await this.GsbByTmSearchApi.getNclLevel();
    var nclones =[];
    if(ncls.status==0){
      ncls.data.sort(function(a,b){
        return a.code - b.code;
      });
      ncls.data.forEach(function(da){
        var nc ={//国际分类
        	"code":da.code,
        	"name":da.name,
        	"description":da.description,
        };
        nclones.push(nc);
      });
      result.nclOnes=nclones;
    }
    return System.getResult2(result,null);
  }

}
module.exports=tmqueryCtl;

// var task = new tmqueryCtl();
// var obj ={
//     regMan: "云飞",
//     sqlbtabkey: "",
//     flzttabkey: "",
//     sqnftabkey: "",
//     zcrname:"",
//     xcl: [],
//     pageSize: "20",
//     currentPage: "1"
// };
// task.findTrademarkzcr(obj).then(d=>{
//   console.log("ddddddddddddddddddddddddddddddddddddd");
//   console.log(d);
// })
// task.getnclonedetail().then(d=>{
//   console.log("ddddddddddddddddddddddddddddddddddddd");
//     console.log(d);
// })
