var System = require("../../../system");
var settings = require("../../../../config/settings");
const ApiBase = require("../../api.base");
var mongoose = require('mongoose');
var Schema = mongoose.Schema({
    company_name: { type: String},

})
const ad = mongoose.model('taierphones', Schema);
const logCtl = System.getObject("web.common.oplogCtl");
class GsbMgSearchApi extends ApiBase {
    constructor() {
        super();
        this.mgdbModel = System.getObject("db.tmquery.mgconnection").getModel("taierphones");
    };
    async getConvertSemiangleStr(str) {
        var result = "";
        str = str.replace(/\s+/g, "");
        var len = str.length;
        for (var i = 0; i < len; i++) {
            var cCode = str.charCodeAt(i);
            //全角与半角相差（除空格外）：65248（十进制）
            cCode = (cCode >= 0xFF01 && cCode <= 0xFF5E) ? (cCode - 65248) : cCode;
            //处理空格
            cCode = (cCode == 0x03000) ? 0x0020 : cCode;
            result += String.fromCharCode(cCode);
        }
        return result;
    };
    async phoneNameSearch(obj) {
        // var data = await this.checkKey(obj.appKey);
        // if (data && data.status && data.status == -1) {
        //     return data;
        // }
        var companyName = obj.companyName == null ? "" : obj.companyName;
        companyName = await this.getConvertSemiangleStr(companyName);
        var pageSize = obj.pageSize == null ? 15 : obj.pageSize;
        if (obj.currentPage == null) {
            var from = 0;
        } else {
            var from = Number((obj.currentPage - 1) * obj.pageSize);
        }
        var skipnum = (obj.currentPage - 1) * pageSize;

        var params = {
            "company_name": companyName
        }
        var opt = { "_id": 0 };

        var rtn = null;
        var list = {}
        var phone = []
        list.company_name = companyName
        try {
            rtn = await this.mgdbModel.find(params, opt).skip(skipnum).limit(pageSize).exec()
            var data = {
                "result": 1,
                "totalSize": rtn.length,
                "pageSize": pageSize,
                "currentPage": obj.currentPage - 1, "list": rtn
            };
            var a = { status: 0, msg: "操作成功", data: data };
            return a;
        } catch (e) {
            //日志记录
            logCtl.error({
                optitle: "mg操作失败,通过公司名称查电话-error",
                op: "base/api/impl/phonesearch/phoneNameSearch",
                content: e.stack,
                clientIp: ""
            });
            // console.log(e.stack, "mg操作失败");
            return { status: -1, msg: "操作失败", data: null };
        }
    }


}
module.exports = GsbMgSearchApi;
