var System = require("../../../system");
var settings = require("../../../../config/settings");
const ApiBase = require("../../api.base");
class GsbIcSearchApi extends ApiBase {
  constructor() {
    super();
    this.iccompanynameSearchUrl = settings.apiconfig.iccompanynameSearchUrl(settings.env);
    this.phonesearch = System.getObject("api.tmquery.phonesearch");
    
  };
  async getConvertSemiangleStr(str) {
    var result = "";
    str = str.replace(/\s+/g, "");
    var len = str.length;
    for (var i = 0; i < len; i++) {
      var cCode = str.charCodeAt(i);
      //全角与半角相差（除空格外）：65248（十进制）
      cCode = (cCode >= 0xFF01 && cCode <= 0xFF5E) ? (cCode - 65248) : cCode;
      //处理空格
      cCode = (cCode == 0x03000) ? 0x0020 : cCode;
      result += String.fromCharCode(cCode);
    }
    return result;
  };
  async companyonesearch(obj) {
    var self = this;
    var isVerify = obj.isVerify || 1;
    if (isVerify == 1) {
      var data = await this.checkKey(obj.appKey);
      if (data && data.status && data.status == -1) {
        return data;
      }
    }
    var companyName = obj.companyName == null ? "" : obj.companyName;
    companyName = await this.getConvertSemiangleStr(companyName);
    var pageSize = 1;
    if (obj.currentPage == null) {
      var from = 0;
    } else {
      var from = Number((obj.currentPage - 1) * obj.pageSize);
    }

    var reqUrl = this.iccompanynameSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [

            {
              "term": {
                "company_name.raw": companyName
              }
            }
          ]
        }
      },
      "from": from,
      "size": pageSize,
      "_source": [
        "company_id",
        "company_province",
        "company_domain",
        "legal_person",
        "reg_status",
        "reg_unit",
        "reg_capital",
        "estibish_time",
        "credit_code",
        "reg_number",
        "org_number",
        "company_type",
        "reg_institute",
        "reg_location",
        "business_scope",
        "approved_time",
        "from_time",
        "to_time",
        "reg_unit"
      ]
    };
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      var sources = [];
      var data = {
        "result": 1,
        "totalSize": j.hits.total,
        "pageSize": 1,
        "currentPage": obj.currentPage - 1, "list": sources
      };
      for (var k = 0; k < j.hits.hits.length; k++) {
        var c = j.hits.hits[k];
        if (c._source.approved_time != null) {
          var time3 = new Date(c._source.approved_time * 1000);
          c._source.approved_time = time3.toLocaleDateString();
        }
        if (c._source.from_time != null) {
          var time3 = new Date(c._source.from_time * 1000);
          c._source.from_time = time3.toLocaleDateString();
        }
        if (c._source.to_time != null) {
          var time3 = new Date(c._source.to_time * 1000);
          c._source.to_time = time3.toLocaleDateString();
        }
        if (c._source.estibish_time != null) {
          var time3 = new Date(c._source.estibish_time * 1000);
          c._source.estibish_time = time3.toLocaleDateString();
        }
        if (c._source.company_domain) {
          var pobj = {
            appKey: obj.appKey,
            companyName: c._source.company_domain
          }
          var phones = await self.phonesearch.phoneNameSearch(pobj);
          if (phones.status == 0 && phones.data.list.length > 0) {
            c._source.tel_info = phones.data.list[0]._doc.phone_number;
            c._source.email_info = phones.data.list[0]._doc.email;
          }
        }
        if (c._source.reg_unit == null) {
          c._source.reg_unit = "万人民币";
        }
        if (c._source.reg_capital == null) {
          c._source.reg_capital = "未公开";
          c._source.reg_unit = "";
        }
        var source = {
          name: c._source.company_domain,
          legalRepresentative: c._source.legal_person,
          managementState: c._source.reg_status,
          registeredCapital: c._source.reg_capital + c._source.reg_unit,
          foundedTime: c._source.estibish_time,
          creditCode: c._source.credit_code,
          registrID: c._source.reg_number,
          organizationCode: c._source.org_number,
          companyType: c._source.company_type,
          registerOffice: c._source.reg_institute,
          businessAddress: c._source.reg_location,
          scope: c._source.business_scope,
          dateIssue: c._source.approved_time,
          businessTerm: c._source.from_time + "至" + c._source.to_time,
          tel_info: c._source.tel_info,
        };
        sources.push(source);
      }
      var a = { status: 0, msg: "操作成功", data: data };
      return a;
    } catch (e) {
      return { status: -1, msg: "操作失败", data: null };
    }
  };
}
module.exports = GsbIcSearchApi;
// var capi=new GsbTmSearchApi();
// capi.xzSearch({}).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
