const system=require("../system");
class APIBase{
    constructor(){
        this.cacheManager=system.getObject("db.common.cacheManager");
        // this. apitradeSvr = system.getObject("service.common.apitradeSve");
        this.logCtl = system.getObject("web.common.oplogCtl");
        this.apiDoc={
            group:"逻辑分组",
            desc:"请对当前类进行描述",
            exam:"概要示例",
            methods:[]
        };
        // this.initClassDoc();
    }
    initClassDoc(){
        this.descClass();
        this.descMethods();
    }
    descClass(){
        var classDesc=this.classDesc();
        this.apiDoc.group=classDesc.groupName;
        this.apiDoc.desc=classDesc.desc;
        this.apiDoc.exam=classDesc.exam;
    }
    classDesc(){
        throw new Error(`
        请重写classDesc对当前的类进行描述，返回如下数据结构
        {
            groupName:"认证",
            desc:"关于认证的类",
            exam:"",
        }
        `);
    }
    descMethods(){
        var methoddescs=this.methodDescs();
        for(var methoddesc of methoddescs){
            for(var paramdesc of methoddesc.paramdescs){
                this.descMethod(methoddesc.methodDesc,methoddesc.methodName
                    ,paramdesc.paramDesc,paramdesc.paramName,paramdesc.paramType,
                    paramdesc.defaultValue,methoddesc.rtnTypeDesc,methoddesc.rtnType);
            }
        }
    }
    methodDescs(){
        throw new Error(`
        请重写methodDescs对当前的类的所有方法进行描述，返回如下数据结构
        [
            {
                methodDesc:"生成访问token",
                methodName:"getAccessKey",
                paramdescs:[
                    {
                        paramDesc:"访问appkey",
                        paramName:"appkey",
                        paramType:"string",
                        defaultValue:"x",
                    },
                    {
                        paramDesc:"访问secret",
                        paramName:"secret",
                        paramType:"string",
                        defaultValue:null,
                    }
                ],
                rtnTypeDesc:"xxxx",
                rtnType:"xxx"
            }
        ]
        `);
    }
     descMethod(methodDesc,methodName,paramDesc,paramName,paramType,defaultValue,rtnTypeDesc,rtnType){
        var mobj=this.apiDoc.methods.filter((m)=>{
            if(m.name==methodName){
                return true; 
            }else{
                return false;
            }
        })[0];
        var param={
            pname:paramName,
            ptype:paramType,
            pdesc:paramDesc,
            pdefaultValue:defaultValue,
        };
        if(mobj!=null){
            mobj.params.push(param);
        }else{
            this.apiDoc.methods.push(
                {
                    methodDesc:methodDesc?methodDesc:"",
                    name:methodName,
                    params:[param],
                    rtnTypeDesc:rtnTypeDesc,
                    rtnType:rtnType
                }
            );
        }
    }
    async isExistInNoAuthMainfest(gname,methodname){
        var fullname=gname+"."+methodname;
        var lst=[
          
        ];
        var x=lst.indexOf(fullname);
        return x>=0;
    }
    async checkAcck(gname,methodname,pobj,query,req){
        var isExistInNoAuth=await this.isExistInNoAuthMainfest(gname,methodname);
        if(!isExistInNoAuth){//在验证请单里面,那么就检查访问token
            var ak=req.headers["accesskey"];
            var app= await this.cacheManager["ApiAccessKeyCheckCache"].cache(ak,{status:true},3600);
            if(!app){
                return false;
            }else{
                return true;
            }
        }
        return true;
    }
    async doexec(methodname,pobj,query){
        try{
            var rtn= await this[methodname](pobj,query);
          return rtn;
        }catch(e){
          this.logCtl.error({
            optitle: "api调用出错",
            op: pobj.classname + "/" + methodname,
            content: e.stack,
            clientIp:  pobj.clientIp
          });
          return system.getResult2(null,null,"ok","出现异常，请联系管理员");
        }
      }
}
module.exports=APIBase;

  