<a name="menu" href="/doc">返回主目录</a>
1. [商标精确检索接口](#findTrademarkNameAccurate)
1. [近似商标查询接口](#findTrademarkName)
1. [商标申请号查询接口](#findTrademarkzchAccurate)
1. [申请人查询接口](#findTrademarkzcr)
1. [获取检索图片url](#getCropperPic)
1. [图形检索](#imagequery)
1. [图形检索查询](#findImageSearch)
1. [商标详情查询接口](#tradeMarkDetail)
1. [最新商标查询](#sbzuixinsearch)
1. [近12期初审公告查询接口](#noticequeryTMZCSQ)
1. [公告列表检索接口](#noticequery)
1. [注册公告详情查询](#noticezcggsearch)
1. [初审公告详情查询接口](#noticesearch)
1. [查询商标申请企业信息接口](#getCompanyInfoNoUser)
1. [尼斯详情接口](#getNclDetail)
1. [获取尼斯群组](#gettwoNcl)
1. [尼斯分类检索](#nclFuwuSearch)
1. [商标智能分析](#bycznfx)
1. [商标报告](#tmreport)



## **<a name="findTrademarkNameAccurate"> 商标精确检索接口</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：findTrademarkNameAccurate
``` javascript
{ 
"tmName": "萌颜",//商标名称
"sqlbtabkey": "",//商标类别
"flzttabkey": "",//法律状态
"sqnftabkey": "",//申请年份
"ncl": [],//尼斯大类 
"xcl": [],//尼斯群组
"nclNum": [],//尼斯大类 
"pageSize": 20,//每页数量
"currentPage": 1 //当前页
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "rows": [
            {
                "sbmc": "萌颜",//商标名称
                "sbpy": null,//商标拼音
                "sbyw": null,//商标英文
                "gjfl": "28",//国际分类
                "gjflname": "28类 健身器材",//国际分类名称
                "sbzch": "37208280",//商标注册号
                "sblx": "普通商标",//商标类型
                "sbzt": "申请中",//商标状态
                "sqrq": "2019-04-01",//申请日期
                "csrq": "",//初审日期
                "zcrq": "",//注册日期
                "csggym": null,//初审公告页码
                "zcr": "北京联大共享科技有限公司",//注册人
                "jzrq": "",//截止日期
                "csggqh": "",//初审公告期号
                "zcggqh": "",//注册公告期号
                "csgg": null,//初审公告
                "zcgg": null,//注册公告
                "zcggym": null,//注册公告页码
                "yzcr": null,//原注册人
                "zcdz": "北京市房山区良乡凯旋大街建设路18号-D740",//注册地址
                "zcren": null,//注册人
                "zcdzen": null,//注册地址英文
                "dljg": "北京创知厚德科技有限公司",//代理机构
                "zxzt": "",//最新状态
                "spfwxm": "",//商品服务码
                "lcxx": "",//流程信息
                "sbqz": "2812,2804,2803,2807,2802,2801",//商标群组
                "logo": "http://43.247.184.94:7170/Img/000/372/082/80A/1412d976-0078-47ec-bcd7-8c631dec9ff6.jpg"//商标图样
            }
        ],
        "code_counts": [//尼斯大类聚合统计
            {
                "key": "3",
                "keyvalue": "03类 日化用品",//大类名称
                "keycount": 3 //大类数量-----------------以下雷同
            },
            {
                "key": "9",
                "keyvalue": "09类 科学仪器",
                "keycount": 3
            },
            {
                "key": "10",
                "keyvalue": "10类 医疗器械",
                "keycount": 1
            },
            {
                "key": "14",
                "keyvalue": "14类 珠宝钟表",
                "keycount": 1
            },
            {
                "key": "18",
                "keyvalue": "18类 皮革皮具",
                "keycount": 3
            },
            {
                "key": "20",
                "keyvalue": "20类 家具",
                "keycount": 1
            },
            {
                "key": "25",
                "keyvalue": "25类 服装鞋帽",
                "keycount": 1
            },
            {
                "key": "26",
                "keyvalue": "26类 钮扣拉链",
                "keycount": 1
            },
            {
                "key": "27",
                "keyvalue": "27类 地毯席垫",
                "keycount": 2
            },
            {
                "key": "28",
                "keyvalue": "28类 健身器材",
                "keycount": 1
            },
            {
                "key": "35",
                "keyvalue": "35类 广告销售",
                "keycount": 1
            },
            {
                "key": "38",
                "keyvalue": "38类 通讯服务",
                "keycount": 1
            },
            {
                "key": "41",
                "keyvalue": "41类 教育娱乐",
                "keycount": 1
            },
            {
                "key": "42",
                "keyvalue": "42类 科技服务",
                "keycount": 2
            },
            {
                "key": "44",
                "keyvalue": "44类 医疗园艺",
                "keycount": 1
            },
            {
                "key": "45",
                "keyvalue": "45类 社会服务",
                "keycount": 1
            }
        ],
        "status_counts": [//商标状态聚合
            {
                "key": 1,
                "keyvalue": "申请中",//状态名称
                "keycount": 3 //数量
            },
            {
                "key": 3,
                "keyvalue": "已注册",
                "keycount": 16
            },
            {
                "key": 4,
                "keyvalue": "已无效",
                "keycount": 5
            }
        ],
        "no_code_counts": [//未注册大类统计
            {
                "name": "01类 化学原料" //大类名称
            },
            {
                "name": "02类 颜料油漆"
            },
            {
                "name": "04类 燃料油脂"
            },
            {
                "name": "05类 医药"
            },
            {
                "name": "06类 金属材料"
            },
            {
                "name": "07类 机械设备"
            },
            {
                "name": "08类 手工器械"
            },
            {
                "name": "11类 灯具空调"
            },
            {
                "name": "12类 运输工具"
            },
            {
                "name": "13类 军火烟火"
            },
            {
                "name": "15类 乐器"
            },
            {
                "name": "16类 办公用品"
            },
            {
                "name": "17类 橡胶制品"
            },
            {
                "name": "19类 建筑材料"
            },
            {
                "name": "21类 厨房洁具"
            },
            {
                "name": "22类 绳网袋蓬"
            },
            {
                "name": "23类 纱线丝"
            },
            {
                "name": "24类 布料床单"
            },
            {
                "name": "29类 食品"
            },
            {
                "name": "30类 方便食品"
            },
            {
                "name": "31类 农林生鲜"
            },
            {
                "name": "32类 啤酒饮料"
            },
            {
                "name": "33类 酒"
            },
            {
                "name": "34类 烟草烟具"
            },
            {
                "name": "36类 金融物管"
            },
            {
                "name": "37类 建筑修理"
            },
            {
                "name": "39类 运输贮藏"
            },
            {
                "name": "40类 材料加工"
            },
            {
                "name": "43类 餐饮住宿"
            }
        ],
        "year_counts": [//注册年份统计
            {
                "key": 2019,//年份
                "keycount": 3//数量
            },
            {
                "key": 2018,
                "keycount": 7
            },
            {
                "key": 2017,
                "keycount": 8
            },
            {
                "key": 2016,
                "keycount": 3
            },
            {
                "key": 2015,
                "keycount": 3
            }
        ],
        "count": 24 //总数
    },
    "bizmsg": "empty"
}

```

## **<a name="findTrademarkName"> 近似商标查询接口</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：findTrademarkName

``` javascript
{
  "tmName": "萌颜",//商标名称
  "sqlbtabkey": "",//商标类别
  "flzttabkey": "",//法律状态
  "sqnftabkey": "",//申请年份
  "ncl": [],//尼斯大类
  "xcl": [],//尼斯群组
  "nclNum": [],//尼斯大类
  "sbtjdata":["近似", "变字", "拼音", "同义词", "形近字", "换序", "包含该商标"],//商标筛选条件
  "pageSize": 20,//每页数量
  "currentPage": 1 //当前页
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "rows": [
            {
                "sbmc": "萌颜",//商标名称
                "sbpy": null,//商标拼音
                "sbyw": null,//商标英文
                "gjfl": "28",//国际分类
                "gjflname": "28类 健身器材",//国际分类名称
                "sbzch": "37208280",//商标注册号
                "sblx": "普通商标",//商标类别
                "sbzt": "申请中",//商标状态
                "sqrq": "2019-04-01",//申请日期
                "csrq": "",//初审日期
                "zcrq": "",//注册日期
                "csggym": null,//初审公告页码
                "zcr": "北京联大共享科技有限公司",//注册人
                "jzrq": "",//截止日期
                "csggqh": "",//初审公告期号
                "zcggqh": "",//注册公告期号
                "csgg": null,//初审公告
                "zcgg": null,//注册公告
                "zcggym": null,//注册公告页码
                "yzcr": null,//原注册人
                "zcdz": "北京市房山区良乡凯旋大街建设路18号-D740",//注册地址
                "zcren": null,//注册人英文
                "zcdzen": null,//注册地址英文
                "dljg": "北京创知厚德科技有限公司",//代理机构
                "zxzt": "",//最新状态
                "spfwxm": "",//商品服务项目
                "lcxx": "",//流程信息
                "sbqz": "2812,2804,2803,2807,2802,2801",//商标群组
                "logo": "http://43.247.184.94:7170/Img/000/372/082/80A/1412d976-0078-47ec-bcd7-8c631dec9ff6.jpg"//商标图样
            }
        ],
        "code_counts": [//尼斯大类统计
            {
                "key": "3",
                "keyvalue": "03类 日化用品",//大类名称
                "keycount": 3//数量
            },
            {
                "key": "9",
                "keyvalue": "09类 科学仪器",
                "keycount": 3
            },
            {
                "key": "10",
                "keyvalue": "10类 医疗器械",
                "keycount": 1
            },
            {
                "key": "14",
                "keyvalue": "14类 珠宝钟表",
                "keycount": 1
            },
            {
                "key": "18",
                "keyvalue": "18类 皮革皮具",
                "keycount": 3
            },
            {
                "key": "20",
                "keyvalue": "20类 家具",
                "keycount": 1
            },
            {
                "key": "25",
                "keyvalue": "25类 服装鞋帽",
                "keycount": 1
            },
            {
                "key": "26",
                "keyvalue": "26类 钮扣拉链",
                "keycount": 1
            },
            {
                "key": "27",
                "keyvalue": "27类 地毯席垫",
                "keycount": 2
            },
            {
                "key": "28",
                "keyvalue": "28类 健身器材",
                "keycount": 1
            },
            {
                "key": "35",
                "keyvalue": "35类 广告销售",
                "keycount": 1
            },
            {
                "key": "38",
                "keyvalue": "38类 通讯服务",
                "keycount": 1
            },
            {
                "key": "41",
                "keyvalue": "41类 教育娱乐",
                "keycount": 1
            },
            {
                "key": "42",
                "keyvalue": "42类 科技服务",
                "keycount": 2
            },
            {
                "key": "44",
                "keyvalue": "44类 医疗园艺",
                "keycount": 1
            },
            {
                "key": "45",
                "keyvalue": "45类 社会服务",
                "keycount": 1
            }
        ],
        "status_counts": [//状态统计
            {
                "key": 1,
                "keyvalue": "申请中",//状态
                "keycount": 3//数量
            },
            {
                "key": 3,
                "keyvalue": "已注册",
                "keycount": 16
            },
            {
                "key": 4,
                "keyvalue": "已无效",
                "keycount": 5
            }
        ],
        "no_code_counts": [//未注册尼斯大类
            {
                "name": "01类 化学原料"
            },
            {
                "name": "02类 颜料油漆"
            },
            {
                "name": "04类 燃料油脂"
            },
            {
                "name": "05类 医药"
            },
            {
                "name": "06类 金属材料"
            },
            {
                "name": "07类 机械设备"
            },
            {
                "name": "08类 手工器械"
            },
            {
                "name": "11类 灯具空调"
            },
            {
                "name": "12类 运输工具"
            },
            {
                "name": "13类 军火烟火"
            },
            {
                "name": "15类 乐器"
            },
            {
                "name": "16类 办公用品"
            },
            {
                "name": "17类 橡胶制品"
            },
            {
                "name": "19类 建筑材料"
            },
            {
                "name": "21类 厨房洁具"
            },
            {
                "name": "22类 绳网袋蓬"
            },
            {
                "name": "23类 纱线丝"
            },
            {
                "name": "24类 布料床单"
            },
            {
                "name": "29类 食品"
            },
            {
                "name": "30类 方便食品"
            },
            {
                "name": "31类 农林生鲜"
            },
            {
                "name": "32类 啤酒饮料"
            },
            {
                "name": "33类 酒"
            },
            {
                "name": "34类 烟草烟具"
            },
            {
                "name": "36类 金融物管"
            },
            {
                "name": "37类 建筑修理"
            },
            {
                "name": "39类 运输贮藏"
            },
            {
                "name": "40类 材料加工"
            },
            {
                "name": "43类 餐饮住宿"
            }
        ],
        "year_counts": [//年份统计
            {
                "key": 2019,//年份
                "keycount": 3//数量
            },
            {
                "key": 2018,
                "keycount": 7
            },
            {
                "key": 2017,
                "keycount": 8
            },
            {
                "key": 2016,
                "keycount": 3
            },
            {
                "key": 2015,
                "keycount": 3
            }
        ],
        "count": 24//总数
    },
    "bizmsg": "empty"
}

```


## **<a name="findTrademarkzchAccurate"> 商标申请号查询接口</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：findTrademarkzchAccurate

``` javascript
{
    "regNum": "5912089",//注册号
    "sqlbtabkey": "",//申请类别
    "flzttabkey": "",//法律状态
    "sqnftabkey": "",//申请年份
    "xcl": [],//商标群组
    "pageSize": 20,//每页数量
    "currentPage": 1//当前页
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "rows": [
            {
                "sbmc": "张三",//商标名称
                "sbpy": "zhangsan",//商标拼音
                "sbyw": null,//商标英文
                "gjfl": "9",//国际分类
                "gjflname": "09类 科学仪器",//国际分类名称
                "sbzch": "5912089",//商标注册号
                "sblx": "特殊商标",//商标类型
                "sbzt": "已注册",//商标状态
                "sqrq": "2007-02-12",//申请日期
                "csrq": "2009-09-13",//初审日期
                "zcrq": "2009-12-13",//注册日期
                "csggym": 1225,//初审公告页码
                "zcr": "魏文道***",//注册人
                "jzrq": "2019-12-13",//截止日期
                "csggqh": "第1183期",//初审公告期号
                "zcggqh": "第1195期",//注册公告期号
                "csgg": 1183,//初审公告
                "zcgg": 1195,//注册公告
                "zcggym": 125,//注册公告页码
                "yzcr": "魏文道441523********5511",//原注册人
                "zcdz": "广东省东莞市谢岗镇金海路26号",//注册地址
                "zcren": null,//注册人英文
                "zcdzen": null,//注册地址英文
                "dljg": "深圳市顺天达专利商标代理有限公司",//代理机构
                "zxzt": "",//最新状态
                "spfwxm": "",//商品服务项目
                "lcxx": "",//流程信息
                "sbqz": "0919",//商标群组
                "logo": "http://43.247.184.94:7170/Img/000/059/120/89A/d09d464f-d709-44bb-b635-16a86487e96d.jpg"//商标图样
            }
        ],
        "code_counts": [//尼斯大类统计
            {
                "key": "9",
                "keyvalue": "09类 科学仪器",//大类名称
                "keycount": 1 //数量
            }
        ],
        "status_counts": [//状态统计
            {
                "key": 3,
                "keyvalue": "已注册",//状态
                "keycount": 1   //数量
            }
        ],
        "year_counts": [//年份统计
            {
                "key": 2007,//年份
                "keycount": 1//数量
            }
        ],
        "count": 1//总数
    },
    "bizmsg": "empty"
}


```


## **<a name="findTrademarkzcr"> 申请人查询接口</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：findTrademarkzcr

``` javascript
{
    "regMan": "北京联大共享科技",//申请人
    "sqlbtabkey": "",//申请类别
    "flzttabkey": "",//法律状态
    "sqnftabkey": "",//申请年份
    "zcrname": "",//注册人姓名
    "xcl": [],//尼斯群组
    "pageSize": 20,//每页数量
    "currentPage": 1//当前页
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "rows": [
            {
                "sbmc": "清仕",//商标名称
                "sbpy": null,//商标拼音
                "sbyw": null,//商标英文
                "gjfl": "21",//国际分类
                "gjflname": "21类 厨房洁具",//国际分类名称
                "sbzch": "37560296",//商标注册号
                "sblx": "普通商标",//商标类型
                "sbzt": "申请中",//商标状态
                "sqrq": "2019-04-16",//申请日期
                "csrq": "",//初审日期
                "zcrq": "",//注册日期
                "csggym": null,//初审公告页码
                "zcr": "北京联大共享科技有限公司",//注册人
                "jzrq": "",//截止日期
                "csggqh": "",//初审公告期号
                "zcggqh": "",//注册公告期号 
                "csgg": null,//初审公告
                "zcgg": null,//注册公告
                "zcggym": null,//注册公告页码
                "yzcr": null,//原注册人
                "zcdz": "北京市房山区良乡凯旋大街建设路18号-D740",//注册地址
                "zcren": null,//注册人英文
                "zcdzen": null,//注册地址英文
                "dljg": "北京创知厚德科技有限公司",//代理机构
                "zxzt": "",//最新状态
                "spfwxm": "",//商品服务项目
                "lcxx": "",//流程信息
                "sbqz": "2106,2107,2108,2101,2105,2112,2110,2114",//商标群组
                "logo": "http://43.247.184.94:7170/Img/000/375/602/96A/23d3b156-bc42-4413-91cf-55249d165a12.jpg"//商标图样
            }
        ],
        "code_counts": [//尼斯大类统计
            {
                "key": "3",
                "keyvalue": "03类 日化用品",//大类名称
                "keycount": 2//数量
            },
            {
                "key": "9",
                "keyvalue": "09类 科学仪器",
                "keycount": 8
            },
            {
                "key": "14",
                "keyvalue": "14类 珠宝钟表",
                "keycount": 1
            },
            {
                "key": "16",
                "keyvalue": "16类 办公用品",
                "keycount": 3
            },
            {
                "key": "21",
                "keyvalue": "21类 厨房洁具",
                "keycount": 1
            },
            {
                "key": "25",
                "keyvalue": "25类 服装鞋帽",
                "keycount": 2
            },
            {
                "key": "26",
                "keyvalue": "26类 钮扣拉链",
                "keycount": 1
            },
            {
                "key": "28",
                "keyvalue": "28类 健身器材",
                "keycount": 2
            },
            {
                "key": "29",
                "keyvalue": "29类 食品",
                "keycount": 1
            },
            {
                "key": "30",
                "keyvalue": "30类 方便食品",
                "keycount": 2
            },
            {
                "key": "32",
                "keyvalue": "32类 啤酒饮料",
                "keycount": 1
            },
            {
                "key": "33",
                "keyvalue": "33类 酒",
                "keycount": 2
            },
            {
                "key": "35",
                "keyvalue": "35类 广告销售",
                "keycount": 13
            },
            {
                "key": "36",
                "keyvalue": "36类 金融物管",
                "keycount": 3
            },
            {
                "key": "37",
                "keyvalue": "37类 建筑修理",
                "keycount": 1
            },
            {
                "key": "38",
                "keyvalue": "38类 通讯服务",
                "keycount": 2
            },
            {
                "key": "39",
                "keyvalue": "39类 运输贮藏",
                "keycount": 1
            },
            {
                "key": "41",
                "keyvalue": "41类 教育娱乐",
                "keycount": 8
            },
            {
                "key": "42",
                "keyvalue": "42类 科技服务",
                "keycount": 7
            },
            {
                "key": "43",
                "keyvalue": "43类 餐饮住宿",
                "keycount": 5
            },
            {
                "key": "44",
                "keyvalue": "44类 医疗园艺",
                "keycount": 5
            },
            {
                "key": "45",
                "keyvalue": "45类 社会服务",
                "keycount": 2
            }
        ],
        "status_counts": [//状态统计
            {
                "key": 1,
                "keyvalue": "申请中",//状态
                "keycount": 13//数量
            },
            {
                "key": 2,
                "keyvalue": "已初审",
                "keycount": 3
            },
            {
                "key": 3,
                "keyvalue": "已注册",
                "keycount": 51
            },
            {
                "key": 4,
                "keyvalue": "已无效",
                "keycount": 6
            }
        ],
        "no_code_counts": [//未注册尼斯
            {
                "name": "01类 化学原料"
            },
            {
                "name": "02类 颜料油漆"
            },
            {
                "name": "04类 燃料油脂"
            },
            {
                "name": "05类 医药"
            },
            {
                "name": "06类 金属材料"
            },
            {
                "name": "07类 机械设备"
            },
            {
                "name": "08类 手工器械"
            },
            {
                "name": "10类 医疗器械"
            },
            {
                "name": "11类 灯具空调"
            },
            {
                "name": "12类 运输工具"
            },
            {
                "name": "13类 军火烟火"
            },
            {
                "name": "15类 乐器"
            },
            {
                "name": "17类 橡胶制品"
            },
            {
                "name": "18类 皮革皮具"
            },
            {
                "name": "19类 建筑材料"
            },
            {
                "name": "20类 家具"
            },
            {
                "name": "22类 绳网袋蓬"
            },
            {
                "name": "23类 纱线丝"
            },
            {
                "name": "24类 布料床单"
            },
            {
                "name": "27类 地毯席垫"
            },
            {
                "name": "31类 农林生鲜"
            },
            {
                "name": "34类 烟草烟具"
            },
            {
                "name": "40类 材料加工"
            }
        ],
        "year_counts": [//年份统计
            {
                "key": 2019,//年份
                "keycount": 13//数量
            },
            {
                "key": 2018,
                "keycount": 34
            },
            {
                "key": 2017,
                "keycount": 11
            },
            {
                "key": 2016,
                "keycount": 9
            },
            {
                "key": 2015,
                "keycount": 6
            }
        ],
        "namecounts": [//申请人名称统计
            {
                "key": "北京联大共享科技有限公司",//申请人名称
                "keycount": 73//数量
            }
        ],
        "count": 73//总数
    },
    "bizmsg": "empty"
}

```

## **<a name="getCropperPic"> 获取检索图片url</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getCropperPic

``` javascript
{
"base64":" data:image/png;base64,iVBORw0KGg……OlzAAAAAASUVORK5CYII="//图片base64编码
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":null,
    "data":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_cropper1571040784636MfaveZ.jpg",//图样url
    "requestId":"05f121fed33f4009a1f4e5e2605a9c48"
}


```

## **<a name="imagequery"> 图形检索</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：imagequery

``` javascript
{
"imageUrl":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_cropper1570763366176QIe0i9.jpg"//图片地址
}

```

#### 返回结果
```javascript
    {
    "status":0,
    "msg":"操作成功",
    "data":{
        "rows":[
            {
                "distance":0.267,//相似度
                "imageid":"17116404"//近似商标注册号
            },
            {
                "distance":0.268,
                "imageid":"29245996"
            },
            {
                "distance":0.268,
                "imageid":"29246011"
            },
            {
                "distance":0.272,
                "imageid":"38183382"
            },
            {
                "distance":0.272,
                "imageid":"38188460"
            },
            {
                "distance":0.273,
                "imageid":"361846"
            },
            {
                "distance":0.275,
                "imageid":"25908176"
            },
            {
                "distance":0.278,
                "imageid":"27683726"
            },
            {
                "distance":0.278,
                "imageid":"36341625"
            },
            {
                "distance":0.279,
                "imageid":"704220"
            },
            {
                "distance":0.28,
                "imageid":"1548425"
            },
            {
                "distance":0.347,
                "imageid":"38590434"
            },
            {
                "distance":0.347,
                "imageid":"37075949"
            },
            {
                "distance":0.347,
                "imageid":"36516713"
            },
            {
                "distance":0.347,
                "imageid":"36914643"
            },
            {
                "distance":0.347,
                "imageid":"39416042"
            },
            {
                "distance":0.347,
                "imageid":"39435190"
            },
            {
                "distance":0.347,
                "imageid":"39057196"
            },
            {
                "distance":0.347,
                "imageid":"38110954"
            },
            {
                "distance":0.347,
                "imageid":"38118185"
            },
            {
                "distance":0.347,
                "imageid":"38666295"
            },
            {
                "distance":0.347,
                "imageid":"37533627"
            },
            {
                "distance":0.347,
                "imageid":"38597660"
            },
            {
                "distance":0.347,
                "imageid":"38895520"
            },
            {
                "distance":0.347,
                "imageid":"39683224"
            },
            {
                "distance":0.347,
                "imageid":"39690062"
            },
            {
                "distance":0.347,
                "imageid":"38078013"
            },
            {
                "distance":0.347,
                "imageid":"36281728"
            },
            {
                "distance":0.348,
                "imageid":"36274731"
            },
            {
                "distance":0.348,
                "imageid":"36286481"
            }
        ],
        "code_counts":[//尼斯分类统计
            {
                "key":"1",
                "keyvalue":"01类 化学原料",//尼斯分类名称
                "keycount":27//该分类近似商标数量
            },
            {
                "key":"2",
                "keyvalue":"02类 颜料油漆",
                "keycount":18
            },
            {
                "key":"3",
                "keyvalue":"03类 日化用品",
                "keycount":34
            },
            {
                "key":"4",
                "keyvalue":"04类 燃料油脂",
                "keycount":7
            },
            {
                "key":"5",
                "keyvalue":"05类 医药",
                "keycount":36
            },
            {
                "key":"6",
                "keyvalue":"06类 金属材料",
                "keycount":29
            },
            {
                "key":"7",
                "keyvalue":"07类 机械设备",
                "keycount":41
            },
            {
                "key":"8",
                "keyvalue":"08类 手工器械",
                "keycount":12
            },
            {
                "key":"9",
                "keyvalue":"09类 科学仪器",
                "keycount":160
            },
            {
                "key":"10",
                "keyvalue":"10类 医疗器械",
                "keycount":25
            },
            {
                "key":"11",
                "keyvalue":"11类 灯具空调",
                "keycount":41
            },
            {
                "key":"12",
                "keyvalue":"12类 运输工具",
                "keycount":26
            },
            {
                "key":"13",
                "keyvalue":"13类 军火烟火",
                "keycount":2
            },
            {
                "key":"14",
                "keyvalue":"14类 珠宝钟表",
                "keycount":16
            },
            {
                "key":"15",
                "keyvalue":"15类 乐器",
                "keycount":2
            },
            {
                "key":"16",
                "keyvalue":"16类 办公用品",
                "keycount":47
            },
            {
                "key":"17",
                "keyvalue":"17类 橡胶制品",
                "keycount":10
            },
            {
                "key":"18",
                "keyvalue":"18类 皮革皮具",
                "keycount":23
            },
            {
                "key":"19",
                "keyvalue":"19类 建筑材料",
                "keycount":10
            },
            {
                "key":"20",
                "keyvalue":"20类 家具",
                "keycount":24
            },
            {
                "key":"21",
                "keyvalue":"21类 厨房洁具",
                "keycount":17
            },
            {
                "key":"22",
                "keyvalue":"22类 绳网袋蓬",
                "keycount":5
            },
            {
                "key":"23",
                "keyvalue":"23类 纱线丝",
                "keycount":5
            },
            {
                "key":"24",
                "keyvalue":"24类 布料床单",
                "keycount":19
            },
            {
                "key":"25",
                "keyvalue":"25类 服装鞋帽",
                "keycount":90
            },
            {
                "key":"26",
                "keyvalue":"26类 钮扣拉链",
                "keycount":10
            },
            {
                "key":"27",
                "keyvalue":"27类 地毯席垫",
                "keycount":8
            },
            {
                "key":"28",
                "keyvalue":"28类 健身器材",
                "keycount":23
            },
            {
                "key":"29",
                "keyvalue":"29类 食品",
                "keycount":27
            },
            {
                "key":"30",
                "keyvalue":"30类 方便食品",
                "keycount":27
            },
            {
                "key":"31",
                "keyvalue":"31类 农林生鲜",
                "keycount":14
            },
            {
                "key":"32",
                "keyvalue":"32类 啤酒饮料",
                "keycount":16
            },
            {
                "key":"33",
                "keyvalue":"33类 酒",
                "keycount":11
            },
            {
                "key":"34",
                "keyvalue":"34类 烟草烟具",
                "keycount":5
            },
            {
                "key":"35",
                "keyvalue":"35类 广告销售",
                "keycount":161
            },
            {
                "key":"36",
                "keyvalue":"36类 金融物管",
                "keycount":30
            },
            {
                "key":"37",
                "keyvalue":"37类 建筑修理",
                "keycount":27
            },
            {
                "key":"38",
                "keyvalue":"38类 通讯服务",
                "keycount":31
            },
            {
                "key":"39",
                "keyvalue":"39类 运输贮藏",
                "keycount":23
            },
            {
                "key":"40",
                "keyvalue":"40类 材料加工",
                "keycount":14
            },
            {
                "key":"41",
                "keyvalue":"41类 教育娱乐",
                "keycount":63
            },
            {
                "key":"42",
                "keyvalue":"42类 科技服务",
                "keycount":104
            },
            {
                "key":"43",
                "keyvalue":"43类 餐饮住宿",
                "keycount":12
            },
            {
                "key":"44",
                "keyvalue":"44类 医疗园艺",
                "keycount":21
            },
            {
                "key":"45",
                "keyvalue":"45类 社会服务",
                "keycount":20
            }
        ],
        "status_counts":[//商标状态统计
            {
                "key":1,
                "keyvalue":"申请中",//状态名称
                "keycount":332//该状态近似商标数量
            },
            {
                "key":2,
                "keyvalue":"已初审",
                "keycount":72
            },
            {
                "key":3,
                "keyvalue":"已注册",
                "keycount":487
            },
            {
                "key":4,
                "keyvalue":"已无效",
                "keycount":469
            },
            {
                "key":5,
                "keyvalue":"其他",
                "keycount":3
            }
        ],
        "year_counts":[//年份统计
            {
                "key":2019,//年份
                "keycount":320//该年份近似商标数量
            },
            {
                "key":2018,
                "keycount":235
            },
            {
                "key":2017,
                "keycount":142
            },
            {
                "key":2016,
                "keycount":55
            },
            {
                "key":2015,
                "keycount":67
            },
            {
                "key":2014,
                "keycount":75
            },
            {
                "key":2013,
                "keycount":49
            },
            {
                "key":2012,
                "keycount":33
            },
            {
                "key":2011,
                "keycount":19
            },
            {
                "key":2010,
                "keycount":10
            },
            {
                "key":2009,
                "keycount":12
            },
            {
                "key":2008,
                "keycount":5
            },
            {
                "key":2007,
                "keycount":5
            },
            {
                "key":2006,
                "keycount":17
            },
            {
                "key":2005,
                "keycount":13
            },
            {
                "key":2004,
                "keycount":4
            },
            {
                "key":2002,
                "keycount":6
            },
            {
                "key":2001,
                "keycount":6
            },
            {
                "key":2000,
                "keycount":53
            },
            {
                "key":1999,
                "keycount":43
            },
            {
                "key":1998,
                "keycount":12
            },
            {
                "key":1997,
                "keycount":2
            },
            {
                "key":1996,
                "keycount":9
            },
            {
                "key":1995,
                "keycount":16
            },
            {
                "key":1994,
                "keycount":17
            },
            {
                "key":1993,
                "keycount":14
            },
            {
                "key":1992,
                "keycount":18
            },
            {
                "key":1991,
                "keycount":12
            },
            {
                "key":1990,
                "keycount":24
            },
            {
                "key":1989,
                "keycount":14
            },
            {
                "key":1988,
                "keycount":14
            },
            {
                "key":1987,
                "keycount":4
            },
            {
                "key":1986,
                "keycount":4
            },
            {
                "key":1985,
                "keycount":8
            },
            {
                "key":1984,
                "keycount":1
            },
            {
                "key":1979,
                "keycount":1
            },
            {
                "key":1958,
                "keycount":1
            }
        ],
        "count":1198//返回结果数量
    },
    "bizmsg":"empty",
    "requestId":"946b1ac884224987b22739235bf0daf9"}


```

## **<a name="findImageSearch"> 图形检索查询</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：findImageSearch

``` javascript
{
	"flzttabkey": 3,//商标法律状态
	"pageInfo": {"pageSize": 36, "pageNo": 1},//分页对象
	"sqlbtabkey": "1",//商标申请类别
	"sqnftabkey": "2018",//商标申请年份
	"xcl": [],//选中的商标大类下的群组
	"tmRegistNumsAll":[ {"distance":0.278,"imageid":"36341625"},//近似商标注册号数组
{"distance":0.279,"imageid":"704220"},{"distance":0.28,"imageid":"1548425"},
{"distance":0.28,"imageid":"36876469"},{"distance":0.28,"imageid":"36875903"},
{"distance":0.281,"imageid":"33662215"},{"distance":0.281,"imageid":"33670346"},
{"distance":0.282,"imageid":"515429"},{"distance":0.283,"imageid":"25620072"},
{"distance":0.284,"imageid":"1639431"},{"distance":0.284,"imageid":"529431"},
{"distance":0.285,"imageid":"33659963"},{"distance":0.285,"imageid":"33660039"}
…….
	]
}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "rows":[
            {
                "sbmc":"图形",//商标名称
                "sbpy":"tuxing",//商标拼音
                "sbyw":null,//商标英文
                "gjfl":"1",//国际分类
                "gjflname":"01类 化学原料",//国际分类名称
                "sbzch":"33659963",//商标注册号
                "sblx":"普通商标",//商标类型
                "sbzt":"已注册",//商标状态
                "sqrq":"2018-09-21",//申请日期
                "csrq":"2019-03-20",//初审日期
                "zcrq":"2019-06-20",//注册日期
                "csggym":86369,//初审公告页码
                "zcr":"联测科技(广州)有限公司",//注册人
                "jzrq":"2029-06-20",//截至日期
                "csggqh":"第1640期",//初审公告期号
                "zcggqh":"第1652期",//注册公告期号
                "csgg":1640,//初审公告
                "zcgg":1652,//注册公告
                "zcggym":28530,//注册公告页码
                "yzcr":"联测科技（广州）有限公司",//原注册人
                "zcdz":"广东省广州市天河区金穗路1号1704-A房（仅限办公用途）",//注册地址
                "zcren":null,//注册人英文
                "zcdzen":null,//注册地址英文
                "dljg":"深圳市海睿杰知识产权代理有限公司",//代理机构
                "zxzt":"",//最新状态
                "spfwxm":"",//商品服务项目
                "lcxx":"",//流程信息
                "logo":"http://43.247.184.94:7170/Img/000/336/599/63A/99aa881e-f256-4eec-8495-d9efa42f7b78.jpg"//商标logo
            }
        ],
        "code_counts":[//尼斯分类列表
            {
                "key":"1",
                "keyvalue":"01类 化学原料",//尼斯分类名称
                "keycount":1//该分类近似商标数量
            },
            {
                "key":"41",
                "keyvalue":"41类 教育娱乐",
                "keycount":1
            },
            {
                "key":"45",
                "keyvalue":"45类 社会服务",
                "keycount":1
            }
        ],
        "status_counts":[//商标状态列表
            {
                "key":3,
                "keyvalue":"已注册",//状态名称
                "keycount":1//该状态近似商标数量
            }
        ],
        "year_counts":[//年份列表
            {
                "key":2018,//年份
                "keycount":1//该年份近似商标数量
            }
        ],
        "count":1 //返回结果数量
    },
    "bizmsg":"empty",
    "requestId":"4cf8f88a180f45ddbb2f04e6d2e41a86"
}


```

## **<a name="tradeMarkDetail"> 商标详情查询接口</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：tradeMarkDetail

``` javascript
{
	"sbzch": "5912089",//商标申请号
	"gjfl": "9"//申请类别
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "detaildata": [
            {
                "sbmc": "张三",//商标名称
                "sbpy": "zhangsan",//商标拼音
                "sbyw": null,//商标英文
                "gjfl": "9",//国际分类
                "gjflname": "09类 科学仪器",//国际分类名称
                "sbzch": "5912089",//商标注册号
                "sblx": "特殊商标",//商标类型
                "sbzt": "已注册",//商标状态
                "sqrq": "2007-02-12",//申请日期
                "csrq": "2009-09-13",//初审日期
                "zcrq": "2009-12-13",//注册日期
                "csggym": 1225,//初审公告页码
                "zcr": "魏文道***",//申请人
                "jzrq": "2019-12-13",//截止日期
                "csggqh": "第1183期",//初审公告（期号）
                "zcggqh": "第1195期",//注册公告（期号）
                "csgg": 1183,//初审公告
                "zcgg": 1195,//注册公告
                "zcggym": 125,//注册公告页码
                "yzcr": "魏文道441523********5511",//原申请人
                "zcdz": "广东省东莞市谢岗镇金海路26号",//申请地址
                "zcren": null,//注册人英文
                "zcdzen": null,//注册地址英文
                "dljg": "深圳市顺天达专利商标代理有限公司",//代理机构
                "lcxx": [//流程信息
                    {
                        "name": "2009-12-13 商标注册公告（一）",//流程信息名字
                        "link_url": "http://sbggwj.saic.gov.cn:8000/tmann/group2/M00/4E/77/yBQCIFmHa3uAdCd8AAGF02_13jc221.jpg"//流程信息图片链接
                    },
                    {
                        "name": "2009-09-13 商标初步审定公告",
                        "link_url": "http://sbggwj.saic.gov.cn:8000/tmann/group1/M00/1C/37/yBQCH1mEncuATZuCAAGr0Zq3puQ048.jpg"
                    }
                ],
                "logo": "http://43.247.184.94:7170/Img/000/059/120/89A/d09d464f-d709-44bb-b635-16a86487e96d.jpg"//商标图像地址
            }
        ],
        "nclexist": [//申请的商品服务项
            {
                "code": "0919",//商品服务项二级编号
                "small_name": "耳塞"//商品服务项小类名称
            },
            {
                "code": "0919",
                "small_name": "防事故用手套"
            },
            {
                "code": "0919",
                "small_name": "防毒面具(非人工呼吸用)"
            },
            {
                "code": "0919",
                "small_name": "防事故、防辐射、防火用鞋"
            },
            {
                "code": "0919",
                "small_name": "耐酸衣、裙"
            },
            {
                "code": "0919",
                "small_name": "护目镜"
            },
            {
                "code": "0919",
                "small_name": "呼吸面具过滤器"
            },
            {
                "code": "0919",
                "small_name": "防水衣"
            },
            {
                "code": "0919",
                "small_name": "耐酸胶鞋"
            },
            {
                "code": "0919",
                "small_name": "耐酸手套"
            }
        ],
        "nclnotexist": [//未申请的商品服务项
            {
                "code": "0912",//未申请的商品服务项二级编号
                "level": 2,//未申请的商品服编号等级
                "name": "光电传输材料",//未申请的商品服务项小类名称
                "pid": "09"//未申请的商品大类编号
            },
            {
                "code": "0901",
                "level": 2,
                "name": "电子计算机及其外部设备",
                "pid": "09"
            },
            {
                "code": "0913",
                "level": 2,
                "name": "电器用晶体及碳素材料，电子、电气通用元件",
                "pid": "09"
            },
            {
                "code": "0903",
                "level": 2,
                "name": "其他办公用机械（不包括打字机、誊写机、油印机）",
                "pid": "09"
            },
            {
                "code": "0902",
                "level": 2,
                "name": "记录、记数检测器",
                "pid": "09"
            },
            {
                "code": "0914",
                "level": 2,
                "name": "电器成套设备及控制装置",
                "pid": "09"
            },
            {
                "code": "0906",
                "level": 2,
                "name": "信号器具",
                "pid": "09"
            },
            {
                "code": "0904",
                "level": 2,
                "name": "衡器",
                "pid": "09"
            },
            {
                "code": "0905",
                "level": 2,
                "name": "量具",
                "pid": "09"
            },
            {
                "code": "0916",
                "level": 2,
                "name": "灭火器具",
                "pid": "09"
            },
            {
                "code": "0910",
                "level": 2,
                "name": "测量仪器仪表，实验室用器具，电测量仪器，科学仪器",
                "pid": "09"
            },
            {
                "code": "0909",
                "level": 2,
                "name": "摄影、电影用具及仪器",
                "pid": "09"
            },
            {
                "code": "0908",
                "level": 2,
                "name": "音像设备",
                "pid": "09"
            },
            {
                "code": "0907",
                "level": 2,
                "name": "通信导航设备",
                "pid": "09"
            },
            {
                "code": "0911",
                "level": 2,
                "name": "光学仪器",
                "pid": "09"
            },
            {
                "code": "0915",
                "level": 2,
                "name": "电解装置",
                "pid": "09"
            },
            {
                "code": "0918",
                "level": 2,
                "name": "工业用X光机械设备",
                "pid": "09"
            },
            {
                "code": "0920",
                "level": 2,
                "name": "警报装置，电铃",
                "pid": "09"
            },
            {
                "code": "0921",
                "level": 2,
                "name": "眼镜及附件",
                "pid": "09"
            },
            {
                "code": "0922",
                "level": 2,
                "name": "电池，充电器",
                "pid": "09"
            },
            {
                "code": "0923",
                "level": 2,
                "name": "电影片，已曝光材料",
                "pid": "09"
            },
            {
                "code": "0924",
                "level": 2,
                "name": "单一商品",
                "pid": "09"
            }
        ]
    },
    "bizmsg": "empty"
}


```

## **<a name="sbzuixinsearch"> 最新商标查询</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：sbzuixinsearch

``` javascript
    {}

```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "zuixinshouli":"2019-08-30",//最新受理
        "zuixinchushen":"2019-04-30",//最新初审
        "zuixinxiazheng":"2019-02-13"//最新下证
    },
    "bizmsg":"empty",
    "requestId":"d483ffa51bcf49de9e10eec53744a2cc"
}


```

## **<a name="noticequeryTMZCSQ"> 近12期初审公告查询接口</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：noticequeryTMZCSQ

``` javascript
{
	"noticetype": "TMZCSQ"//默认参数TMZCSQ
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "rows": [
            {
                "notice_issue": 1658,//公告期号
                "date": "2019-08-06",//初审公告日期
                "enddate": "2019-11-06",//异议申请截止日期
                "lastday": "剩余84天"//异议申请剩余时间
            },
            {
                "notice_issue": 1657,
                "date": "2019-07-27",
                "enddate": "2019-10-27",
                "lastday": "剩余74天"
            },
            {
                "notice_issue": 1656,
                "date": "2019-07-20",
                "enddate": "2019-10-20",
                "lastday": "剩余67天"
            },
            {
                "notice_issue": 1655,
                "date": "2019-07-13",
                "enddate": "2019-10-13",
                "lastday": "剩余60天"
            },
            {
                "notice_issue": 1654,
                "date": "2019-07-06",
                "enddate": "2019-10-06",
                "lastday": "剩余53天"
            },
            {
                "notice_issue": 1653,
                "date": "2019-06-27",
                "enddate": "2019-09-27",
                "lastday": "剩余44天"
            },
            {
                "notice_issue": 1652,
                "date": "2019-06-20",
                "enddate": "2019-09-20",
                "lastday": "剩余37天"
            },
            {
                "notice_issue": 1651,
                "date": "2019-06-13",
                "enddate": "2019-09-13",
                "lastday": "剩余30天"
            },
            {
                "notice_issue": 1650,
                "date": "2019-06-06",
                "enddate": "2019-09-06",
                "lastday": "剩余23天"
            },
            {
                "notice_issue": 1649,
                "date": "2019-05-27",
                "enddate": "2019-08-27",
                "lastday": "剩余13天"
            },
            {
                "notice_issue": 1648,
                "date": "2019-05-20",
                "enddate": "2019-08-20",
                "lastday": "剩余6天"
            },
            {
                "notice_issue": 1647,
                "date": "2019-05-13",
                "enddate": "2019-08-13",
                "lastday": "已过期0天"
            }
        ],
        "selectdata": [//下拉框数据
            {
                "value": 1658,//下拉框数据值，公告期号
                "label": "1658 (2019-08-06)"//下拉框数据标签，公告期号及时间
            },
            {
                "value": 1657,
                "label": "1657 (2019-07-27)"
            },
            {
                "value": 1656,
                "label": "1656 (2019-07-20)"
            },
            {
                "value": 1655,
                "label": "1655 (2019-07-13)"
            },
            {
                "value": 1654,
                "label": "1654 (2019-07-06)"
            },
            {
                "value": 1653,
                "label": "1653 (2019-06-27)"
            },
            {
                "value": 1652,
                "label": "1652 (2019-06-20)"
            },
            {
                "value": 1651,
                "label": "1651 (2019-06-13)"
            },
            {
                "value": 1650,
                "label": "1650 (2019-06-06)"
            },
            {
                "value": 1649,
                "label": "1649 (2019-05-27)"
            },
            {
                "value": 1648,
                "label": "1648 (2019-05-20)"
            },
            {
                "value": 1647,
                "label": "1647 (2019-05-13)"
            }
        ]
    },
    "bizmsg": "empty"
}

```

## **<a name="noticequery"> 公告列表检索接口</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：noticequery

``` javascript
{
  "noticenumber": "1656",//公告期号
  "applynumber": "",//商标申请号
  "tmname": "大爱城控股",//商标名称
  "applier": "",//申请人
  "noticetype": "TMZCSQ",//TMZCSQ ,TMZCSQ, TMQTSQ
  "nclNum": "all",//商标尼斯大类
  "pageSize": 20,//每页数据
  "currentPage": 1//当前页码
}


```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "rows": [
            {
                "sbmc": "大爱城控股",//商标名称
                "sbzch": "33640627",//商标申请号
                "sblb": "5 ",//商标大类
                "zcr": "大爱城投资控股有限公司",//商标申请人
                "ggqh": "1656(2019-07-20)",//公告期号
                "pagenumber": 3377,
                "gglx": "商标初步审定公告",//流程信息
                "linkurl": "http://sbggwj.saic.gov.cn:8000/tmann/group2/M00/AF/51/yBQCIF0xPSiAcUBOAAIB3iqAYk8063.jpg",//公告连接
                "logo": "http://43.247.184.94:7170/Img/000/336/406/27A/6bb6ac4d-05d1-4966-ab31-7672a8b6e81b.jpg"//商标图像
            },
            {
                "sbmc": "大爱城控股",
                "sbzch": "33645726",
                "sblb": "31 ",
                "zcr": "大爱城投资控股有限公司",
                "ggqh": "1656(2019-07-20)",
                "pagenumber": 3387,
                "gglx": "商标初步审定公告",
                "linkurl": "http://sbggwj.saic.gov.cn:8000/tmann/group2/M00/AF/C8/yBQCIF0xRbOANqhzAAHvQXVINL4846.jpg",
                "logo": "http://43.247.184.94:7170/Img/000/336/457/26A/821d2f6c-eacc-4da0-b182-bb2c5619ec5c.jpg"
            },
            {
                "sbmc": "大爱城控股",
                "sbzch": "33632043",
                "sblb": "42 ",
                "zcr": "大爱城投资控股有限公司",
                "ggqh": "1656(2019-07-20)",
                "pagenumber": 3343,
                "gglx": "商标初步审定公告",
                "linkurl": "http://sbggwj.saic.gov.cn:8000/tmann/group1/M00/B9/7A/yBQCH10xWPeAQ7GaAAIOqwfWFrk415.jpg",
                "logo": "http://43.247.184.94:7170/Img/000/336/320/43A/ce0870b9-7f07-46c0-8da6-c21fd8428d1c.jpg"
            }
        ],
        "count": 3
    },
    "bizmsg": "empty"
}

```

## **<a name="noticezcggsearch"> 注册公告详情查询</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：noticezcggsearch

``` javascript
{
"sbzch":"T123",//注册公告期号
"zcggqh":607 //商标注册号
}


```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "sbmc":null,//商标名称
"linkurl":"http://sbggwj.saic.gov.cn:8000/tmann/group2/M00/33/9F/yBQCIFmGf7WAS11IAAGcUnMc7Sg980.jpg"//公告连接
    },
    "bizmsg":"empty",
    "requestId":"2201093d08824e53b06b9cb3ce912087"
}


```

## **<a name="noticesearch"> 初审公告详情查询接口</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：noticesearch

``` javascript
{ 
"csggqh":1663,//公告期号
"sbzch":"36280736"//商标注册号
}


```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "sbmc":"啊",//商标名称
"linkurl":"http://sbggwj.saic.gov.cn:8000/tmann/group2/M00/CF/54/yBQCIF153tCAJBgAAAH97QxWZag867.jpg"//公告连接
    },
    "bizmsg":"empty",
    "requestId":"f33c987535ed4803955b9f18668e8454"
}


```

## **<a name="getCompanyInfoNoUser"> 企业查询接口</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getCompanyInfoNoUser

``` javascript
{
"company_name":"兰庭茁华河北农业开发有限公司"//公司全名
}


```

#### 返回结果
```javascript
{
    "status":0,
    "msg":null,
    "data":{
        "name":"兰庭茁华河北农业开发有限公司",//企业名称
        "legalRepresentative":"许桂秋",//法定代表人
        "managementState":"存续",//法律状态
        "registeredCapital":"300.000万人民币",//注册资本
        "foundedTime":"2018-4-24",//成立日期
        "creditCode":"91130533MA0A294667",//统一社会信用代码
        "registrID":"130533000046096",//注册号
        "organizationCode":"MA0A29466",//组织机构代码
        "companyType":"0",//公司类型
        "registerOffice":"威县市场监督管理局",//登记机关
        "businessAddress":"河北省邢台市威县第什营镇南草厂村",//企业地址
        "scope":"农业种植、新能源技术研发、技术推广；农作物、果树、中药材种植；农产品、水果销售；花卉种植、销售；林木育苗；牲畜、家禽饲养、销售；观光果园管理服务；在资质等级许可的范围内从事园林绿化工程；农用机械、有机肥销售。（依法须经批准的项目，经相关部门批准后方可开展经营活动）",//营业范围
        "dateIssue":"2018-4-24",//发照日期
        "businessTerm":"2018-4-24至1970-1-1"//营业期限
    },
    "requestId":"b2c49be10b154ca896b73505f3fe8b6a"
}


```

## **<a name="getNclDetail"> 尼斯详情接口</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getNclDetail

``` javascript
{
 "number": "2"//尼斯大类编码
}


```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "classification":"第02类-",//大类名称
        "construction":"颜料，清漆，漆；防锈剂和木材防腐剂；着色剂，染料；印刷、标记和雕刻用油墨；未加工的天然树脂；绘画、装饰、印刷和艺术用金属箔及金属粉。",//大类描述
        "data":[//尼斯群组数据
            {
                "smallclassification":"0201 染料，媒染剂（不包括食用）",//群组名称
                "content":"皮革染色剂020057,鞋染料020041,木材媒染剂020027,染料木提取物（染料）020112,黄桑（染料）020074,苯胺染料020052,染料木020111,藏红染料020099,靛青（染料）020086,染色剂020047,复活节彩蛋用染色纸020096,姜黄（染料）020060,染料020058,媒染剂020002,制革用媒染剂020057,着色剂020047,木材染色剂020028,茜素染料020006,",//该群组下的尼斯小类数据
                "xinzeng":"硫化染料,醇溶性染料,制油漆用着色剂,苏木提取物（染料）,酸性染料,天然染料,混凝土着色剂,用作染料的姜黄,文身染料,合成染料,油溶性染料,造纸用着色剂,地板用染色剂,快速染料,普鲁士蓝,碱性染料（阳离子染料）,制模塑料用着色剂,制药用着色剂,塑料用染料,萘酚染料,群青染料,纺织品用着色剂,荧光增白剂（染料）,合成树脂染料,靛青,直接染料,还原染料,木材染料,"//该群组下的新增非规范尼斯小类
            },
            {
                "smallclassification":"0202 颜料（不包括食用、绝缘用），绘画、装饰、印刷和艺术用金属箔及金属粉",
                "content":"色母粒C020001,家具修复用补色笔020130,艺术用油彩020127,二氧化钛（颜料）020106,烟灰色（颜料）020101,绘画、装饰、印刷和艺术用金属箔020092,绘画、装饰、印刷和艺术用金属粉020090,铅黄020089,氧化锌（颜料）020081,绘画用藤黄020076,灯黑（颜料）020073,铅白020038,赭石土（颜料）020029,胭脂树橙（颜料）020098,胭脂虫红020045,氧化钴（颜料）020044,银乳剂（颜料）020015,艺术用水彩020126,铅红020095,红丹020095,炭黑（颜料）020039,立德粉（锌钡白）C020014,黄丹020089,颜料020059,绘画用青铜粉020032,水彩固定剂020011,石棉颜料020009,着色剂020047,金胺020018,绘画用铝粉020008,",
                "xinzeng":"红丹（铅红）,茜红,绘画、装饰、印刷和艺术用贵金属粉,绘画、装饰、印刷和艺术用贵金属箔,朱砂红,画家、装饰家、印刷商和艺术家用铅箔,彩色颜料,纺织纤维颜料,制墨用颜料,画家、装饰家、印刷商和艺术家用有色金属箔,艺术家用颜料,无机颜料,画家、装饰家、印刷商和艺术家用铅合金粉末,画家、装饰家、印刷商和艺术家用金属粉,群青（颜料）,画家、装饰家、印刷商和艺术家用铅粉,水彩颜料,化学防护颜料,钛白,画家、装饰家、印刷商和艺术家用有色金属粉,有机颜料,画家、装饰家、印刷商和艺术家用有色金属粉末,画家、装饰家、印刷商和艺术家用金属箔,丙烯颜料,制化妆品用着色剂,画家、装饰家、印刷商和艺术家用铅合金箔片,蛋彩画颜料,装饰用金属箔,艺术家用丙烯颜料,油性颜料,着色用铝粉,"
            },
            {
                "smallclassification":"0203 食品着色剂",
                "content":"食用色素020005,啤酒色素020024,食品用着色剂020005,麦芽焦糖（食品色素）020035,黄油色素020023,饮料色素020004,麦芽色素020048,焦糖（食品色素）020034,利口酒用色素020088,",
                "xinzeng":"生产食物用色素,制造饮料用焦糖色素,制造食品用焦糖色素,家用食品色素,生产饮料用色素,"
            },
            {
                "smallclassification":"0204 油墨",
                "content":"复印机用碳粉C020017,文字处理机用已填充的墨盒C020002,打印机和复印机用已填充的墨盒020133,打印机和复印机用墨水020121,雕刻油墨020080,皮肤绘画用墨020069,喷墨打印机用已填充的墨盒C020016,打印机和复印机用墨粉020132,印刷油墨020066,已填充可食用墨的打印机墨盒020129,可食用墨020128,动物打印记用墨020067,制革用墨020033,激光打印机用已填充的墨盒C020015,打印机和复印机用已填充的鼓粉盒020123,印刷膏（油墨）020043,",
                "xinzeng":"干油墨,印刷合成物（油墨）,油印油墨,喷墨打印机用墨水,金粉油墨,已填充的喷墨打印墨盒,激光打印机用已填充的鼓粉盒,胶版印刷用油墨,文身用墨,已填充的鼓粉盒,热致变色油墨,喷墨打印机用已填充的鼓粉盒,已填充的打印机墨盒,打印机和影印机用碳粉盒（填满的）,用作油墨干燥剂的催干剂,丝网印刷用油墨,凸版印刷油墨,金属油墨,静电复印用色粉,柔版印刷用胶囊香味油墨,凹版油墨,复印油墨,打印碳粉,纺织品着色用油墨,平版印刷油墨,"
            },
            {
                "smallclassification":"0205 涂料，油漆及附料（不包括绝缘漆）",
                "content":"树脂胶泥C020013,松香水C020004,油漆补片（可替换的）020125,清漆用苏模鞣料020102,防火漆020085,虫胶020077,油漆催干剂020068,瓷釉（漆）020064,油漆稀释剂020053,沥青油漆020025,粉刷用石灰浆020020,铝涂料020007,防水粉（涂料）C020012,防涂鸦涂料（油漆）020131,松节油（涂料稀释剂）020124,防污涂料020122,底漆020108,固定剂（清漆）020072,刷墙粉020062,油漆增稠剂020055,粉刷用石灰水020042,运载工具底盘底漆020040,杀菌漆020019,银镀粉020016,清漆020003,水溶性内外墙有光喷塑料C020007,防水冷胶料C020006,可赛银C020005,稀料C020003,漆020115,苯乙烯树脂漆020114,粉刷用白垩灰浆020110,油漆黏合剂020087,釉料（漆、清漆）020075,涂料（油漆）020070,青铜漆020031,油漆020001,天那水C020010,聚乙烯胶泥C020008,油漆凝结剂020087,瓷漆020065,漆稀释剂020054,运载工具底盘防蚀涂层020040,陶瓷涂料020037,屋顶毡用涂料（油漆）020036,木材涂料（油漆）020026,黑亮漆020017,磁漆C020018,信那水C020011,无黏性化学涂料（不粘锅用）C020009,油毛毡用涂料（油漆）020036,银涂料020014,",
                "xinzeng":"橱柜制作用清漆,军事设备用伪装漆,家具上光用涂料,反光喷漆,清漆（非绝缘漆）,有色涂料（油漆）,油漆类不粘涂层（涂料）,虫胶清漆,船体底壳漆,生产加工用油漆,涂料和腻子用干燥剂,标记路面用热塑性油漆,陶瓷制造用油漆,机器用油漆,地板用漆,合成树脂涂料,阻燃油漆,油性漆,油漆和油灰用黏合剂,防火油漆,陶器瓷漆,发光漆,合成涂料（油漆）,运载工具涂层用透明保护剂,混凝土地面用油漆,运载工具用透明防护涂料,家具制造用油漆,车辆用防锈制剂涂层,混凝土用辐射固化涂料,汽车用漆,防腐油漆,耐热漆,木器漆,玻璃钢游泳池和水疗场所用非金属彩色表面涂层,装饰用喷涂式涂料,无溶剂油漆,房屋用漆,防涂鸦用油漆,地板保护清漆,纸涂层用漆,汽车制造用油漆,搪瓷漆,喷漆,防腐蚀涂料,防腐蚀油漆,抗风化涂料（油漆）,绘画漆,混凝土地面用环氧涂料,商业船舶用防腐油漆类涂料,工艺品漆,透明涂料（油漆）,用于表面涂漆做准备的底漆,调和漆,粉末涂料,外墙漆,荧光漆,内墙漆,用作涂料稀释剂的松节油,建筑油漆,防潮油漆,待涂表面用底漆,海事用油漆,建筑物外表面用彩色油漆,用作涂料干燥剂的催干剂,工业装置用油漆,具有防水特性的涂料制剂（油漆）,防锈涂料,防锈漆,防水油漆,"
            },
            {
                "smallclassification":"0206 防锈剂，木材防腐剂",
                "content":"金属用保护制剂020094,金属防锈制剂020093,防锈油脂020079,羰基（木头防腐剂）020113,木材防腐油020082,防腐蚀剂020010,防锈油020083,防腐蚀带020021,木材防腐用杂酚油020056,木材防腐剂020049,防锈制剂020107,",
                "xinzeng":"木材防腐用桐油,防腐用木材处理剂,防腐蚀油,防腐蚀纸,"
            },
            {
                "smallclassification":"0207 未加工的天然树脂",
                "content":"天然树脂020091,未加工的天然树脂020061,加拿大香脂020022,天然硬树脂020050,山达脂020100,松香020046,树胶脂020078,",
                "xinzeng":"加拿大香脂（未加工天然树脂）,未加工天然树脂,达马树脂,生产黏合剂用未加工天然树脂,"
            }
        ]
    },
    "bizmsg":"empty",
    "requestId":"87df01c1c9214fd29cfd555c8af680b5"
}


```

## **<a name="gettwoNcl"> 获取尼斯群组</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：gettwoNcl

``` javascript
{
"code":"1"//尼斯大类编码
}


```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "rows":[
            {
                "code":"0101",//群组编码
                "name":"工业气体，单质"//群组名称
            },
            {
                "code":"0102",
                "name":"用于工业、科学、农业、园艺、林业的工业化工原料"
            },
            {
                "code":"0103",
                "name":"放射性元素及其化学品"
            },
            {
                "code":"0104",
                "name":"用于工业、科学的化学品、化学制剂，不属于其他类别的产品用的化学制品"
            },
            {
                "code":"0105",
                "name":"用于农业、园艺、林业的化学品、化学制剂"
            },
            {
                "code":"0106",
                "name":"化学试剂"
            },
            {
                "code":"0107",
                "name":"摄影用化学用品及材料"
            },
            {
                "code":"0108",
                "name":"未加工的人造合成树脂，未加工塑料物质（不包括未加工的天然树脂）"
            },
            {
                "code":"0109",
                "name":"肥料"
            },
            {
                "code":"0110",
                "name":"灭火、防火用合成物"
            },
            {
                "code":"0111",
                "name":"淬火用化学制剂"
            },
            {
                "code":"0112",
                "name":"焊接用化学制剂"
            },
            {
                "code":"0113",
                "name":"食药用化学品（不包括食品用防腐盐）"
            },
            {
                "code":"0114",
                "name":"鞣料及皮革用化学品"
            },
            {
                "code":"0115",
                "name":"工业用黏合剂和胶（不包括纸用黏合剂）"
            },
            {
                "code":"0116",
                "name":"纸浆"
            }
        ]
    },
    "bizmsg":"empty",
    "requestId":"984601fa445c465ab3869e236ef2d8d5"
}


```

## **<a name="nclFuwuSearch"> 尼斯分类检索</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：nclFuwuSearch

``` javascript
{
 "currentPage": 1,//当前页
"nclfuwu": "化学",//尼斯分类名称
"pageSize": 20//每页条数
}


```

#### 返回结果
```javascript
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "rows":[
            {
                "nclthreecode":"C400005",//尼斯小类编码
                "nclthreename":"化学试剂加工和处理",//尼斯小类名称
                "ncltwocode":"4015",//尼斯群组编码
                "ncltwoname":"单一服务",//尼斯群组名称
                "nclonecode":"40",//尼斯大类编码
                "nclonename":"40类 材料加工"//尼斯大类名称
            },
            {
                "nclthreecode":"C070210",
                "nclthreename":"林产化学设备",
                "ncltwocode":"0729",
                "ncltwoname":"其他化学工业用机械",
                "nclonecode":"07",
                "nclonename":"07类 机械设备"
            },
            {
                "nclthreecode":"C020009",
                "nclthreename":"无黏性化学涂料（不粘锅用）",
                "ncltwocode":"0205",
                "ncltwoname":"涂料，油漆及附料（不包括绝缘漆）",
                "nclonecode":"02",
                "nclonename":"02类 颜料油漆"
            },
            {
                "nclthreecode":"C010260",
                "nclthreename":"化学防腐剂",
                "ncltwocode":"0104",
                "ncltwoname":"用于工业、科学的化学品、化学制剂，不属于其他类别的产品用的化学制品",
                "nclonecode":"01",
                "nclonename":"01类 化学原料"
            },
            {
                "nclthreecode":"C010244",
                "nclthreename":"化学肥料",
                "ncltwocode":"0109",
                "ncltwoname":"肥料",
                "nclonecode":"01",
                "nclonename":"01类 化学原料"
            },
            {
                "nclthreecode":"440115",
                "nclthreename":"空中和地面化肥及其他农用化学品的喷洒",
                "ncltwocode":"4404",
                "ncltwoname":"农业、园艺服务",
                "nclonecode":"44",
                "nclonename":"44类 医疗园艺"
            },
            {
                "nclthreecode":"420031",
                "nclthreename":"化学研究",
                "ncltwocode":"4211",
                "ncltwoname":"提供化学研究服务",
                "nclonecode":"42",
                "nclonename":"42类 科技服务"
            },
            {
                "nclthreecode":"420030",
                "nclthreename":"化学服务",
                "ncltwocode":"4211",
                "ncltwoname":"提供化学研究服务",
                "nclonecode":"42",
                "nclonename":"42类 科技服务"
            },
            {
                "nclthreecode":"420007",
                "nclthreename":"化学分析",
                "ncltwocode":"4211",
                "ncltwoname":"提供化学研究服务",
                "nclonecode":"42",
                "nclonename":"42类 科技服务"
            },
            {
                "nclthreecode":"400058",
                "nclthreename":"纺织品化学处理",
                "ncltwocode":"4003",
                "ncltwoname":"纺织品化学处理或加工服务",
                "nclonecode":"40",
                "nclonename":"40类 材料加工"
            },
            {
                "nclthreecode":"400058",
                "nclthreename":"布料化学处理",
                "ncltwocode":"4003",
                "ncltwoname":"纺织品化学处理或加工服务",
                "nclonecode":"40",
                "nclonename":"40类 材料加工"
            },
            {
                "nclthreecode":"170042",
                "nclthreename":"补漏用化学合成物",
                "ncltwocode":"1702",
                "ncltwoname":"非金属密封减震制品",
                "nclonecode":"17",
                "nclonename":"17类 橡胶制品"
            },
            {
                "nclthreecode":"100184",
                "nclthreename":"非化学避孕用具",
                "ncltwocode":"1006",
                "ncltwoname":"性用品",
                "nclonecode":"10",
                "nclonename":"10类 医疗器械"
            },
            {
                "nclthreecode":"090549",
                "nclthreename":"化学仪器和器具",
                "ncltwocode":"0910",
                "ncltwoname":"测量仪器仪表，实验室用器具，电测量仪器，科学仪器",
                "nclonecode":"09",
                "nclonename":"09类 科学仪器"
            },
            {
                "nclthreecode":"070490",
                "nclthreename":"化学工业用电动机械",
                "ncltwocode":"0729",
                "ncltwoname":"其他化学工业用机械",
                "nclonecode":"07",
                "nclonename":"07类 机械设备"
            },
            {
                "nclthreecode":"050488",
                "nclthreename":"治疗谷类植物病害的化学制剂",
                "ncltwocode":"0505",
                "ncltwoname":"杀虫剂，除莠剂，农药",
                "nclonecode":"05",
                "nclonename":"05类 医药"
            },
            {
                "nclthreecode":"050380",
                "nclthreename":"化学盥洗室用消毒剂",
                "ncltwocode":"0503",
                "ncltwoname":"净化制剂",
                "nclonecode":"05",
                "nclonename":"05类 医药"
            },
            {
                "nclthreecode":"050364",
                "nclthreename":"医用或兽医用化学试剂",
                "ncltwocode":"0501",
                "ncltwoname":"药品，消毒剂，中药药材，药酒",
                "nclonecode":"05",
                "nclonename":"05类 医药"
            },
            {
                "nclthreecode":"050363",
                "nclthreename":"兽医用化学制剂",
                "ncltwocode":"0504",
                "ncltwoname":"兽药，动物用膳食补充剂",
                "nclonecode":"05",
                "nclonename":"05类 医药"
            },
            {
                "nclthreecode":"050362",
                "nclthreename":"医用化学制剂",
                "ncltwocode":"0501",
                "ncltwoname":"药品，消毒剂，中药药材，药酒",
                "nclonecode":"05",
                "nclonename":"05类 医药"
            }
        ],
        "count":235//总条数
    },
    "bizmsg":"empty",
    "requestId":"087a6a9cdd0c437e9bfea9bab4a421ab"
}

```

## **<a name="bycznfx"> 商标智能分析</a>**
[返回到目录](#menu)
##### URL
[/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：bycznfx

``` javascript
{
"url":"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_2658156938078025420192511620254zqq_201903191338dcunvwio34tmznfxmb.xlsx"//上传excel文件的url
}


```

#### 返回结果
```javascript
{
    "status":0,
    "msg":null,
    "data":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/9akFZ1xgrQDH_1571041828099.xlsx",//结果文件地址
    "requestId":"0c14f04dc187486b829e392dc87c70c6"
}


```


## **<a name="tmreport"> 商标报告</a>**
[返回到目录](#menu)
##### URL
[api/action/tmQuery/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：tmreport

``` javascript
{
	"actionType":"tmreport",
    "actionBody":
    {
        "companyname":"汉唐信通(北京)咨询股份有限公司",  //公司名称
        "phonenum":"",    //电话　　非必添
        "notifyUrl":"https://icompanytest.gongsibao.com/api/addTmsgByTrademark",   //回调地址　　push_type 为２　时　　不可为空
        "email":"", //邮箱　　push_type 为1　时　　不可为空
        "type":1,    //报告类型　　１　商标　　　２　专利 
        "push_type":1,    //推送类型　　１　邮件　　２　接口
        "receiverId":"001"   //　　用户ｉｄ
    }
}

```

#### 返回结果
```javascript
{"status":0,"msg":"success","data":null,"requestId":"3b8c2108ec8743c0a138081c5223f91c"}


``` 


