var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const fs = require("fs");
//需求操作类
class UtilsNeedService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.aliclient = system.getObject("util.aliyunClient");
    this.ossClient = system.getObject("util.ossClient");
    this.restClient = system.getObject("util.restClient");
  }

  /**
    * 提交需求
   * @param {*} pobj 
    * @param {*} actionBody 
    */
  async submitNeed(pobj, actionBody) {
    if (!actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100380");
    }
    var sobj = pobj;
    sobj.actionType = "getProductTypeInfo";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var rtn = await this.execClient.execPost(sobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResultFail(-5015, "需求類型查询失败");
    }
    var data = JSON.parse(rtn.stdout);
    if (data.status != 0) {
      return system.getResultFail(-5015, "需求類型查询失败");
    }
    pobj.actionBody.type_code = data.data.type_code;
    pobj.actionBody.type_name = data.data.type_name;
    pobj.actionBody.channel_type_code = data.data.channel_type_code;
    pobj.actionBody.channel_type_name = data.data.channel_type_name;
    pobj.actionType = "submitNeed";
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      if(pobj.actionBody.channel_type_code=="esp.companyreg"){
        this.utilsPushSve.aliBusiness2Fq(pobj, "pushNeedBusiness");
      }else{
        if(pobj.actionBody.channel_type_code==5){
          pobj.actionBody.regType="ali.icp";
        }else{
          pobj.actionBody.regType="ali.edi";
        }
        this.utilsPushSve.aliBusiness2Fq(pobj, "intention");
      } 
    }
    return result;
  }

  //调用center-order  icp需求反馈
  async reqCenterOrderApi(pobj, reqUrl) {
    var url = this.centerOrderUrl + "action/icpapi/springBoard";
    if (reqUrl) {
      var url = this.centerOrderUrl + reqUrl;
    }
    pobj.actionType = "receiveIcpFeedback";
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }

  /**
   * 提交需求
   * @param {*} pobj
   * @param {*} actionBody
   */
  async submitNeedH5(pobj, actionBody) {
    var sobj = pobj;
    sobj.actionType = "getProductTypeInfo";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var rtn = await this.execClient.execPost(sobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResultFail(-5015, "需求類型查询失败");
    }
    var data = JSON.parse(rtn.stdout);
    if (data.status != 0) {
      return system.getResultFail(-5015, "需求類型查询失败");
    }
    pobj.actionBody.type_code = data.data.type_code;
    pobj.actionBody.type_name = data.data.type_name;
    pobj.actionBody.channel_type_code = data.data.channel_type_code;
    pobj.actionBody.channel_type_name = data.data.channel_type_name;
    pobj.actionType = "submitNeedH5";
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      if(pobj.actionBody.channel_type_code=="esp.companyreg"){
        this.utilsPushSve.aliBusiness2Fq(pobj, "pushNeedBusiness");
      }
      // else{
      //   if(pobj.actionBody.channel_type_code==5){
      //     pobj.actionBody.regType="ali.icp";
      //   }else{
      //     pobj.actionBody.regType="ali.edi";
      //   }
      //   this.utilsPushSve.aliBusiness2Fq(pobj, "intention");
      // }
    }
    return result;
  }

  //调用center-order  icp需求反馈
  async reqCenterOrderApi(pobj, reqUrl) {
    var url = this.centerOrderUrl + "action/icpapi/springBoard";
    if (reqUrl) {
      var url = this.centerOrderUrl + reqUrl;
    }
    pobj.actionType = "receiveIcpFeedback";
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }

  /**
  * 获取需求详情
 * @param {*} pobj 
  * @param {*} actionBody needNo 需求号
  */
  async getItemByNeedNo(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100385");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(pobj, reqUrl);
    return itemResult;
  }
  /**
  * 获取需求详情
 * @param {*} pobj 
  * @param {*} actionBody needNo 需求号
  */
  async getItemByChannelNeedNo(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100390");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(pobj, reqUrl);
    return itemResult;
  }
  /**
  * 关闭需求
 * @param {*} pobj 
  * @param {*} actionBody 
  */
  async needClose(pobj, actionBody) {
    if (!actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100395");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      this.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseNeed");
      return system.getResultSuccess();
    } else {
      return system.getResult(null, "推送失敗　100388");
    }
  }

  /**
  * icp关闭需求
 * @param {*} pobj 
  * @param {*} actionBody 
  */
  async needCloseIcp(pobj, actionBody) {
    if (!actionBody.channelNeedNo) {
      return system.getResult(null, "actionBody.channelNeedNo can not be empty，100395");
    }
    var self = this;
    pobj.actionBody.intentionBizId = pobj.actionBody.channelNeedNo;
    pobj.actionType = "needClose"
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      //推送ali
      // await self.aliclient.reqbyget({ action: "CloseIntention", reqbody: { BizId: actionBody.channelNeedNo }, apiVersion: "2019-05-08" });
      // self.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseNeed");
      return system.getResultSuccess();
    } else {
      return system.getResult(null, "close fail　100389");
    }

  }

  //查询需求详情
  async getItemByNeedNo(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100395");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  //状态更新
  async icpNotify(pobj) {
    var actionBody = pobj.actionBody;
    var self = this;
    if (!actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100495");
    }
    actionBody.BizId = actionBody.bizId;
    if (!actionBody.status) {
      return system.getResult(null, "actionBody.status can not be empty，100495");
    }
    if (actionBody.businessLicense) {
      actionBody.newbusinessLicense = await self.opDownFileInfo(actionBody.businessLicense);
    }
    if (actionBody.idCardUrlList) {
      var jsonidCardUrlList = JSON.parse(actionBody.idCardUrlList);
      var newidCardUrlList = [];
      for (var i = 0; i < jsonidCardUrlList.length; i++) {
        var key = jsonidCardUrlList[i];
        newidCardUrlList.push(await self.opDownFileInfo(key));
      }
      actionBody.newidCardUrlList = newidCardUrlList;
    }
    if (actionBody.userPlan) {
      actionBody.newuserPlan = await self.opDownFileInfo(actionBody.userPlan);
    }
    if (actionBody.userForeig) {
      actionBody.newuserForeig = await self.opDownFileInfo(actionBody.userForeig);
    }
    if (actionBody.userLaw) {
      actionBody.newuserLaw = await self.opDownFileInfo(actionBody.userLaw);
    }
    if (actionBody.userOtherList) {
      var jsonuserOtherList = JSON.parse(actionBody.userOtherList);
      var newuserOtherList = [];
      for (var i = 0; i < jsonuserOtherList.length; i++) {
        var key = jsonuserOtherList[i];
        newuserOtherList.push(await self.opDownFileInfo(key));
      }
      actionBody.newuserOtherList = newuserOtherList;
    }
    pobj.actionType = "receiveIcpStatusNotify";
    var url = settings.centerOrderUrl() + "action/icpapi/springBoard";
    var rtn = await this.restPostUrl(pobj, url);
    return rtn;
  }

  async opDownFileInfo(docUrl, result) {  //从oss下载到本地并上传到自己oss，之后删除本地文件
    /*docUrl下载链接，全路径，如：https://XXXXXX.pdf?XXXXX */
    try {
      var tmpFileName = docUrl.substring(0, docUrl.lastIndexOf("?"));
      var fileName = tmpFileName.substr(tmpFileName.lastIndexOf("/") + 1, tmpFileName.lenght);
      //解码后的文件全名:xxx.pdf
      var fileAllName = decodeURIComponent(fileName);//为xxx.pdf
      var saveFilePath = '/tmp/' + fileAllName;
      // 下载文件到指定的路径
      var tmpp = await this.restClient.execDownload("'" + docUrl + "'", saveFilePath);
      //上传 saveFilePath的文件 到ossClient
      var rtn = await this.ossClient.upfile(fileAllName, saveFilePath);
      result = rtn.url;
      //删除本地文件
      fs.unlink(saveFilePath, function (err) { });
    } catch (e) {

    }
    return result;
  }

  async needDetailByChannelNo(pobj) {
    if (!pobj.actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100491");
    }
    var solutionobj = {
      actionType: "getIcpProgrammeDetail",
      actionBody: { BizId: pobj.actionBody.bizId },
      appInfo: pobj.appInfo,
      actionProcess: pobj.actionProcess
    }
    var url = this.centerOrderUrl + "action/icpapi/springBoard";
    var solutionrtn = await this.execClient.execPost(solutionobj, url);
    if (!solutionrtn || !solutionrtn.stdout) {
      return system.getResultFail(-5011, "方案查询失败");
    }
    var solutiondata = JSON.parse(solutionrtn.stdout);
    if (solutiondata.status != 0) {
      return system.getResultFail(-5011, "方案查询失败");
    }
    if (solutiondata.data && solutiondata.data[0].channelNeedNo) {
      pobj.actionBody.needNo = solutiondata.data[0].channelNeedNo;
      pobj.actionBody.needId = solutiondata.data[0].channelNeedNo;
      pobj.actionBody.channelSolutionNo = solutiondata.data[0].channelSolutionNo;
    }
    var sobj = {
      actionType: "getItemByChannelNeedNo",
      actionBody: pobj.actionBody,
      appInfo: pobj.appInfo,
      actionProcess: pobj.actionProcess
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(sobj, reqUrl);
    if(itemResult.status==0){
      itemResult.data.channelSolutionNo=pobj.actionBody.channelSolutionNo;
    }
    return itemResult;
  }

  // async test1() {

  //   var a = await this.aliclient.reqbyget({ action: "CloseIntention", reqbody: { BizId: "20200416125415000001", Note: "测试需求关闭" }, apiVersion: "2019-05-08" });
  //   console.log(a.data);
  //   return a;
  // }
}

module.exports = UtilsNeedService;

// var a=new UtilsNeedService();
// a.test1();