var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const logCtl = system.getObject("service.common.oplogSve");
//用户权限操作
class UtilsAuthService extends AppServiceBase {
  constructor() {
    super();
    this.centerAppUrl = settings.centerAppUrl();
  }
  //---------------登录-----------------------------------------------------

  async getReqTokenByHosts(actionBody, tokenValue) { //获取token
    if (["hosts", "appkey"].indexOf(actionBody.reqType) < 0) {
      return system.getResult(null, "actionBody.reqType is error");
    }
    if (actionBody.reqType == "hosts") {
      if (!actionBody.appHosts) {
        return system.getResult(null, "actionBody.appHosts can not be empty");
      }
    }
    if (actionBody.reqType == "appkey") {
      if (!actionBody.appkey) {
        return system.getResult(null, "actionBody.appkey can not be empty");
      }
      if (!actionBody.secret) {
        return system.getResult(null, "actionBody.secret can not be empty");
      }
    }
    var result = await this.cacheManager["AppTokenByHostsCache"].cache(tokenValue, actionBody, system.exTime);
    return result;
  }
  /**
   * 渠道通过账户进行登录，有则返回用户信息，没有则创建用户
   * @param {*} pobj 
   * @param {*} actionBody {channelUserId:XX}
   */
  async getLoginByUserName(pobj, actionBody) {//渠道通过账户进行登录，有则返回用户信息，没有则创建用户---actionBody.channelUserId
    if (!actionBody.channelUserId) {
      return system.getResult(null, "actionBody.channelUserId can not be empty");
    }
    var acckapp = await this.restClient.execPost(pobj, settings.centerAppUrl() + "auth/accessAuth/getLoginByUserName");
    var result = acckapp.stdout;
    if (result) {
      var tmp = JSON.parse(result);
      return tmp;
    }
    return system.getResult(null, "data is empty");
  }

  /**
   * 通过账户和密码登录
   * @param {*} pobj 
   * @param {*} actionBody {userName:XX,password:XXX}
   */
  async getReqUserPinByLgoin(pobj, actionBody) {
    if (!actionBody.userName) {
      return system.getResult(null, "actionBody.userName can not be empty");
    }
    if (!actionBody.password) {
      return system.getResult(null, "actionBody.password can not be empty");
    }
    var acckapp = await this.restClient.execPost(pobj, settings.centerAppUrl() + "auth/accessAuth/login");
    var result = acckapp.stdout;
    if (result) {
      var tmp = JSON.parse(result);
      return tmp;
    }
    return system.getResult(null, "data is empty");
  }
  /**
   * 通过短信登录或注册信息
   * @param {*} pobj 
   * @param {*} actionBody {mobile:XXX,vcode:XXX,reqType:"reg",password:XXX-reqType为reg时有此值}
   */
  async getReqUserPinByLgoinVcode(pobj, actionBody) {
    if (!actionBody.mobile) {
      return system.getResult(null, "actionBody.mobile can not be empty");
    }
    if (!actionBody.vcode) {
      return system.getResult(null, "actionBody.vcode can not be empty");
    }
    if (actionBody.reqType == "reg") {
      if (!actionBody.password) {
        return system.getResult(null, "actionBody.password can not be empty");
      }
    }
    var acckapp = await this.restClient.execPost(pobj, settings.centerAppUrl() + "auth/accessAuth/loginByVerifyCode");
    var result = acckapp.stdout;
    if (result) {
      var tmp = JSON.parse(result);
      return tmp;
    }
    return system.getResult(null, "data is empty");
  }

  /**
   * 获取默认模板的手机验证码
   * @param {*} pobj 
   * @param {*} actionBody {mobile:XXX}
   */
  async getVerifyCodeByMoblie(pobj, actionBody) {
    if (!actionBody.mobile) {
      return system.getResult(null, "actionBody.mobile can not be empty ！");
    }
    return await this.restPostUrl(pobj, this.centerAppUrl + "auth/accessAuth/getVerifyCodeByMoblie");
  }

  /**
   * 通过手机验证码修改用户密码
   * @param {*} pobj 
   * @param {*} actionBody {mobile:XX,vcode:XXX,newPwd:XXX,userpin:XXXXX}
   */
  async putUserPwdByMobile(pobj, actionBody) {
    if (!actionBody.mobile) {
      return system.getResult(null, "pobj.mobile can not be empty ！");
    }
    if (!actionBody.vcode) {
      return system.getResult(null, "pobj.vcode can not be empty ！");
    }
    if (!actionBody.newPwd) {
      return system.getResult(null, "pobj.newPwd can not be empty ！");
    }
    if (!pobj.appInfo) {
      return system.getResult(null, "pobj.appInfo can not be empty ！");
    }
    var result = await this.restPostUrl(pobj, this.centerAppUrl + "auth/accessAuth/modiPasswordByMobile");
    if (result.status == 0) {
      this.userLogout(pobj, actionBody);
    }
    return result;
  }
  /**
   * 通过userpin获取用户登录信息
   * @param {*} pobj 
   * @param {*} actionBody {userpin:XXXXX}
   */
  async getLoginInfo(pobj, actionBody) {
    if (!actionBody.userpin) {
      return system.getResult(null, "pobj.userpin can not be empty ！");
    }
    if (!pobj.appInfo) {
      return system.getResult(null, "pobj.appInfo can not be empty ！");
    }
    var result = await this.restPostUrl(pobj, this.centerAppUrl + "auth/accessAuth/getLoginInfo");
    return result;
  }
  /**
   * 用户退出
   * @param {*} pobj 
   * @param {*} actionBody {userpin:XXXX}
   */
  async userLogout(pobj, actionBody) {
    console.log(actionBody.userpin);
    if (!actionBody.userpin) {
      return system.getResult(null, "actionBody.userpin can not be empty ！");
    }
    var applogout = await this.restPostUrl(pobj, this.centerAppUrl + "auth/accessAuth/logout");
    return applogout;
  }

}
module.exports = UtilsAuthService;
