var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const axios = require('axios')
const md5 = require('md5')
var AlipaySdk = require('alipay-sdk').default;
var WXPay = require('wx-pay');
var xml2js = require('xml2js');
//产品操作类
class UtilsUcommuneService extends AppServiceBase {
    constructor() {
        super();
        this.centerOrderUrl = settings.centerOrderUrl();
    }

    //--------------------------------优客工厂相关接口-start-----------------------------------------------------

    /**
     * 业务统计
     * @param {*} pobj 
     * @param {*} actionBody 
     */
    async getStatistics(pobj, actionBody) {
        var reqUrl = this.centerOrderUrl + "action/ucommuneOrder/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        return result;
    }
    
    /**
     * 趋势分析
     * @param {*} pobj 
     * @param {*} actionBody 
     */
    async getTrend(pobj, actionBody) {
        var reqUrl = this.centerOrderUrl + "action/ucommuneOrder/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        return result;
    }

    /**
     * 产品销售分布
     * @param {*} pobj 
     * @param {*} actionBody 
     */
    async getProductTypesales(pobj, actionBody) {
        var reqUrl = this.centerOrderUrl + "action/ucommuneOrder/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        return result;
    }

    /**
     * 客户地域分布
     * @param {*} pobj 
     * @param {*} actionBody 
     */
    async getCustomerArea(pobj, actionBody) {
        var reqUrl = this.centerOrderUrl + "action/ucommuneOrder/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        return result;
    }

    /**
     * 订单列表
     * @param {*} pobj 
     * @param {*} actionBody 
     */
    async getOrderDeliveryInfo(pobj, actionBody) {
        var reqUrl = this.centerOrderUrl + "action/ucommuneOrder/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        return result;
    }

    /**
     * 订单详情
     * @param {*} pobj 
     * @param {*} actionBody 
     */
    async getOrderDelivery(pobj, actionBody) {
        return system.getResultSuccess({});
    }

    //--------------------------------优客工厂相关接口--end----------------------------------------------------

    /**
     * 优客调取订单列表用
     * @param {*} pobj 
     * @param {*} actionBody 
     */
    async ucommuneGetOrderList(pobj, actionBody) {
        // ucommuneGetOrderList
        var reqUrl = this.centerOrderUrl + "action/ucommuneOrder/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        console.log("-------------ucommuneGetOrderList result start---------------")
        console.log(result)
        console.log("-------------ucommuneGetOrderList result end---------------")
        return result;
    }

    /**
     * 根据优客token获取用户信息，生成userPin返回前端
     * @param {*} pobj 
     * @param {*} actionBody userToken 为优客工厂的userToken
     */
    async getUserInfo(pobj, actionBody) {
        if (!actionBody.userToken) {
            return system.getResult(null, "actionBody.token can not be empty，100410");
        }
        var url = settings.ucommuneUrl() + "third/getUserInfo";    // 调用优客工场接口 获取用户信息
        // 拼接规则curl -k -H 'Content-type: application/json' -H 'authorization:{token}' -X POST {url} pobj作为发生错误时记录日志用
        let result = await this.restPostWithHAuthorizationUrl(pobj, actionBody.userToken, url);
        if (result.retCode == 0) {    // 0成功 1失败
            pobj.actionType = "getLoginByUserName";
            pobj.actionBody.channelUserId = result.data.nationalCode + "-" + result.data.mobile; // 即：86_18512345678
            pobj.actionBody.userName = result.data.mobile;
            pobj.actionBody.nickName = result.data.name;
            pobj.actionBody.mobile = result.data.mobile;
            pobj.actionBody.headUrl = result.data.headImg;
            pobj.actionBody.userpin = pobj.actionBody.userpin || this.getUUID();
            var tmpOpResult = await this.utilsAuthSve.getLoginByUserName(pobj, pobj.actionBody);
            if (tmpOpResult.status != 0 && tmpOpResult.status != 2060) {
                return tmpOpResult;
            }
            return system.getResultSuccess({ userpin: tmpOpResult.data.userpin ? tmpOpResult.data.userpin : pobj.actionBody.userpin })
        } else {
            // 获取用户信息失败
            return system.getResult(null, result);
        }
    }
    /**
     * 优客调取订单列表用
     * @param {*} pobj 
     * @param {*} actionBody 
     */
    async ucommuneGetOrderList(pobj, actionBody) {
        // ucommuneGetOrderList
        var reqUrl = this.centerOrderUrl + "action/ucommuneOrder/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        console.log("-------------ucommuneGetOrderList result start---------------")
        console.log(result)
        console.log("-------------ucommuneGetOrderList result end---------------")
        return result;
    }

    /**
     * addOrder后进入支付页面获取支付金额 addorder返回totalsum 此接口可以不调用
     * @param {*} pobj 
     * @param {*} actionBody orderNo orderIndo订单号
     */
    async orderTotalSum(pobj, actionBody) {
        pobj.actionType = "getOrderDetails" // 获取订单详细信息  totalsum为总金额，返回给前端
        var reqUrl = this.centerOrderUrl + "action/order/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        return result;
    }

    /**
     * 点击确认支付后返回拼接字符串 orderConfirm 的验证数据方法
     * @param {*} pobj 
     * @param {*} actionBody orderNo orderIndo订单号
     */
    async orderCheck(pobj, actionBody) {
        pobj.actionType = "getOrderDetails" // 获取订单详细信息  totalsum为总金额，返回给前端
        var reqUrl = this.centerOrderUrl + "action/order/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        return result;
    }

    /**
     * 点击确认支付后返回拼接字符串 orderConfirm 的验证数据方法
     * @param {*} pobj 
     * @param {*} actionBody orderNo orderIndo订单号
     */
    async orderConfirmValidate(pobj, actionBody) {
        if (!actionBody.orderNo) { // 订单号
            return system.getResult(null, "actionBody.orderNo can not be empty，100430");
        }
        if (!actionBody.payWay) { // 支付方式 1 支付宝 3微信
            return system.getResult(null, "actionBody.payWay can not be empty，100440");
        }
        if (actionBody.payWay != 1 || actionBody.payWay != 3) { // payway 非1非3 
            return system.getResult(null, "actionBody.payWay is eoor values，100450");
        }
    }

    /**
     * 订单详情
     * @param {*} pobj 
     * @param {*} actionBody orderNo orderIndo订单号
     */
    async ucommuneGetOrderDetail(pobj, actionBody) {
        return system.getResultSuccess()
    }


}

module.exports = UtilsUcommuneService;