var APIBase = require("../../api.base");
var system = require("../../../system");
class AccessAuthAPI extends APIBase {
    constructor() {
        super();
        this.utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve");
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
        this.pushlogSve = system.getObject("service.common.pushlogSve");
        this.aliclient = system.getObject("util.aliyunClient");
        this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");
    }
    async taskAliIcapi() {
        var rtn = await this.gatewaypushlogSve.taskAliIcapi();
        return rtn;
    }
    async taskAgainFqPushInfo(pobj, qobj, req) {//再次推送蜂擎业务数据
        var rtn = await this.utilsPushSve.aliBusiness2Fq(pobj, pobj.opType);
        this.pushlogSve.delDbPushfaillogById(Number(pobj.id || 0));
        return rtn;
    }
    async taskAgainPushOneNewBusInfo(pobj, qobj, req) {//再次推送新rpc业务数据
        var rtn = await this.utilsPushSve.againPushBusInfo(pobj);
        this.pushlogSve.delDbPushfaillogById(Number(pobj.id || 0));
        return rtn;
    }
    async taskAgainPushOneOldBusInfo(pobj, qobj, req) {//再次推送老rpc业务数据
        var rtn = await this.aliclient.reqbyget(pobj)
        this.pushlogSve.delDbPushfaillogById(Number(pobj.id || 0));
        return rtn;
    }
    async taskAliTmUpdate(pobj, qobj, req) {//操作阿里商标更新
        var rtn = await this.utilsTmAliyunSve.taskAliTmUpdate();
        return rtn;
    }

    async taskAliRpcAgainPush(pobj, qobj, req) {
        var result = await this.pushlogSve.getFailLogList();
        if (result.status != 0 || !result.data || result.data.length == 0) {
            return system.getResult(null, "push data is empty");
        }
        var self = this;
        for (let index = 0; index < result.data.length; index++) {
            const element = result.data[index];
            if (element) {
                var contentData = JSON.parse(element.content);
                contentData.id = element.id;
                contentData.pushNumber = element.pushNumber + 1;
                if (element.failType == 1) {
                    self.taskAgainPushOneOldBusInfo(contentData);
                }
                else if (element.failType == 2) {
                    self.taskAgainPushOneNewBusInfo(contentData);
                } else if (element.failType == 4) {
                    self.taskAgainFqPushInfo(contentData);
                }//FQ
            }
        }
        return system.getResultSuccess();
    }

    async taskPushPublicService(pobj, qobj, req) {
        var result = await this.pushlogSve.getPublicServiceLogList();
        if (result.status != 0 || !result.data || result.data.length == 0) {
            return system.getResult(null, "PushPublicService data is empty");
        }
        var self = this;
        for (let index = 0; index < result.data.length; index++) {
            const element = result.data[index];
            if (element && element.pushUrl) {
                var contentData = JSON.parse(element.pushContent);
                var opResult = await self.restPostUrl(contentData, element.pushUrl);
                if ((!opResult && opResult.status != 0) || opResult.code != 1) {
                    var tmpPobj = {
                        actionBody: {
                            uapp_key: element.appkey,
                            pushUrl: element.pushUrl,
                            pushContent: contentData,
                            pushNumber: element.pushNumber + 1,
                            resultInfo: opResult
                        }
                    }
                    self.pushlogSve.addPublicServiceLog(tmpPobj, { clientIp: element.clientIp });
                } else {
                    self.logCtl.info({
                        appid: "",
                        appkey: element.appkey,
                        requestId: req.requestId || "",
                        op: req.classname,
                        content: contentData,
                        clientIp: element.clientIp,
                        agent: req.uagent,
                        optitle: "推送公共服务：PushPublicService Success",
                    });
                }
                self.pushlogSve.delPublicServiceLog(element.id);
            }
        }
        return system.getResultSuccess();
    }

}
module.exports = AccessAuthAPI;