<a name="menu">目录</a>
1. [全部订单](#orderList)
1. [订单关闭](#close)
1. [订单分配](#assign)
1. [查看详情](#orderInfo)
1. [编辑](#orderEdit)
1. [交付审核](#deliverAudit)
1. [订单完成](#orderComplete)

1. [创建订单（企服通）](#createOrder)
1. [完善信息](#completedOrder)
1. [订单列表](#orders)
## **<a name="orderList"> 全部订单 </a>**
[返回到目录](#menu)
##### URL
[/web/order/orderCtl/allPage]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "merchant_id": 110361384474,        // 商户id
        "orderNo": "",                      // 订单号
        "createdBegin": "",                 // 创建时间
        "createdEnd": "",
        "assignBegin": "",                  // 分配时间
        "assignEnd": "",
        "status": ""
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": {
        "count": 4,
        "rows": [
            {
                "id": "13180527789003380",                          // 订单号\订单号
                "merchant_id": "11064622752480048",                 // 商户id
                "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
                "price": 300000,                                    // 订单价格（分）
                "legalName": "杨庆菊",                               // 法人姓名
                "legalMobile": "杨庆菊手机号",                        // 法人手机号
                "legalImg": "法人照片",                              // 法人照片
                "idcard": "123身份证",                               // 身份证号码
                "idcardFront": "在正面",                             // 身份证正面图
                "idcardBack": "反面",                                // 身份证反面图
                "bankNo": "2222",                                   // 银行卡号
                "bank": "开户行",                                    // 开户行
                "bankImg": "这是银行卡照片",                          // 银行卡照片
                "names": "名称1,名称2,名称3",                         // 2～3个注册名称，逗号分割

                "domicile_id":""                                    // 注册地id
                "domicileName":""                                   // 注册地名称

                "businessScope_id": "12218127596000645",            // 经营范围id
                "businessType": "物流信息类",                         // 经营范围
                "businessScope": "国内物流信息服务；装",                // 经营范围详情
                "capital": "到底是多少",                              // 注册资本
                "statusName": "未付款",                              // 订单状态名称
                "status": "1000",                                   // 订单状态
                "ostatusName": "待处理",                             // 业务进度状态名称
                "ostatus": "1030",                                  // 业务进度状态
                "assignTime": null,                                 // 分配时间
                "assignUcname": "吴经理",                            // 分配人
                "created_at": "2019-10-05 06:57:28",                // 创建时间

                "deliverType": "",                                  // 交付类型 10交付商交付 20平台交付 30平台保存无需交付
                "deliverTypeName": "",                              // 交付类型名称
                "deliverNo": "",                                    // 快递单号
                "deliverImg": "",                                   // 交接单

                "deliver": {                                        // 交付商
                    "statusName": "待处理"                           // 办理状态名称
                    "status": "1020",                               // 办理状态
                    "deliverName": "开封交付商",                      // 交付商名称
                    "deliverDivide": 3311,                          // 交付商分成比例

                    "auditRemark": null,                            // 审核备注
                    "content": null,                                // 交付内容
                    "addressee": null,                              // 收件人
                    "mobile": null,                                 // 联系电话
                    "addr": null,                                   // 邮寄地址
                    "auditResult": "",                              // 审核状态

                }
                "merchant": {                                       // 商户对象
                    "id": "11064622752480055",                      // 商户id
                    "name": "司机宝"                                 // 商户名号曾
                }

            },
        ]
    }
}

```


## **<a name="close"> 订单关闭 </a>**
[返回到目录](#menu)
##### URL
[/web/order/orderCtl/close]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "id": 110361384474,        // 商户id
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": null
}

```

## **<a name="assign"> 订单分配 </a>**
[返回到目录](#menu)
##### URL
[/web/order/orderCtl/assign]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "id": 110361384474,             // 商户id
        "deliverId": "",               // 交付商id
        "deliverName": "",              // 交付商名称
        "orderDeliver": 500,            // 交付商分成金额
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": null
}

```


## **<a name="orderEdit"> 订单编辑 </a>**
[返回到目录](#menu)
##### URL
[/web/order/orderCtl/orderEdit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "id": "13180527789003380",                      // 订单id
        "merchantId": "11064622752480055",              // 商户id
        "price": 2600.72                                // 订单价格
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": null
}

```

## **<a name="orderInfo"> 查看详情 </a>**
[返回到目录](#menu)
##### URL
[/web/order/orderCtl/allInfo]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "id": "13180527789003380",                      // 订单id
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": {
        "id": "13180527789003380",                          // 订单号\订单号
        "merchant_id": "11064622752480048",                 // 商户id
        "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
        "price": 300000,                                    // 订单价格（分）
        "legalName": "杨庆菊",                               // 法人姓名
        "legalMobile": "杨庆菊手机号",                        // 法人手机号
        "legalImg": "法人照片",                              // 法人照片
        "idcard": "123身份证",                               // 身份证号码
        "idcardFront": "在正面",                             // 身份证正面图
        "idcardBack": "反面",                                // 身份证反面图
        "bankNo": "2222",                                   // 银行卡号
        "bank": "开户行",                                    // 开户行
        "bankImg": "这是银行卡照片",                          // 银行卡照片
        "names": "名称1,名称2,名称3",                         // 2～3个注册名称，逗号分割

        "domicile_id":""                                    // 注册地id
        "domicileName":""                                   // 注册地名称

        "businessScope_id": "12218127596000645",            // 经营范围id
        "businessType": "物流信息类",                         // 经营范围
        "businessScope": "国内物流信息服务；装",                // 经营范围详情
        "capital": "到底是多少",                              // 注册资本
        "statusName": "未付款",                              // 订单状态名称
        "status": "1000",                                   // 订单状态
        "ostatusName": "待处理",                             // 业务进度状态名称
        "ostatus": "1030",                                  // 业务进度状态
        "assignTime": null,                                 // 分配时间
        "assignUcname": "吴经理",                            // 分配人
        "created_at": "2019-10-05 06:57:28",                // 创建时间

        "deliverType": "",                                  // 交付类型 10交付商交付 20平台交付 30平台保存无需交付
        "deliverTypeName": "",                              // 交付类型名称
        "deliverNo": "",                                    // 快递单号
        "deliverImg": "",                                   // 交接单

        "deliver": {                                        // 交付商
            "statusName": "待处理"                           // 办理状态名称
            "status": "1020",                               // 办理状态
            "deliverName": "开封交付商",                      // 交付商名称
            "deliverDivide": 3311,                          // 交付商分成比例

            "auditRemark": null,                            // 审核备注
            "content": null,                                // 交付内容
            "addressee": null,                              // 收件人
            "mobile": null,                                 // 联系电话
            "addr": null,                                   // 邮寄地址
            "auditResult": "",                              // 审核状态
        },

        "businessmen": {
            "orderNo": ""               // 订单号
            "channelOrderNo": ""        // 渠道订单号

            "bstatus": "2020",          // 业务状态
            "bstatusName": "已完成",     // 业务状态名称
            "gstatus": "2020",          // 客户看到的业务状态
            "gstatusName": "已完成",     // 客户看到的业务状态名号曾
            "dstatus": "2020",          // 交付商看到的状态
            "dstatusName": "已完成"      // 交付商看到的状态名称

            "legalName": ""             // 法人姓名
            "legalMobile": ""           // 法人电话
            "name": ""                  // 个体工商户名称
            "creditCode": ""            // 统一社会信用代码
            "businessPlace": ""         // 经营场所
            "businessScope": ""         // 经营范围
            "regDate": ""               // 注册日期
            "businessImg": ""           // 执照照片
            "gongzhang": ""             // 公章
            "caiwuzhang": ""            // 财务章
            "fapiaozhang": ""           // 发票章
            "hetongzhang": ""           // 合同章
            "farenzhang": ""            // 法人章
            "isBank": ""                // 是否开户
            "bankName": ""              // 账户名称
            "bankNo": ""                // 账户号
            "bank": ""                  // 开户行
            "bankImg": ""               // 账户信息
            "caImg": ""                 // CA照片
            "taxRegDay": ""             // 税务登记日
            "taxOrg": ""                // 税务机构名称
            "courierNo": ""             // 快递单号
            "courierImg": ""            // 快递交接单图片
            "addedValueRate": ""        // 增值税率
            "supertaxRate": ""          // 附加税率
            "commonTaxLadder": ""       // 普票个税阶梯
            "commonOtherLadder": ""     // 普票增值税、附加税阶梯
            "specialTaxLadder": ""      // 专票个税阶梯
            "specialOtherLadder": ""    // 专票增值税、附加税阶梯
            "contract": ""              // 个体户合同
            "contractStartData": ""     // 合同开始时间
            "contractEndData": ""       // 合同结束时间
            "notes": ""                 // 备注
            "opNotes": ""               // 操作备注
            "created_at": "",           // 创建时间

            "taxUpType": "1",           // 个税累计类型 1按月累计 2按年累计
            "addValueUpType": "1",      // 增值税累计类型 1按月 2按季度
            "costRate": 11.22,          // 核定成本费用率
            "taxRate": 3.20,            // 含税价百分比
            "serviceRate": 1.25,        // 服务费比例
            "signNotes": null,          // 签约备注
            "signTime": null,           // 签约时间
        }
    },
}

```


## **<a name="deliverAudit"> 交付审核 </a>**
[返回到目录](#menu)
##### URL
[/web/order/orderCtl/deliverAudit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### ※※※ 1140审核失败 1150审核成功
``` javascript

    {
        "id" : "12115182819000593",             // 注意 订单办理id，deliver对象中的id，或者order对象中的orderDeliverId
        "status" : "1140",                      // 1140审核失败 1150审核成功
        "auditRemark" : "边1去",                 // 审核备注
        "content" : "靠靠靠2",                   // 交付内容
        "addressee" : "李庆菊",                  // 收件人
        "mobile" : "131222266663",              // 联系电话
        "addr" : "国创产业园4",                   // 联系地址
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": null
}

```


## **<a name="orderComplete"> 订单完成 </a>**
[返回到目录](#menu)
##### URL
[/web/order/orderCtl/orderComplete]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### ※※※ 1140审核失败 1150审核成功
``` javascript

    {
        "id":"13180527754002366",       // 订单id
        "deliverType":"20",             // 交付类型
        "deliverNo":"xxooxxoo",         // 快递单号
        "deliverImg":"https://g"        // 交接单
        "completeFile":"https://g"      // 客户验收文件----- 这是新加的
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": null
}

```

## **<a name="createOrder"> 创建订单（企服通） </a>**
[返回到目录](#menu)
##### URL
[/web/order/orderCtl/createOrder]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        productType: 1,                       // 产品类型 1000注册订单 1010代开订单 1030代账订单 1040增值服务
        productItems: [1050,1070,1100,1110],  // 注册订单时填写产品项 1050注册 1070刻章 1100银行开户 1110税务报道
        channelNo: "qifutong",                // 渠道名称
        thirdNo: "xxxxxxx",                   // 订单号       varchar(32)
        price: 50000,                         // 订单价格（分） bigint 20
        payType: 1                            // 支付方式 1按次支付 2按年支付
        notes: "",                            // 订单备注 随便写，200个字以内
        legalName: "",                        // 联系人
        legalMobile: "",                      // 联系电话
        legalEmail: "",                       // 联系邮箱
        invoiceType: "",                      // 代开订单时指定发票类型 10 普通发票 20 增值税专用发票 30 电子发票
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": null,
    "requestid": "c179a24ec402454aa0e74c4333cc6eab"
}
```

## **<a name="completedOrder"> 完善信息 </a>**
[返回到目录](#menu)
##### URL
[/web/order/orderCtl/completedOrder]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
	    "orderId": "13699868075000706",      //订单ID
	    "legalName": "president_nan",        //法人名称
	    "legalMobile": "18833836395",        //法人电话
	    "creditCode":"XXEIGIGKTI8989",       //社会统一信用代码
	    "names":"driver baby",               //个体户名称
		"businessScope":"crateTanke",        //经营范围
		"productType":"1010"                 //商品类型  "1000" 注册订单  "1010" 代开订单  "1030"  代账订单 "1040" 增值服务
	}
```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": null,
    "requestid": "c179a24ec402454aa0e74c4333cc6eab"
}
```

## **<a name="orders"> 订单列表 </a>**
[返回到目录](#menu)
##### URL
[/web/order/orderCtl/orders]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
	    "currentPage": "1",                  //页码     非必填
	    "pageSize": "10",                    //记录条数  非必填 
	    "id": "1",                           //发票ID   非必填
		"productType":"1010"                 //商品类型  必填  "1000" 注册订单  "1010" 代开订单  "1030"  代账订单 "1040" 增值服务
	}
```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": {
        "count": 1,
        "rows": [
            {
                "id": "13699868075000706",
                "merchant_id": null,          
                "businessmen_id": null,
                "orderpay_id": null,
                "price": 50000,
                "status": "1000",
                "notes": "by myself",
                "orderDeliverId": "",
                "legalName": "president_nan",
                "legalMobile": "18833836395",
                "names": "driver baby",
                "creditCode": "XXEIGIGKTI8989",
                "isBank": 0,
                "businessScope": "crateTanke",
                "isInfoComplete": 1,
                "created_at": "2019-12-09 02:03:49",
                "updated_at": "2019-12-09T03:42:40.000Z",
                "deleted_at": null,
                "version": 0,
                "statusName": ""
            }
        ]
    },
    "requestid": "e940f89920b4427f93ddbe9c2ff06856"
}
```