const system = require("../../../system");
const ServiceBase = require("../../svems.base")
class OrgService extends ServiceBase {
  constructor() {
    super();
  }
  /**
   * 组织机构  更新
   * @param {*} params 
   */
  async saveOrg(params) {
    try {
      return await this.callms("uc", "saveOrg", params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 组织机构 删除 
   * @param {*} params 
   */
  async delOrg(params) {
    try {
      return await this.callms("uc", "delOrg", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  /**
   * 组织机构  查询列表 
   * @param {*} params 
   */
  async listOrg(params) {
    try {
      return await this.callms("uc", "listOrg", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 组织机构  查询明细
   * @param {*} params 
   */
  async queryById(params) {
    try {
      return await this.callms("uc", "orgQueryById", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 根据pid查出子目录
   * @param {*} params 
   */
  async byPid(params) {
    try {
      return await this.callms("uc", "orgByPid", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 查询整个树结构
   * @param {*} params 
   */
  async tree(params) {
    try {
      return await this.callms("uc", "orgTree", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


}
module.exports = OrgService;