var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ActionAPI extends APIBase {
    constructor() {
        super();
        this.merchantSve = system.getObject("service.merchant.merchantSve");
        this.orderSve = system.getObject("service.order.orderSve");
        this.businessmenSve = system.getObject("service.business.businessmenSve");

        this.merchantrechargeSve = system.getObject("service.merchant.merchantrechargeSve");
        this.merchantaccountSve = system.getObject("service.merchant.merchantaccountSve");

        this.invoiceSve = system.getObject("service.invoice.invoiceSve");

        this.courierSve = system.getObject("service.common.courierSve");

    }
    /**
     * 接口跳转
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springboard(pobj, qobj, req) {
        console.log(pobj, pobj.action_type, !pobj.action_type, "--------------------------------------this is xgg admin ----------------------");
        if (!pobj.action_process) {
            return system.getResult(null, "action_process参数不能为空");
        } 
        if (!pobj.action_type) {
            return system.getResult(null, "action_type参数不能为空");
        }
        var result = null;
        switch (pobj.action_process) {
            case "sijibao"://司机宝
                result = await this.sijibaoOpActionProcess(pobj.action_process, pobj.action_type, pobj.action_body);
                break;
            default:
                result = system.getResult(null, "action_process参数错误");
                break;
        }
        return result;
    }

    async sijibaoOpActionProcess(action_process, action_type, action_body) {
        var opResult = null;
        switch (action_type) {
            // sy
            // case "queryMerchant"://查询商户
            //     opResult = await this.merchantSve.apiQueryMerchant(action_body);
            //     break;
            // case "addOrder"://添加订单
            //     opResult = await this.orderSve.addOrder(action_body);
            //     break;
            // case "putOrder"://修改订单
            //     opResult = await this.orderSve.putOrder(action_body);
            //     break;
            // case "queryOrder"://订单查询
            //     opResult = await this.orderSve.queryOrder(action_body);
            //     break;
            // case "orderClose"://订单查询
            //     opResult = await this.orderSve.orderClose(action_body);
            //     break;
            //
            // case "putContract"://个体工商户合同接收接口
            //     opResult = await this.businessmenSve.putContract(action_body);
            //     break;
            // case "queryBusinessmen"://个体工商户信息查询接口
            //     opResult = await this.businessmenSve.queryBusinessmen(action_body);
            //     break;
            //
            // case "rechargeApplication":// 商户充值申请
            //     opResult = await this.merchantrechargeSve.add(action_body);
            //     break;
            // case "queryMerchantAccount":// 商户充值申请
            //     opResult = await this.merchantaccountSve.infoByMerchantId(action_body);
            //     break;
            // case "calcInvoice": // 发票试算接口
            //     opResult = await this.invoiceSve.apiCalcInvoice(action_body);
            //     break;
            // case "saveInvoice": // 发票提交接口
            //     opResult = await this.invoiceSve.apiSaveInvoice(action_body);
            //     break;
            // case  "cancelInvoice": // 发票提交接口
            //     opResult = await this.invoiceSve.apiCancelInvoice(action_body);
            //     break;
            // case  "queryInvoice": // 发票提交接口
            //     opResult = await this.invoiceSve.apiQueryInvoice(action_body);
            //     break;
            // case "queryTaxInvoice":
            //     opResult = await this.invoiceSve.apiQueryTaxInvoice(action_body);
            //     break;
            //
            // case "queryCourierTrace":
            //     opResult = await this.courierSve.queryCourierTrace(action_body);
            //     break;
            // // 以下接口为推送测试
            // case "testRechargeAudit":// 发票信息查询接口
            //     opResult = await this.merchantrechargeSve.apiAudit(action_body);
            //     break;
            // case "testInvoiceAudit": // 发票审核
            //     opResult = await this.invoiceSve.testInvoiceAudit(action_body);
            //     break;
            // case "testKaipiao": // 发票状态已开具
            //     opResult = await this.invoiceSve.testKaipiao(action_body);
            //     break;
            // case "testToemail": // 发票已邮寄
            //     opResult = await this.invoiceSve.testToemail(action_body);
            //     break;
            // case "testTaxCertificate": // 发票已邮寄
            //     opResult = await this.invoiceSve.testToemail(action_body);
            //     break;
            // wk
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
    exam() {
        return `<pre>

### queryMerchant：查询商户
    功能描述：
        查询公司宝开通的商户基本信息，包含商户基本信息、开票信息、邮寄地址、客户经理等信息，如果业务不需要，可不调用
    请求参数：
        {
                "action_process": "sijibao",
                "action_type": "queryMerchant",
                "action_body": {
                    "sign":"CBCE83769118A4D8906F097ECA558ACF",
                    "times_tamp": 1568713248
                }
        }
    请求参数说明：
        sign      ：  String   ：  必填  ：签名
        times_tamp：  long     ：  必填  : 时间戳
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": {
                "name": "司机宝",
                "taxType": "00",
                "contactName": "杨庆菊",
                "contactMobile": "18810277728",
                "contactEmail": "qjyang@gongsibao.com",
                "invoiceValid": 1,
                "mustPay": 1,
                "status": "1000",
                "ownerName": "客户经理姓名",
                "ownerMobile": "客户经理电话",
                "created_at": "2019-10-01 09:04",       // 添加时间

                "titleList": [
                    {
                        "titleNo": "13661908986000576",
                        "taxNo": "11111111",
                        "invoiceAddr": "222222",
                        "invoiceMobile": "333333",
                        "accountName": "4444444",
                        "accountPublic": "555555555",
                    }
                ],
                "addressList": [
                    {
                        "addressNo": "12085607321000472",
                        "mailAddr": "111111111",
                        "mailTo": "2222222222",
                        "mailMobile": "333333333333333",
                    }
                ]

            },
            "requestid": "8cbd498f9d1441b1812ecaa2653933f4"
        }
    返回值说明：
        name         ：  String   ：商户名称        
        taxType      ：  STRING   ：纳税人类型 00一般纳税人 10小规模纳税人  
        contactName  ：  String   ：联系人姓名     
        contactMobile：  String   ：联系人手机     
        contactEmail ：  String   ：开票申请校验 0否 1是
        invoiceValid ：  int      ：联系人邮箱   
        mustPay      ：  int      ：校验订单支付 0否 1是
        ownerName    ：  String   ：客户经理姓名           
        ownerMobile  ：  String   ：客户经理电话           
        status       ：  String   ：商户状态 00待审核 10待签约 90签约完成

        titleList    ：  Array    ：开票抬头列表
            titleNo      ：  String   ：抬头编码  
            taxNo        ：  String   ：纳税人识别号  
            invoiceAddr  ：  String   ：开票地址        
            invoiceMobile：  String   ：开票电话        
            accountName  ：  String   ：开户名称        
            accountPublic：  String   ：对公账户
 
        addressList  ：  Array    ：开票地址列表
            addressNo    ：  String   ：邮寄地址编码        
            mailAddr     ：  String   ：邮寄地址        
            mailTo       ：  String   ：收件人           
            mailMobile   ：  String   ：收件电话      

### addOrder：添加订单
    功能描述：
        提交/修改 需要注册的个体工商户信息（待处理状态可进行修改，其他状态会修改失败）
    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "addOrder",
            "action_body": {
                "sign": "CBCE83769118A4D8906F097ECA558ACF",
                "times_tamp": 1568713248,
                "channelOrderNo": "test0002",
                "legalName": "测试法人修改",
                "legalMobile": "15010929368",
                "legalImg": "http://sss1.jpg",
                "idcard": "222403",
                "idcardFront": "http://sss2.jpg",
                "idcardBack": "http://sss3.jpg",
                "bankNo": "33333990209874819",
                "bank": "北京市地球村",
                "names": "名称1,名称2,名称3",
                "capital": "1000万",

                "domicileId": "11064622752480055",
                "businessScopeId": "12219252215000155",
                "businessScope": "国内物流信息服务；装卸搬运服务；...",

            }
        }
    请求参数说明：
        sign                ：  String   ：  必填  ：签名
        times_tamp          ：  long     ：  必填  ：时间戳
        channelOrderNo      ：  String   ：  必填  ：渠道单号              
        legalName           ：  String   ：  必填  ：法人姓名              
        legalMobile         ：  String   ：  必填  ：法人电话
        legalImg            ：  String   ： 非必填  ：法人电话
        idcard              ：  String   ：  必填  ：法人身份证
        idcardFront         ：  String   ：  必填  ：身份证正面照片
        idcardBack          ：  String   ：  必填  ：身份证反面照片
        bankNo              ：  String   ：  必填  ：银行卡号
        bank                ：  String   ：  必填  ：开户行
        bankImg             ：  String   ： 非必填  ：银行卡照片

        names               ：  String   ：  必填  ：个体户名称，多个格式为：name1,name2,name3
        capital             ：  String   ：  必填  ：注册资本  
   
        domicileId          ：  String   ：  必填  ：注册地编码
        businessscopeId     ：  String   ：  必填  ：经营范围编码
        businesssScope      ：  String   ：  必填  ：经营范围详情

    返回值：
        添加返回值：
            {
                "status": 0,
                "msg": "success",
                "data": {
                    "orderNo": "sijibao201909191148sJXGu"
                },
                "requestid": "9952e339512740ebb6e5df72a4c09895"
            }
        修改返回值：
            {
                "status": 0,
                "msg": "success",
                "data": null,
                "requestid": "e8f31dacc07c4764b8fd4f9955622385"
            }
    返回值说明：
            data     ：  String   ：订单号     

### queryOrder：订单查询  
    功能描述：
        查询以前添加的订单或者查询某个订单的状态
        
    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "queryOrder",
            "action_body": {
                "sign": "CBCE83769118A4D8906F097ECA558ACF",
                "times_tamp": 1568713248,
                "channelOrderNo": "test0001"
            }
        }
    请求参数说明：
        sign           ：  String   ：  必填  ：签名
        times_tamp     ：  long     ：  必填  ：时间戳
        channelOrderNo ：  String   ：  必填  ：渠道订单号
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": {
                "orderNo": "sijibao2019091816016FXaj",
                "channelOrderNo": "test0001",
                "legalName": "测试法人修改",
                "legalMobile": "15010929368",
                "legalImg": "http://sss1.jpg",
                "idcard": "341221198808328500",
                "idcardFront": "http://sss2.jpg",
                "idcardBack": "http://sss3.jpg",
                "bankNo": "33333990209874819",
                "bank": "北京市地球村",
                "bankImg": "银行卡照片"
                "names": "名称1,名称2,名称3",
                "businessScope": "科技服务行业",
                "capital": "1000万",
                "status": "10",
                "opNotes": null,

                "domicileId": "11064622752480055",
                "businessScopeId": "12219252215000155",
                "businesssScope": "国内物流信息服务；装卸搬运服务；..."
            },
            "requestid": "d108d7fa93984886a3a659114e188a75"
        }
    返回值说明：
        orderNo             ：  String         ：订单号
        channelOrderNo      ：  String         ：渠道单号              
        legalName           ：  String         ：法人姓名              
        legalMobile         ：  String         ：法人电话              
        legalImg            ：  String         ：法人证件照           
        idcard              ：  String         ：法人身份证           
        idcardFront         ：  String         ：身份证正面照片     
        idcardBack          ：  String         ：身份证反面照片     
        bankNo              ：  String         ：银行卡号              
        bank                ：  String         ：开户行       
        bankImg             ：  String         ：银行卡照片
        names               ：  String         ：个体户名称           
        businessScope       ：  String         ：经营范围              
        capital             ：  String         ：注册资本              
        status              ：  String         ：订单状态 1000未付款, 1010订单关闭, 1030待处理, 1050执照办理中, 1060已出执照, 1070刻章办理中, 
                                                1080已刻章, 1090银行开户中, 1100银行卡已开户, 1110税务报道中, 1120已税务报道, 1170已完成
        opNotes             ：  String         ：操作备注  
        
        domicileId          ：  String         ：注册地编码
        businessscopeId     ：  String         ：经营范围编码
        businesssScope      ：  String         ：经营范围详情 


### orderClose：订单关闭接口
        功能描述：
            如果客户订单提交错误，可使用该接口，关闭订单的操作，只允许再 1000未付款 状态下关闭，如果其他状态下关闭，请联系业务办理人员进行沟通
    
        请求参数：
            {
                "action_process": "sijibao",
                "action_type": "orderClose",
                "action_body": {
                    "sign": "CBCE83769118A4D8906F097ECA558ACF",
                    "times_tamp": 1568713248,
                    "channelOrderNo": "test0001",
                }
            }
        请求参数说明：
            sign              ：  String   ：  必填  ：签名
            times_tamp        ：  long     ：  必填  ：时间戳
            channelOrderNo    ：  String   ：  必填  ：渠道订单号
        返回值：
            {
                "status": 0,
                "msg": "success",
                "data": 1,
                "requestid": "b14a73f9d6d84fc7be1e62feaf8316a0"
            }

### putContract：个体工商户合同接收接口
    功能描述：
        个体工商户注册成功后，传入该个体工商户和商户之间的合同信息，才可以做到发票合规

    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "putContract",
            "action_body": {
                "sign": "CBCE83769118A4D8906F097ECA558ACF",
                "times_tamp": 1568713248,
                "channelOrderNo": "test0001",
                "contract": "http://ttt.jpg",
                "contractStartData": "2019-01-10",
                "contractEndData": "2020-01-10"
            }
        }
    请求参数说明：
        sign              ：  String   ：  必填  ：签名
        times_tamp        ：  long     ：  必填  ：时间戳
        channelOrderNo    ：  String   ：  必填  ：渠道订单号
        contract          ：  String   ：  必填  ：合同地址
        contractStartData ：  String   ：  必填  ：合同开始时间(YYYY-MM-DD)
        contractEndData   ：  String   ：  必填  ：合同结束时间(YYYY-MM-DD)
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": null,
            "requestid": "b14a73f9d6d84fc7be1e62feaf8316a0"
        }


### queryMerchantAccount: 商户账户查询
    功能描述：
        查询商户再公司宝系统中的余额
    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "queryMerchantAccount",
            "action_body": {
                "sign": "CBCE83769118A4D8906F097ECA558ACF",
                "times_tamp": 1568713248
            }
        }
    请求参数说明：
        sign              ：  String   ：  必填  ：签名
        times_tamp        ：  long     ：  必填  ：时间戳
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": {
                "merchant_id": "sijibao2019091816016FXaj",  // 商户ID
                "banlance": 2222222    // 可用余额
            },
            "requestid": "305bcbe9b7f444e38c6155033e6cb66c"
        }
    返回值说明：
        merchant_id   ：  String    ：商户ID
        banlance      ：  bigint    ：可用余额（分）

### queryBusinessmen：个体工商户信息查询接口
    功能描述
        查询订单办理的个体工商户信息，包括执照、刻章、银行卡户、税务报道、邮寄、个税/增值税/附加税梯度等信息。
    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "queryBusinessmen",
            "action_body": {
                "sign": "CBCE83769118A4D8906F097ECA558ACF",
                "times_tamp": 1568713248,
                "channelOrderNo": "test0001"
            }
        }
    请求参数说明：
        sign           ：  String   ：  必填   ：签名
        times_tamp     ：  long     ：  必填   ：时间戳
        channelOrderNo ：  String   ：  必填   ：渠道订单号
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": {
                "orderNo": "sijibao2019091816016FXaj",
                "channelOrderNo": "test0001",
                "status": "1050",
                "legalName": "测试法人修改",
                "legalMobile": "15010929368",
                "legalIdCard": "1111110"
                "name": "",
                "creditCode": "",
                "businessPlace": "",
                "businessScope": "",
                "regDate": null,
                "businessImg": "",
                "gongzhang": "",
                "caiwuzhang": "",
                "fapiaozhang": "",
                "hetongzhang": "",
                "farenzhang": "",
                "isBank": 0,
                "bankName": "",
                "bankNo": "",
                "bank": "",
                "bankImg": "",
                "caImg": "",
                "taxRegDay": null,
                "taxOrg": "",
                "courierNo": "",
                "courierImg": "",
                "addedValueRate": 0,
                "supertaxRate": 0,
                "commonTaxLadder": "",
                "commonOtherLadder": "",
                "specialTaxLadder": "",
                "specialOtherLadder": "",
                "contractStartData": "2019-01-10",
                "contractEndData": "2020-01-10",
                "contract": "http://ttt.jpg",
                "opNotes": null,
                
                "taxUpType": "10",
                "costRate": "5.55",
                "signNotes": "xxx",
                "invoiceContents": "",
            },
            "requestid": "305bcbe9b7f444e38c6155033e6cb66c"
        }
    返回值说明：
        orderNo           ：  String   ：订单号    
        channelOrderNo    ：  String   ：渠道订单号             
        status            ：  String   ：状态 1030已出执照, 1050已刻章, 1070银行已开户, 1090已税务报道, 1100待签约 1120已签约
        legalName         ：  String   ：法人姓名 
        legalMobile       ：  String   ：法人电话                
        legalIdCard       ：  String   ：法人身份证号
        name              ：  String   ：个体工商户名称       
        creditCode        ：  String   ：统一社会信用代码    
        businessPlace     ：  String   ：经营场所 
        businessScope     ：  String   ：经营范围 
        regDate           ：  String   ：注册日期（YYYY-MM-DD） 
        businessImg       ：  String   ：执照照片 
        gongzhang         ：  String   ：公章       
        caiwuzhang        ：  String   ：财务章    
        fapiaozhang       ：  String   ：发票章    
        hetongzhang       ：  String   ：合同章    
        farenzhang        ：  String   ：法人章    
        isBank            ：  int      ：是否开户 0否 1是             
        bankName          ：  String   ：账户名称 
        bankNo            ：  String   ：账户号    
        bank              ：  String   ：开户行    
        bankImg           ：  String   ：账户信息 
        caImg             ：  String   ：CA照片     
        taxRegDay         ：  String   ：税务登记日             
        taxOrg            ：  String   ：税务机构名称          
        courierNo         ：  String   ：快递单号 
        courierImg        ：  String   ：快递交接单图片       
        addedValueRate    ：  Double   ：增值税率 
        supertaxRate      ：  Double   ：附加税率 
        commonTaxLadder   ：  String   ：普票个税阶梯     
        commonOtherLadder ：  String   ：普票增值税、附加税阶梯            
        specialTaxLadder  ：  String   ：专票个税阶梯          
        specialOtherLadder：  String   ：专票增值税、附加税阶梯
        contract          ：  String   ：个体户合同             
        contractStartData ：  String   ：合同开始时间（YYYY-MM-DD）
        contractEndData   ：  String   ：合同结束时间（YYYY-MM-DD）
        opNotes           ：  String   ：操作备注
        taxUpType         ：  String   ：个税累计类型 10无 20按月累计 30按年累计
        costRate          ：  Double   ：核定成本费用率
        signNotes         ：  Double   ：签约备注
        invoiceContents   ：  String   ：开票内容（多个以英文逗号分割）

        
### rechargeApplication：商户充值申请接口
    功能描述：
        商户线下充值到公司宝后，提交充值申请接口，由公司宝财务审核通过后，金额加入到账户可用余额中
    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "rechargeApplication",
            "action_body": {
                "amt": 100000,
                "outTradeNo":"1",
                "times_tamp": 1568713248,
                "sign": "D4393F17C96CDA582C1EE5FF0053671E",
                "voucher":"https://www.xxx.com/1.png"
            }
        }
    请求参数说明：
        sign           ：  String   ：  必填   ：签名
        times_tamp     ：  long     ：  必填   ：时间戳
        amt            ：  bigint   ：  必填   ：充值金额（分为单位）
        outTradeNo     ：  String   ：  必填   ：充值流水号（商户下不能重复）
        voucher        ：  String   ：  必填   ：充值凭证图片地址
    返回值：
        {
            "status": 0,
            "msg": "success",
            "requestid": "305bcbe9b7f444e38c6155033e6cb66c"
        }


### calcInvoice：发票试算接口
    功能描述：
        商户使用试算接口，计算出当前开票所需要缴纳的个税、增值税、附加税、服务费等信息，用于开票前的展示，如果商户业务不需要展示，忽略此接口
    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "calcInvoice",
            "action_body": {
                "invoiceList": [
                    {
                        "businessmenCreditCode":"1111",
                        "invoiceTime": "2019-09-19",
                        "invoiceAmt":440000000,
                        "type": 1
                    }
                ],
                "times_tamp": 1568713248,
                "sign": "D4393F17C96CDA582C1EE5FF0053671E"
            }
        }
    请求参数说明：
        sign   ：  String   ：  必填     ：签名
        times_tamp              ：  long     ：  必填     ：时间戳
        invoiceList             ：  Array    ：  必填     ：发票试算列表，最多不超过10个，不参与签名
        businessmenCreditCode   ：  String   ：  必填     ：个体工商户统一社会信用代码
        invoiceTime             ：  String   ：  必填     ：开票时间（YYYY-MM-DD）
        invoiceAmt              ：  bigint   ：  必填     ：开票金额（分）
        type   ：  int      ：  必填     ：开票类型 0普票 1专票
    返回值：
    {
        "status": 0,
        "msg": "success",
        "data": [{
                "creditCode" : "1",
                "code": 1,
                "msg": "success",
                "incomeTax": "20042494",
                "addedValueTax": "28042996",
                "specialTax": "2720171",
                "serviceTax": "9372000",
                "warning": "年度总开票金额已达到4400000",
                "monthAmt": 440000
            },
            {
                "creditCode" : "2",
                "code": 1,
                "msg": "success",
                "incomeTax": "20042494",
                "addedValueTax": "28042996",
                "specialTax": "2720171",
                "serviceTax": "9372000",
                "warning": "年度总开票金额已达到4400000",
                "monthAmt": 440000
            },
        ],
        "requestid": "363e0391a43c4dedb5656623d1bcd540"
    }
    返回值说明：
        "data"              ：  Array    : 发票处理结果
        "creditCode"        ：  int      : 个体户同意社会信用代码
        "code"              ：  int      : 该个体工商户试算状态 1成功 -1失败
        "msg"               ：  String   : 试算结果提示，错误时返回错误信息    
        "incomeTax"         ：  bigint   : 试算个税结果（分）
        "addedValueTax"     ：  bigint   : 试算增值税结果（分）
        "specialTax"        ：  bigint   : 试算附加费结果（分）
        "serviceTax"        ：  bigint   : 试算服务费结果（分）
        "warning"           ：  String   : 警告信息，该字段不为空时，在前端显示,
        "monthAmt"          ：  bigint   : 该个体工商户在开票时间的月分中，已经申请开票的总金额

### saveInvoice：申请开票接口  
    功能描述：
        商户为个体工商户申请开发票，批量开，一次不超过10条发票记录
    请求参数：
    {
        "action_process": "sijibao",
        "action_type": "saveInvoice",
        "action_body": {
            "invoiceList": [
                {
                    "businessmenCreditCode":"1111",
                    "invoiceTime": "2019-09-19",
                    "applyNo": "100001",
                    "invoiceAmt":330000,
                    "settleImg": "https://bpohhr.gongsibao.com",
                    "type": 1
                },
                {
                    "businessmenCreditCode":"2222",
                    "applyNo": "100002",
                    "invoiceTime": "2019-09-19",
                    "invoiceAmt":200000,
                    "settleImg": "https://bpohhr.gongsibao.com",
                    "type": 1
                }
            ],
            "times_tamp": 1568713248,
            "sign": "D4393F17C96CDA582C1EE5FF0053671E"
        }
    }
    请求参数说明：
        sign     ：  String   ：  必填     ：签名
        times_tamp                ：  long     ：  必填     ：时间戳
        invoiceList               ：  Array    ：  必填     ：开票申请列表，最多不超过10个，不参与签名
        businessmenCreditCode     ：  String   ：  必填     ：个体工商户统一社会信用代码
        applyNo  ：  String   ：  必填     ：开票申请编码（商户内唯一）
        invoiceTime               ：  String   ：  必填     ：开票时间（YYYY-MM-DD）
        invoiceAmt                ：  bigint   ：  必填     ：开票金额（分）
        settleImg：  String   ：  必填     ：结算单图片地址
        type     ：  int      ：  必填     ：开票类型 0普票 1专票
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": [{
                    "creditCode": "1",
                    "code": 1,
                    "msg": "success"
                },
                {
                    "creditCode": "2",
                    "code": -1,
                    "msg": "该个体户有发票处于审核中，审核通过后才能继续提交"
                }
            ],
            "requestid": "a39a364d83c14664b8e3399387fa847d"
        }
    返回值说明：
        data       ：  Array   : 发票处理结果
        "creditCode"        ：  Object   : 个体工商户统一社会信用代码为key的对象
        "code"              ：  int      : 该个体工商户试算状态 1成功 -1失败
        "msg"               ：  String   : 试算结果提示，错误时返回错误信息    

### cancelInvoice：发票申请撤回接口
    功能描述：
        商户可再开票申请之后，公司宝财务审核之前进行发票撤回，其他情况联系客户经理
    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "cancelInvoice",
            "action_body": {
                "times_tamp": 1568713248,
                "applyNo": "100001"
            }
        }
    请求参数说明：
        sign     ：  String   ：  必填     ：签名
        times_tamp                ：  long     ：  必填     ：时间戳
        applyNo  ：  String   ：  必填     ：开票申请编号
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": "",
            "requestid": "090bde8c5bb74b9d8c6b97beabf39161"
        }

### queryInvoice：发票查询接口  
    功能描述：
        查询某次开票申请的信息，包括发票状态、开票信息、邮寄信息、完税证明等信息
    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "queryInvoice",
            "action_body": {
                "times_tamp": 1568713248,
                "applyNo": "100001"
            }
        }
    请求参数说明：
        sign     ：  String   ：签名
        times_tamp                ：  long     ：时间戳
        applyNo  ：  String   ：开票申请编号
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": {
                merchant_id   // 商户id 
                applyNo       // 发票申请编号
                status        // 发票状态 00开票申请 10已撤回 20审核驳回 30审核通过 40已开票 50已邮寄

                auditRemark   // 审核备注

                invoiceNo     // 发票编号
                invoiceTime   // 开票时间
                invoiceImg    // 发票照片
                payVoucher    // 支付凭证

                courierNo   // 快递单号
                courierImg  //  快递交接单图片

                taxNo       // 完税批号
                taxTime     // 完税时间
                taxVoucher  // 完税证明（图片地址）
            },
            "requestid": "090bde8c5bb74b9d8c6b97beabf39161"
        }
        
    返回值说明：
        merchantId    ：  bigint  ： 商户id 
        applyNo       ：  String  ： 发票申请编号
        status        ：  String  ： 发票状态 00开票申请 10已撤回 20审核驳回 30审核通过 40已开票 50已邮寄
        auditRemark   ：  String  ： 审核备注
        invoiceNo     ：  String  ： 发票编号
        invoiceTime   ：  String  ： 开票时间(YYYY-MM-DD)
        invoiceImg    ：  String  ： 发票照片
        payVoucher    ：  String  ： 支付凭证
        courierNo     ：  String  ： 快递单号
        courierImg    ：  String  ： 快递交接单图片
        complateTax   ：  int     ： 是否完税  0否 1是
        taxNo         ：  String  ： 完税批号
        taxTime       ：  String  ： 完税时间
        taxVoucher    ：  String  ： 完税证明（图片地址）

### queryTaxInvoice：完税证明查询    
    功能描述：
        查询发票完税证明信息
    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "queryTaxInvoice",
            "action_body": {
                "times_tamp": 1568713248,
                "applyNo": "100001"
            }
        }
    请求参数说明：
        sign     ：  String   ：签名
        times_tamp                ：  long     ：时间戳
        applyNo  ：  String   ：开票申请编号

    返回值：
        {
            merchant_id   // 商户id 
            applyNo       // 发票申请编号
            complateTax   // 是否完税  0否 1是
            taxNo         // 完税批号
            taxTime       // 完税时间
            taxVoucher    // 完税证明（图片地址）
        }
    返回值说明：
        merchant_id   ：  bigint  ： 商户id 
        applyNo       ：  String  ： 发票申请编号
        complateTax   ：  int     ： 是否完税  0否 1是
        taxNo         ：  String  ： 完税批号
        taxTime       ：  String  ： 完税时间
        taxVoucher    ：  String  ： 完税证明（图片地址）


### queryCourierTrace：查询邮寄进度 
    功能描述：
        查询邮寄进度
    请求参数：
        {
            "action_process": "sijibao",
            "action_type": "queryTaxInvoice",
            "action_body": {
                "times_tamp": 1568713248,
                "applyNo": "100001"
            }
        }
    请求参数说明：
        sign                      ：  String   ：签名
        times_tamp                ：  long     ：时间戳
        applyNo                   ：  String   ：开票申请编号
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": {
                merchantId: "",     // 商户id
                applyNo: "",        // 开票申请编号,
                courierNo: "xx"     // 快递单号
                courierStatus // 邮寄状态
                courierTime   // 时间
                desc          // 当前状态描述信息
            },
            "requestid": "090bde8c5bb74b9d8c6b97beabf39161"
        }

        
    返回值说明：
        merchant_id   ：  bigint  ： 商户id 
        applyNo       ：  String  ： 发票申请编号
        courierNo     ：  String  ： 快递单号
        courierStatus ：  String  ： 邮寄状态
        courierTime   ：  String  ： 时间（YYYY-MM-DD HH:mm:ss）
        desc          ：  String  ： 当前状态描述信息



------------------------------------------------------------------------------------------------------------------------------------------   
------------------------------------------------------------------------------------------------------------------------------------------
通知回调商户接口：需要商户提供以下接收的回调地址，回调方式：POST
    1. 充值审核
    2. 订单状态变更推送
    3. 个体户合同审核结果推送
    4. 个体户签约结果推送
    5. 发票状态变更推送 
    6. 发票完税证明推送
### 充值审核
    功能描述：商户提交发票申请后，公司宝财务在审核该申请之后，通知商户审核状态
    推送参数：
    {
        merchantId  ：  String   ：商户id  
        outTradeNo   ：  String   ：充值流水号,
        status       ：  int      ：审核状态 00待审核 10已入账 20审核失败
        remark       ：  String   ：审核备注
    }

### 订单状态变更推送
    功能描述：订单状态发生变更后，公司宝将状态变更内容推送给商户
    推送参数：
    {
        merchantId      ：   String    ： 商户id     
        status           ：   String     ： 订单状态 1050执照办理中, 1060已出执照, 1070刻章办理中, 1080已刻章, 1090银行开户中, 1100银行卡已开户, 1110税务报道中, 1120已税务报道, 1170已完成
        channelOrderNo   ：   String     ： 渠道订单号    

        // ----- 出执照推送数据 -----
        name             ：   String     ： 个体工商户名称           
        creditCode       ：   String     ： 统一社会信用代码        
        businessPlace    ：   String     ： 经营场所 
        businessScope    ：   String     ： 经营范围 
        regDate          ：   String     ： 注册日期 （YYYY-MM-DD）
        businessImg      ：   String     ： 执照照片          
        orderNo          ：   String     ： 订单号    
        legalName        ：   String     ： 法人姓名 
        legalMobile      ：   String     ： 法人电话  
        
        // ----- 刻章推送数据 -----
        gongzhang        ：   String     ： 公章       
        caiwuzhang       ：   String     ： 财务章    
        businessImg      ：   String     ： 执照照片 
        fapiaozhang      ：   String     ： 发票章    
        hetongzhang      ：   String     ： 合同章    
        farenzhang       ：   String     ： 法人章    

        // ----- 开户推送数据 -----
        isBank           ：   int        ： 是否开户 
        bankName         ：   String     ： 账户名称 
        bankNo           ：   String     ： 账户号    
        bank             ：   String     ： 开户行    
        bankImg          ：   String     ： 账户信息   

        // ----- 税务报到推送数据 -----
        caImg            ：   String     ： CA照片 
        taxRegDay        ：   String     ： 税务登记日 
        taxOrg           ：   String     ： 税务机构名称 

        // ----- 邮寄推送数据 -----
        courierNo        ：   String     ： 快递单号  
        courierImg       ：   String     ： 快递交接单图片 
    }

### 个体户合同审核结果推送
    推送参数：
    {
        merchantId      ：   String     ： 商户id     
        channelOrderNo   ：   String     ： 渠道订单号 
        status           ：   String     ： 审核状态 10成功 20失败    
    }
6. 个体户签约结果推送
    推送参数
    {
        merchantId       ：  String   ：商户id
        channelOrderNo    ：  String   ：渠道订单号  
        creditCode        ：  String   ：统一社会信用代码   

        commonTaxLadder   ：  String   ：普票个税阶梯     
        commonOtherLadder ：  String   ：普票增值税、附加税阶梯            
        specialTaxLadder  ：  String   ：专票个税阶梯          
        specialOtherLadder：  String   ：专票增值税、附加税阶梯
        taxUpType         ：  String   ：个税累计类型 10无 20按月累计 30按年累计
        costRate          ：  Double   ：核定成本费用率
        signNotes         ：  Double   ：签约备注
        invoiceContents   ：  String   ：开票内容（多个以英文逗号分割）
    }
platformAssignment
7.发票状态变更推送       
    功能描述：发票状态变更后，公司宝将发票状态变更内容推送给商户
    推送参数：
    {
        merchantId         ：   bigint     ：商户id 
        applyNo             ：   String     ：发票申请编号
        status              ：   String     ：发票状态 0090开票申请 1010审核驳回 1030审核通过 1050已开票 1090已完成
        
        // ----- 发票审核数据字段 -----
        auditRemark         ：   String     ：审核备注

        // ----- 发票开具数据字段 -----
        invoiceNo           ：   String     ：发票编号
        invoiceTime         ：   String     ：开票时间
        invoiceImg          ：   String     ：发票照片
        payVoucher          ：   String     ：支付凭证
        
        // ----- 发票邮件数据字段 -----
        courierNo           ：   String     ：快递单号
        courierImg          ：   String     ：快递交接单图片
    }
8.发票完税证明推送           
    功能描述：公司宝客户经理再处理完税证明后，公司宝将完税证明信息推送给商户
    推送参数：
    {
        merchant_id         ：   bigint     ：商户id 
        applyNo             ：   String     ：发票申请编号

        complateTax         ：   String     ：是否完税  0否 1是
        taxNo               ：   String     ：完税批号
        taxTime             ：   String     ：完税时间
        taxVoucher          ：   String     ：完税证明（图片地址）
    }
    <pre/>`;
    }
    classDesc() {
        return {
            groupName: "op",
            groupDesc: "元数据服务包",
            name: "ActionAPI",
            desc: "此类是对外提供接口服务",
            exam: "",
        };
    }
    methodDescs() {
        return [
            {
                methodDesc: `<pre>请求地址：http://sj.app.com:3002/api/op/action/springboard   
    请求时需要在请求头中增加app_id参数信息，app_id由平台提供给调用方
    方法中的签名只有action_body中的参数参与，按照参数的首字母进行ASCII码进行正序排列后进行签名，action_body中的参数为空或参数为list或为json的不参与签名
    签名字符串示例：times_tamp=1568713248&key=XXXX，key为平台提供的密钥，对字符串进行
    后进行大写转换
    方法中需要传递的action_type列表有： 
            queryMerchant：查询商户
            addOrder/putOrder：添加订单/修改订单
            queryOrder：订单查询  
            orderClose：订单关闭接口
            putContract：个体工商户合同接收接口
            queryMerchantAccount: 商户账户查询
            queryBusinessmen：个体工商户信息查询接口
            rechargeApplication：商户充值申请接口
            calcInvoice：发票试算接口
            saveInvoice：申请开票接口 
            cancelInvoice：发票申请撤回接口  
            queryInvoice：发票查询接口   
            queryTaxInvoice：完税证明查询    
            queryCourierTrace：查询邮寄进度  
        <pre/>`,
                methodName: "springboard",
                paramdescs: [
   {
       paramDesc: "请求的行为，传递如：sijibao",
       paramName: "action_process",
       paramType: "string",
       defaultValue: null,
   },
   {
       paramDesc: "业务操作类型，详情见方法中的描述",
       paramName: "action_type",
       paramType: "string",
       defaultValue: null,
   },
   {
       paramDesc: "业务操作类型的参数，action_body必须传递的参数有，times_tamp（时间戳，类型int）、sign(签名,类型string)，其余的为业务需要的参数",
       paramName: "action_body",
       paramType: "json",
       defaultValue: null,
   }
                ],
                rtnTypeDesc: `<pre>
                status: 返回状态,
                msg: 返回信息描述，验证有误则为错误提示,
                data: 返回数据信息,
                requestid: 返回的处理此次请求的凭证               
                status状态码如下：
                0     业务请求处理成功
                -1    请求参数验证失败
                1200  访问appid失效
                1300  签名验证失败
            <pre/>`,
                rtnType: `<pre>
                {
   "status": 0,
   "msg": "success",
   "data": {},
   "requestid": "8cbd498f9d1441b1812ecaa2653933f4"
                }
            <pre/>`
            }
        ];
    }
}
module.exports = ActionAPI;