var path = require('path');
var ENVINPUT = {
  DB_HOST: process.env.BPOSTAT_DB_HOST,
  DB_PORT: process.env.BPOSTAT_DB_PORT,
  DB_USER: process.env.BPOSTAT_DB_USER,
  DB_PWD: process.env.BPOSTAT_DB_PWD,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  DB_NAME: process.env.BPOSTAT_DB_NAME,
  REDIS_DB: process.env.BPOSTAT_REDIS_DB,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : "dev"
};
var settings = {
  env: ENVINPUT.APP_ENV,
  platformid: 1,
  platformcompanyid: 1,
  commonroleid: 1,
  passroleid: 2,
  tanentroleid: 1,
  protocalPrefix: "http://",

  appKey: ENVINPUT.APP_ENV == "dev" ? "2f41920e82fa46dd98887d81df9457ab" : "728b979f7afd4413ac683344cd4a97fa",
  secret: ENVINPUT.APP_ENV == "dev" ? "ede9b66ddb964d15b0a543b7ac7bb28f" : "f8891fcf37574f5a9f21b3030c302f4a",

  salt: "%iatpD1gcxz7iF#B",
  defaultpwd: "987456",
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 3013,
  reqEsAddr: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return "http://43.247.184.94:7200/"; //localsettings.reqEsDevUrl;
    } else {
      return "http://43.247.184.94:7200/";
    }
  },
  paasUrl: function () {
    if (this.env == "dev") {
      return "http://192.168.18.237:4001/";
      // return "http://192.168.18.125:4001/";
    } else {
      return "https://open.gongsibao.com/";
    }
  },
  apiconfig: {
    opLogUrl: function () {
      return settings.reqEsAddr() + "bigdata_zc_op_log/_doc?pretty";
    },
    opLogEsIsAdd: function () {
      return 1;
    },
  },
  indexPage: function() {
    if(this.env == "dev") {
      // return "http://localhost:8080";
      return "https://xggadmin.gongsibao.com";
    } else {
      return "https://xggadmin.gongsibao.com";
    }
  },
  homePage: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.reqHomePageDevUrl;
    } else {
      return "https://open.gongsibao.com/";
    }
  },
  authUrl: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.reqAuthUrl;
    } else {
      return "https://open.gongsibao.com/auth";
    }
  },
  docUrl: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.docUrl;
    } else {
      return "https://open.gongsibao.com/web/common/metaCtl/getApiDoc";
    }
  },
  redis: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.redis;
    } else {
      return {
        host: ENVINPUT.REDIS_HOST,
        port: ENVINPUT.REDIS_PORT,
        password: ENVINPUT.REDIS_PWD,
        db: ENVINPUT.REDIS_DB,
      };
    }
  },
  database: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.database;
    } else {
      return {
        dbname: ENVINPUT.DB_NAME,
        user: ENVINPUT.DB_USER,
        password: ENVINPUT.DB_PWD,
        config: {
          host: ENVINPUT.DB_HOST,
          dialect: 'mysql',
          operatorsAliases: false,
          pool: {
            max: 5,
            min: 0,
            acquire: 90000000,
            idle: 1000000
          },
          debug: false,
          dialectOptions: {
            requestTimeout: 999999,
            // instanceName:'DEV'
          } //设置MSSQL超时时间
        },
      };
    }
  }
};
settings.ENVINPUT = ENVINPUT;
module.exports = settings;