const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class RecruitService extends ServiceBase {
    constructor() {
        super("all", ServiceBase.getDaoName(RecruitService));
    }

    async signPage(params) {
        var currentPage = Number(params.currentPage || 0);
        var pageSize = Number(params.pageSize || 10);

        var where = {};
        if (params.company_name) {
            where.company_name = {
                [this.db.Op.like]: "%" + params.company_name + "%"
            };
        }
        if(params.sign_body_id){
            where.sign_body_id = params.sign_body_id;
        }
        this.addWhereTime(where, 'publish_date', params.signBegin, params.signEnd, true);
        var orderby = [
            ["id", 'desc']
        ];
        var page = await this.getPageList(currentPage, pageSize, where, orderby);
        if (page && page.rows) {
            for (var row of page.rows) {
                this.handleDate(row, ["publish_date"], "YYYY-MM-DD", -8);
            }
        }
        return page;
    }

}

module.exports = RecruitService;
