const system = require("../../../system");
const Dao = require("../../dao.base");

class MerchantAccountDao extends Dao {
    constructor() {
        super(Dao.getModelName(MerchantAccountDao));
    }

    async listByIds(ids, attrs) {
        if (!ids || ids.length == 0) {
            return [];
        }
        var sql = [];
        sql.push("SELECT");
        sql.push(attrs || "*");
        sql.push("FROM");
        sql.push(this.model.tableName);
        sql.push("WHERE id IN (:ids)");
        return await this.customQuery(sql.join(" "), {
            ids: ids
        }) || [];
    }

    async mapByIds(ids, attrs) {
        var result = {};
        if (!ids || ids.length == 0) {
            return result;
        }
        var list = await this.listByIds(ids, attrs);
        if (!list || list.length == 0) {
            return result;
        }
        for (var item of list) {
            result[item.id] = item;
        }
        return result;
    }
}

module.exports = MerchantAccountDao;