const system = require("../../../system");
const Dao = require("../../dao.base");

class MerchantDao extends Dao {
    constructor() {
        super(Dao.getModelName(MerchantDao));
    }
    async merchantInfo(params){
        let sql = [];
        sql.push("SELECT * FROM merchant_info WHERE 1 = 1 ");

        this.setSqlParams(params, sql);

        return await this.customQuery(sql.join(" "), params);
    }

    setSqlParams(params, sql) {
        if(params.sign_body_id){
            sql.push("AND sign_body_id = :sign_body_id");
        }
        if (params.id) {
            sql.push("AND id = :id");
        }
    }

}

module.exports = MerchantDao;
