const system = require("../../../system");
const Dao = require("../../dao.base");

class electroniccontractDao extends Dao {
    constructor() {
        super(Dao.getModelName(electroniccontractDao));
    }

    async statCount(companyNames, sign_body_id) {
        var result = {};
        if(!companyNames || companyNames.length == 0) {
            return result;
        }
        let and = [];
        and.push("company_name IN (:companyNames)");
        if (sign_body_id) {
            and.push("AND sign_body_id = :sign_body_id");
        }

        var sql = `SELECT company_name, COUNT(1) AS num FROM electronic_contract_info WHERE ${and.join(" ")}  GROUP BY company_name`;
        let list = await this.customQuery(sql, {companyNames: companyNames, sign_body_id: sign_body_id});
        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            result[item.company_name] = item.num || 0;
        }
        return result;
    }

    async sCount(inno) {
        var result = {};
        if(!inno || inno.length == 0) {
            return result;
        }
        var sql = "SELECT id_no, COUNT(1) AS num FROM `electronic_contract_info` WHERE id_no IN (:inno) GROUP BY id_no";

        let list = await this.customQuery(sql, {inno: inno});

        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            result[item.id_no] = item.num || 0;
        }
        return result;
    }

    async countByIdNo(params) {
        let sql = [];
        sql.push("SELECT COUNT(DISTINCT id_no) AS num FROM electronic_contract_info WHERE 1 = 1 ");
        this.setSqlParams(params, sql);
        let rs = await this.customQuery(sql.join(" "), params);

        if(rs && rs.length > 0) {
            return rs[0].num || 0;
        }
        return 0;
    }

    async listByIdNo(params) {
        let sql = [];
        sql.push("SELECT * FROM electronic_contract_info WHERE 1 = 1 ");

        this.setSqlParams(params, sql);

        sql.push("GROUP BY id_no");
        sql.push("ORDER BY id DESC");
        sql.push("LIMIT :startRow, :pageSize");

        return await this.customQuery(sql.join(" "), params);
    }

    setSqlParams(params, sql) {
        if (params.company_name) {
            sql.push("AND company_name = :company_name");
        }
        if(params.sign_body_id){
            sql.push("AND sign_body_id = :sign_body_id");
        }
        if(params.id_no) {
            sql.push("AND id_no = :id_no");
        }
        if (params.signBegin) {
            sql.push("AND id_no >= :signBegin");
        }
        if (params.signEnd) {
            sql.push("AND id_no <= :signEnd");
        }
    }
}

module.exports = electroniccontractDao;
