var system = require("../../../system")
const CtlBase = require("../../ctl.base");
//招聘需求
class SignbodyCtl extends CtlBase {
    constructor() {
        super("all", CtlBase.getServiceName(SignbodyCtl));
    }

    async allList(qobj){
        var params = qobj || {};
        this.doTimeCondition(params, ["signBegin", "signEnd"]);
        try {
            var page = await this.service.signPage(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }


    async signBodyInfo(qobj){
        var params = qobj || {};
        try {
            if(!params.sign_body_id){
                return system.getResultFail(-1,"参数错误");
            }
            var info = await this.service.findById(params.sign_body_id);
            return system.getResult2(info);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }

    }


}

module.exports = SignbodyCtl;
