<a name="menu">目录</a>
1. [新增订单](#createOrder)
1. [完善信息接口](#completedOrder)
1. [订单办理接口](#handling)
1. [订单列表](#orders)



## **<a name="createOrder"> 新增订单</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
{
    "action_process": "test",
    "action_type": "createOrder",
    "action_body": {
        productType: 1,                       // 产品类型 1000注册订单 1010代开订单 1030代账订单 1040增值服务
        productItems: [1050,1070,1100,1110],  // 注册订单时填写产品项 1050注册 1070刻章 1100银行开户 1110税务报道
        channelNo: "qifutong",                // 渠道名称
        thirdNo: "xxxxxxx",                   // 订单号       varchar(32)
        price: 50000,                         // 订单价格（分） bigint 20
        payType: 1                            // 支付方式 1按次支付 2按年支付
        notes: "",                            // 订单备注 随便写，200个字以内
        legalName: "",                        // 联系人
        legalMobile: "",                      // 联系电话
        legalEmail: "",                       // 联系邮箱
        invoiceType: "",                      // 代开订单时指定发票类型 10 普通发票 20 增值税专用发票 30 电子发票
    }
}
```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": null,
    "requestid": "c179a24ec402454aa0e74c4333cc6eab"
}
```



## **<a name="completedOrder"> 完善信息接口</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
{
    "action_process": "test",
    "action_type": "completedOrder",
    "action_body": {
	    "orderId": "13699868075000706",      //订单ID
	    "legalName": "president_nan",        //法人名称
	    "legalMobile": "18833836395",        //法人电话
	    "creditCode":"XXEIGIGKTI8989",       //社会统一信用代码
	    "names":"driver baby",               //个体户名称
		"businessScope":"crateTanke",        //经营范围
		"productType":"1010"                 //商品类型  "1000" 注册订单  "1010" 代开订单  "1030"  代账订单 "1040" 增值服务
	}
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": null,
    "requestid": "9e1980f84d7d451797d682821e4b438e"
}

```


## **<a name="orders"> 订单列表</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
{
    "action_process": "test",
    "action_type": "completedOrder",
    "action_body": {
	    "currentPage": "1",                  //页码     非必填
	    "pageSize": "10",                    //记录条数  非必填 
	    "id": "1",                           //发票ID   非必填
		"productType":"1010"                 //商品类型  必填  "1000" 注册订单  "1010" 代开订单  "1030"  代账订单 "1040" 增值服务
	}
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "success",
    "data": {
        "count": 1,
        "rows": [
            {
                "id": "13699868075000706",
                "merchant_id": null,
                "businessmen_id": null,
                "orderpay_id": null,
                "price": 50000,
                "status": "1000",
                "notes": "by myself",
                "orderDeliverId": "",
                "legalName": "president_nan",
                "legalMobile": "18833836395",
                "names": "driver baby",
                "creditCode": "XXEIGIGKTI8989",
                "isBank": 0,
                "businessScope": "crateTanke",
                "isInfoComplete": 1,
                "created_at": "2019-12-09 02:03:49",
                "updated_at": "2019-12-09T03:42:40.000Z",
                "deleted_at": null,
                "version": 0,
                "statusName": ""
            }
        ]
    },
    "requestid": "e940f89920b4427f93ddbe9c2ff06856"
}

```
## **<a name="allList"> 全部订单</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "allOrderList",
        "action_body": {
            "currentPage": "1",     
            "pageSize": "5",
            "merchantId": "",           // 商户id
            "orderId": "",              // 订单id
            "status": "",               // 订单状态 1000未付款, 1010待处理, 1020执照办理中, 1030已出执照, 1040刻章办理中, 1050已刻章, 
                                        //         1060银行开户中, 1070银行已开户, 1080税务报道中, 1090已税务报道, 1100已完成
                         
            "createdBegin": "",         // 创建时间开始
            "createdEnd": "",           // 创建时间结束
            "assignBegin": "",          // 分配时间开始
            "assignEnd": "",            // 分配时间结束

        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "count": 12,
            "rows": [
                {
                    "id": "13180527789003380",                          // 订单号\订单号
                    "merchant_id": "11064622752480048",                 // 商户id
                    "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
                    "price": 300000,                                    // 订单价格（分）
                    "legalName": "杨庆菊",                               // 法人姓名
                    "legalMobile": "杨庆菊手机号",                        // 法人手机号
                    "legalImg": "法人照片",                              // 法人照片
                    "idcard": "123身份证",                               // 身份证号码
                    "idcardFront": "在正面",                             // 身份证正面图
                    "idcardBack": "反面",                                // 身份证反面图
                    "bankNo": "2222",                                   // 银行卡号
                    "bank": "开户行",                                    // 开户行
                    "bankImg": "这是银行卡照片",                          // 银行卡照片
                    "names": "名称1,名称2,名称3",                         // 2～3个注册名称，逗号分割

                    "domicile_id":""                                    // 注册地id
                    "domicileName":""                                   // 注册地名称

                    "businessScope_id": "12218127596000645",            // 经营范围id
                    "businessType": "物流信息类",                         // 经营范围
                    "businessScope": "国内物流信息服务；装",                // 经营范围详情
                    "capital": "到底是多少",                              // 注册资本
                    "statusName": "未付款",                              // 订单状态名称
                    "status": "1000",                                   // 订单状态
                    "ostatusName": "待处理",                             // 业务进度状态名称
                    "ostatus": "1030",                                  // 业务进度状态
                    "assignTime": null,                                 // 分配时间
                    "assignUcname": "吴经理",                            // 分配人
                    "created_at": "2019-10-05 06:57:28",                // 创建时间

                    "deliverType": "",                                  // 交付类型
                    "deliverNo": "",                                    //
                    "deliverImg": "",                                   // 


                    "deliver": {                                        // 交付商
                        "statusName": "待处理"                           // 办理状态名称
                        "status": "1020",                               // 办理状态
                        "deliverName": "开封交付商",                      // 交付商名称
                        "deliverDivide": 3311,                          // 交付商分成比例
                    }
                },
                ...
            ]
        },
        "requestid": "ae2a9c2e2ff6497e8cc9fd2c7fac9fe8"
    }
```


## **<a name="info"> 订单信息</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "orderInfo",
        "action_body": {
            "id": "13180527789003380"
        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "id": "13180527789003380",                          // 订单号\订单号
            "merchant_id": "11064622752480048",                 // 商户id
            "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
            "price": 300000,                                    // 订单价格（分）
            "price_y": "3000",                                  // 订单价格（元）
            "legalName": "杨庆菊",                               // 法人姓名
            "legalMobile": "杨庆菊手机号",                        // 法人手机号
            "legalImg": "法人照片",                              // 法人照片
            "idcard": "123身份证",                               // 身份证号码
            "idcardFront": "在正面",                             // 身份证正面图
            "idcardBack": "反面",                                // 身份证反面图
            "bankNo": "2222",                                   // 银行卡号
            "bank": "开户行",                                    // 开户行
            "bankImg": "这是银行卡照片",                          // 银行卡照片
            "names": "山驴比1,山驴比2,山驴比3",                    // 2～3个注册名称，逗号分割

            "domicile_id":""                                    // 注册地id
            "domicileName":""                                   // 注册地名称

            "businessScope_id": "12218127596000645",            // 经营范围id
            "businessType": "太难了",                            // 经营范围
            "businessScope": "太狠了",                           // 经营范围详情
            "capital": "到底是多少",                              // 注册资本
            "statusName": "未付款",                              // 订单状态名称
            "status": "1000",                                   // 订单状态
            "assignTime": null,                                 // 分配时间
            "created_at": "2019-10-05 06:57:28",                // 创建时间
        },
        "requestid": "721e93dbdfb54115a76bf32a4900cd6e"
    }
```

## **<a name="edit"> 订单编辑</a>**
[返回到目录](#menu)
#### 接口说明  该接口只编辑商户id和订单价格，（商户id随时可编辑），（订单价格只有在 1000未付款状态时可编辑）
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "orderAssign",
        "action_body": {
            "id": "13180532689003786",
            "deliverId": "13120681466000118",
            "deliverName": "杨庆菊交付商222",
            "deliverDivide": 3311
        }
    }
```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "id": "13180527789003380",                          // 订单号\订单号
            "merchant_id": "11064622752480048",                 // 商户id
            "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
            "price": 300000,                                    // 订单价格（分）
            "price_y": "3000",                                  // 订单价格（元）
            "legalName": "杨庆菊",                               // 法人姓名
            "legalMobile": "杨庆菊手机号",                        // 法人手机号
            "legalImg": "法人照片",                              // 法人照片
            "idcard": "123身份证",                               // 身份证号码
            "idcardFront": "在正面",                             // 身份证正面图
            "idcardBack": "反面",                                // 身份证反面图
            "bankNo": "2222",                                   // 银行卡号
            "bank": "开户行",                                    // 开户行
            "bankImg": "这是银行卡照片",                          // 银行卡照片
            "names": "山驴比1,山驴比2,山驴比3",                    // 2～3个注册名称，逗号分割

            "domicile_id":""                                    // 注册地id
            "domicileName":""                                   // 注册地名称

            "businessScope_id": "12218127596000645",            // 经营范围id
            "businessType": "太难了",                            // 经营范围
            "businessScope": "太狠了",                           // 经营范围详情
            "capital": "到底是多少",                              // 注册资本
            "statusName": "未付款",                              // 订单状态名称
            "status": "1000",                                   // 订单状态
            "assignTime": null,                                 // 分配时间
            "created_at": "2019-10-05 06:57:28",                // 创建时间
        },
        "requestid": "721e93dbdfb54115a76bf32a4900cd6e"
    }
```



## **<a name="pc-myorders"> 我的订单-pc</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "myOrderPage",
        "action_body": {
            "currentPage": "1",     
            "pageSize": "5",
            "userId": "",               // 用户id
            "createdBegin": "",         // 创建时间开始
            "createdEnd": "",           // 创建时间结束
        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "count": 12,
            "rows": [
                {
                    "id": "13180527789003380",                          // 订单号\订单号
                    "merchant_id": "11064622752480048",                 // 商户id
                    "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
                    "price": 300000,                                    // 订单价格（分）
                    "legalName": "杨庆菊",                               // 法人姓名
                    "legalMobile": "杨庆菊手机号",                        // 法人手机号
                    "legalImg": "法人照片",                              // 法人照片
                    "idcard": "123身份证",                               // 身份证号码
                    "idcardFront": "在正面",                             // 身份证正面图
                    "idcardBack": "反面",                                // 身份证反面图
                    "bankNo": "2222",                                   // 银行卡号
                    "bank": "开户行",                                    // 开户行
                    "bankImg": "这是银行卡照片",                          // 银行卡照片
                    "names": "山驴比1,山驴比2,山驴比3",                    // 2～3个注册名称，逗号分割
                    "domicile_id":""                                    // 注册地id
                    "domicileName":""                                   // 注册地名称

                    "domicile_id":""                                    // 注册地id
                    "domicileName":""                                   // 注册地名称

                    "businessScope_id": "12218127596000645",            // 经营范围id
                    "businessType": "太难了",                            // 经营范围
                    "businessScope": "太狠了",                           // 经营范围详情

                    "capital": "到底是多少",                              // 注册资本
                    "statusName": "未付款",                              // 订单状态名称
                    "status": "1000",                                   // 订单状态
                    "assignTime": null,                                 // 分配时间
                    "created_at": "2019-10-05 06:57:28",                // 创建时间
                },
                ...domicile_id
            ]
        },
        "requestid": "ae2a9c2e2ff6497e8cc9fd2c7fac9fe8"
    }
```