<a name="menu">目录</a>
1. [新增订单](#add)
1. [全部订单](#allList)
1. [订单分配](#assign)
1. [订单信息](#info)
1. [订单编辑](#edit)
1. [我的订单-pc](#pc-myorders)


## **<a name="add"> 新增订单</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "action_process": "test",
        "action_type": "addOrder",
        "action_body": {
            "merchantId": "11064622752480048",          // 商户id
            "channelOrderNo": "xxxxxxxxx111",           // 渠道订单号
            "legalName": "杨庆菊",                       // 法人姓名
            "legalMobile": "杨庆菊手机号",                // 法人手机号
            "legalImg": "法人照片",                      // 法人照皮那
            "idcard": "123身份证",                       // 身份证
            "idcardFront": "在正面",                     // 身份证正面照
            "idcardBack": "反面",                        // 身份证反面照
            "bankNo": "2222",                           // 银行卡号
            "bank": "开户行",                            // 开户行
            "bankImg": "这是银行卡照片",                  // 银行卡照片
            "names": "                   ",            // 姓名
            "capital": "到底是多少"                      // 注册资金
            "domicile_id":""                           // 注册地id
            "domicileName":""                          // 注册地名称

            "businessScope_id": "1221812759600065",    // 经营范围id
            "businessType": "太难了",                   // 经营范围
            "businessScope": "太狠了",                  // 经营范围详情
        }
    }


```

#### 返回结果
```javascript
        {
            "status": 0,
            "msg": "success",
            "data": {
                "id": "13180527789003380",                  // id

                "price": 300000,
                "status": "1000",
                "channelOrderNo": "xxxxxxxxx111",
                "legalName": "杨庆菊",
                "legalMobile": "杨庆菊手机号",
                "legalImg": "法人照片",
                "idcard": "123身份证",
                "idcardFront": "在正面",
                "idcardBack": "反面",
                "bankNo": "2222",
                "bank": "开户行",
                "bankImg": "这是银行卡照片",
                "names": "山驴比1,山驴比2,山驴比3",
                "capital": "到底是多少",
                "domicile_id":""                           // 注册地id
                "domicileName":""                          // 注册地名称

                "businessScope_id": "12218127596000645",
                "businessType": "太难了",
                "businessScope": "太狠了",
            },
            "requestid": "7052de8f85684245b05067521a695e84"
        }
```



## **<a name="assign"> 订单分配</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action`_process": "test",
        "action_type": "orderAssign",
        "action_body": {
            "id": "13180532689003786",              // 订单id
            "deliverId": "13120681466000118",       // 交付商id
            "deliverName": "杨庆菊交付商222",         // 交付商名称
            "assignUcname": "杨庆菊",                // 分配人
            "deliverDivide": 3311                   // 交付商分成比例
        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": "",
        "requestid": "721e93dbdfb54115a76bf32a4900cd6e"
    }

```




## **<a name="allList"> 全部订单</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "allOrderList",
        "action_body": {
            "currentPage": "1",     
            "pageSize": "5",
            "merchantId": "",           // 商户id
            "orderId": "",              // 订单id
            "status": "",               // 订单状态 1000未付款, 1010待处理, 1020执照办理中, 1030已出执照, 1040刻章办理中, 1050已刻章, 
                                        //         1060银行开户中, 1070银行已开户, 1080税务报道中, 1090已税务报道, 1100已完成
                         
            "createdBegin": "",         // 创建时间开始
            "createdEnd": "",           // 创建时间结束
            "assignBegin": "",          // 分配时间开始
            "assignEnd": "",            // 分配时间结束

        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "count": 12,
            "rows": [
                {
                    "id": "13180527789003380",                          // 订单号\订单号
                    "merchant_id": "11064622752480048",                 // 商户id
                    "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
                    "price": 300000,                                    // 订单价格（分）
                    "legalName": "杨庆菊",                               // 法人姓名
                    "legalMobile": "杨庆菊手机号",                        // 法人手机号
                    "legalImg": "法人照片",                              // 法人照片
                    "idcard": "123身份证",                               // 身份证号码
                    "idcardFront": "在正面",                             // 身份证正面图
                    "idcardBack": "反面",                                // 身份证反面图
                    "bankNo": "2222",                                   // 银行卡号
                    "bank": "开户行",                                    // 开户行
                    "bankImg": "这是银行卡照片",                          // 银行卡照片
                    "names": "名称1,名称2,名称3",                         // 2～3个注册名称，逗号分割

                    "domicile_id":""                                    // 注册地id
                    "domicileName":""                                   // 注册地名称

                    "businessScope_id": "12218127596000645",            // 经营范围id
                    "businessType": "物流信息类",                         // 经营范围
                    "businessScope": "国内物流信息服务；装",                // 经营范围详情
                    "capital": "到底是多少",                              // 注册资本
                    "statusName": "未付款",                              // 订单状态名称
                    "status": "1000",                                   // 订单状态
                    "ostatusName": "待处理",                             // 业务进度状态名称
                    "ostatus": "1030",                                  // 业务进度状态
                    "assignTime": null,                                 // 分配时间
                    "assignUcname": "吴经理",                            // 分配人
                    "created_at": "2019-10-05 06:57:28",                // 创建时间

                    "deliverType": "",                                  // 交付类型
                    "deliverNo": "",                                    //
                    "deliverImg": "",                                   // 


                    "deliver": {                                        // 交付商
                        "statusName": "待处理"                           // 办理状态名称
                        "status": "1020",                               // 办理状态
                        "deliverName": "开封交付商",                      // 交付商名称
                        "deliverDivide": 3311,                          // 交付商分成比例
                    }
                },
                ...
            ]
        },
        "requestid": "ae2a9c2e2ff6497e8cc9fd2c7fac9fe8"
    }
```


## **<a name="info"> 订单信息</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "orderInfo",
        "action_body": {
            "id": "13180527789003380"
        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "id": "13180527789003380",                          // 订单号\订单号
            "merchant_id": "11064622752480048",                 // 商户id
            "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
            "price": 300000,                                    // 订单价格（分）
            "price_y": "3000",                                  // 订单价格（元）
            "legalName": "杨庆菊",                               // 法人姓名
            "legalMobile": "杨庆菊手机号",                        // 法人手机号
            "legalImg": "法人照片",                              // 法人照片
            "idcard": "123身份证",                               // 身份证号码
            "idcardFront": "在正面",                             // 身份证正面图
            "idcardBack": "反面",                                // 身份证反面图
            "bankNo": "2222",                                   // 银行卡号
            "bank": "开户行",                                    // 开户行
            "bankImg": "这是银行卡照片",                          // 银行卡照片
            "names": "山驴比1,山驴比2,山驴比3",                    // 2～3个注册名称，逗号分割

            "domicile_id":""                                    // 注册地id
            "domicileName":""                                   // 注册地名称

            "businessScope_id": "12218127596000645",            // 经营范围id
            "businessType": "太难了",                            // 经营范围
            "businessScope": "太狠了",                           // 经营范围详情
            "capital": "到底是多少",                              // 注册资本
            "statusName": "未付款",                              // 订单状态名称
            "status": "1000",                                   // 订单状态
            "assignTime": null,                                 // 分配时间
            "created_at": "2019-10-05 06:57:28",                // 创建时间
        },
        "requestid": "721e93dbdfb54115a76bf32a4900cd6e"
    }
```

## **<a name="edit"> 订单编辑</a>**
[返回到目录](#menu)
#### 接口说明  该接口只编辑商户id和订单价格，（商户id随时可编辑），（订单价格只有在 1000未付款状态时可编辑）
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "orderAssign",
        "action_body": {
            "id": "13180532689003786",
            "deliverId": "13120681466000118",
            "deliverName": "杨庆菊交付商222",
            "deliverDivide": 3311
        }
    }
```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "id": "13180527789003380",                          // 订单号\订单号
            "merchant_id": "11064622752480048",                 // 商户id
            "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
            "price": 300000,                                    // 订单价格（分）
            "price_y": "3000",                                  // 订单价格（元）
            "legalName": "杨庆菊",                               // 法人姓名
            "legalMobile": "杨庆菊手机号",                        // 法人手机号
            "legalImg": "法人照片",                              // 法人照片
            "idcard": "123身份证",                               // 身份证号码
            "idcardFront": "在正面",                             // 身份证正面图
            "idcardBack": "反面",                                // 身份证反面图
            "bankNo": "2222",                                   // 银行卡号
            "bank": "开户行",                                    // 开户行
            "bankImg": "这是银行卡照片",                          // 银行卡照片
            "names": "山驴比1,山驴比2,山驴比3",                    // 2～3个注册名称，逗号分割

            "domicile_id":""                                    // 注册地id
            "domicileName":""                                   // 注册地名称

            "businessScope_id": "12218127596000645",            // 经营范围id
            "businessType": "太难了",                            // 经营范围
            "businessScope": "太狠了",                           // 经营范围详情
            "capital": "到底是多少",                              // 注册资本
            "statusName": "未付款",                              // 订单状态名称
            "status": "1000",                                   // 订单状态
            "assignTime": null,                                 // 分配时间
            "created_at": "2019-10-05 06:57:28",                // 创建时间
        },
        "requestid": "721e93dbdfb54115a76bf32a4900cd6e"
    }
```



## **<a name="pc-myorders"> 我的订单-pc</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "myOrderPage",
        "action_body": {
            "currentPage": "1",     
            "pageSize": "5",
            "userId": "",               // 用户id
            "createdBegin": "",         // 创建时间开始
            "createdEnd": "",           // 创建时间结束
        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "count": 12,
            "rows": [
                {
                    "id": "13180527789003380",                          // 订单号\订单号
                    "merchant_id": "11064622752480048",                 // 商户id
                    "channelOrderNo": "xxxxxxxxx111",                   // 渠道订单号
                    "price": 300000,                                    // 订单价格（分）
                    "legalName": "杨庆菊",                               // 法人姓名
                    "legalMobile": "杨庆菊手机号",                        // 法人手机号
                    "legalImg": "法人照片",                              // 法人照片
                    "idcard": "123身份证",                               // 身份证号码
                    "idcardFront": "在正面",                             // 身份证正面图
                    "idcardBack": "反面",                                // 身份证反面图
                    "bankNo": "2222",                                   // 银行卡号
                    "bank": "开户行",                                    // 开户行
                    "bankImg": "这是银行卡照片",                          // 银行卡照片
                    "names": "山驴比1,山驴比2,山驴比3",                    // 2～3个注册名称，逗号分割
                    "domicile_id":""                                    // 注册地id
                    "domicileName":""                                   // 注册地名称

                    "domicile_id":""                                    // 注册地id
                    "domicileName":""                                   // 注册地名称

                    "businessScope_id": "12218127596000645",            // 经营范围id
                    "businessType": "太难了",                            // 经营范围
                    "businessScope": "太狠了",                           // 经营范围详情

                    "capital": "到底是多少",                              // 注册资本
                    "statusName": "未付款",                              // 订单状态名称
                    "status": "1000",                                   // 订单状态
                    "assignTime": null,                                 // 分配时间
                    "created_at": "2019-10-05 06:57:28",                // 创建时间
                },
                ...domicile_id
            ]
        },
        "requestid": "ae2a9c2e2ff6497e8cc9fd2c7fac9fe8"
    }
```