const system = require("../system");

class OrderBusinessStatus {
    constructor() {
        this.busiStatus = {
            "1000": {
                "status": "1000",
                "name": "未付款",
                "next": "1020",
                "ostatus": "1000",
                "dstatus": "",
            },
            "1010": {
                "status": "1010",
                "name": "订单关闭",
                "next": "",
                "ostatus": "1010",
                "dstatus": "",
            },
            "1020": {
                "status": "1020",
                "name": "待分配",
                "next": "1030",
                "ostatus": "1030",
                "dstatus": "1030",
            },
            "1030": {
                "status": "1030",
                "name": "待处理",
                "next": "1050",
                "ostatus": "1030",
                "dstatus": "1030",
            },
            "1040": {
                "status": "1040",
                "name": "交付商关闭",
                "next": "1020",
                "ostatus": "1030",
                "dstatus": "1030",
            },
            "1050": {
                "status": "1050",
                "name": "执照办理中",
                "next": "1060",
                "ostatus": "1050",
                "dstatus": "1050",
            },
            "1060": {
                "status": "1060",
                "name": "已出执照",
                "next": "1070",
                "ostatus": "1060",
                "dstatus": "1060",
            },
            "1070": {
                "status": "1070",
                "name": "刻章办理中",
                "next": "1080",
                "ostatus": "1070",
                "dstatus": "1070",
            },
            "1080": {
                "status": "1080",
                "name": "已刻章",
                "next": "1090",
                "ostatus": "1080",
                "dstatus": "1080",
            },
            "1090": {
                "status": "1090",
                "name": "银行开户中",
                "next": "1100",
                "ostatus": "1090",
                "dstatus": "1090",
            },
            "1100": {
                "status": "1100",
                "name": "银行卡已开户",
                "next": "1110",
                "ostatus": "1100",
                "dstatus": "1100",
            },
            "1110": {
                "status": "1110",
                "name": "税务报道中",
                "next": "1120",
                "ostatus": "1110",
                "dstatus": "1110",
            },
            "1120": {
                "status": "1120",
                "name": "已税务报道",
                "next": "1130",
                "ostatus": "1120",
                "dstatus": "1120",
            },
            "1130": {
                "status": "1130",
                "name": "待审核",
                "next": "1140",
                "ostatus": "1120",
                "dstatus": "1130",
            },
            "1140": {
                "status": "1140",
                "name": "审核失败",
                "next": "1150",
                "ostatus": "1120",
                "dstatus": "1140",
            },
            "1150": {
                "status": "1150",
                "name": "审核通过",
                "next": "1160",
                "ostatus": "1120",
                "dstatus": "1150",
            },
            "1160": {
                "status": "1160",
                "name": "已邮寄",
                "next": "1170",
                "ostatus": "1120",
                "dstatus": "1160",
            },
            "1170": {
                "status": "1170",
                "name": "已完成",
                "ostatus": "1170",
                "dstatus": "",
            }
        };
    }

    async findOrderBusinessStatus(status) {
        return this.busiStatus[status];
    }

    async findOrderNextBusinessStatus(status) {
        var curStatus = await this.findOrderBusinessStatus(status);
        if(!curStatus || !curStatus.next) {
            return;
        }

        return await this.findOrderBusinessStatus(curStatus.next);
    }
}

module.exports = OrderBusinessStatus;