const system = require("../../system");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
const settings = require("../../../config/settings");

class MicrosveClient {
    constructor() {
        this.logCtl = system.getObject("web.common.oplogCtl");
        this.restClient = system.getObject("util.restClient");
        this.micro = system.microsetting();
    }

    async call(sveName, apiName, params) {
        var errorMsg;
        var reqUrl = this.micro[sveName];
        if(!reqUrl) {
            return system.getResult(null,  "未找到【" + sveName + "】服务，请检查settings文件是否存在");
        }
        if(!apiName) {
            return system.getResult(null,  "apiName不能为空");
        }
        try {
            var params = {
                "action_process": "xgg-sve-order",
                "action_type": apiName,
                "action_body": params || {},
            }
            var rs = await this.restClient.execPost(params, reqUrl);
            if (rs && rs.stdout) {
                return JSON.parse(rs.stdout);
            }
            return system.getResult(null, rs);
        } catch (error) {
            console.log(error)
            this.logCtl.error({
                optitle: "微服务请求失败",
                op: "sveName = " + sveName + "; apiName = " + apiName,
                content: "params = " + JSON.stringify(params),
                clientIp: ""
            });
            return system.getResult(null, error.message);
        }
    }
}

module.exports = MicrosveClient;
