/**
* 订单产品表
*/
'use strict'

module.exports = function (db, DataTypes) {
	return db.define('oproduct', {
		name: {type: DataTypes.STRING, field: 'name', allowNull: true, comment:'产品名称' },
		desc: { type: DataTypes.STRING(200), field: 'desc', allowNull: false, defaultValue:"", comment:'产品描述'},
		pid: { type: DataTypes.BIGINT, field: 'pid', allowNull: true, comment:'父ID'},
    is_choose: { type: DataTypes.BOOLEAN, field: 'is_choose', allowNull: false, defaultValue:false, comment:'是否选择'},
    sort: {type: DataTypes.INTEGER, field: 'sort', allowNull: false, defaultValue:1000, comment:'排序' },
    created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
    updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
    deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true },
	},
	{
		timestamps: false,
		underscore: true,
    paranoid: true,
    version: true,
		tableName: 'o_product',
		comment: '订单产品表',
	});
}

