'use strict'
/**
 * 订单表
 */
module.exports = function (db, DataTypes) {
	return db.define('oorderstatus', {
		merchant_id: {type: DataTypes.STRING, field: 'merchant_id', allowNull: true, defaultValue:'',comment:'商户id, 为了兼容司机宝' },
		// order_id: {type: DataTypes.STRING, field: 'order_id', allowNull: true, comment:'订单ID' },
		busi_type: {type: DataTypes.STRING, field: 'busi_type', allowNull: true,defaultValue:'', comment:'业务类型 1个体户 2...暂不知道' },
    busi_id: { type: DataTypes.STRING, field: 'busi_id', allowNull: false,defaultValue:'', comment:'业务id'},
		product_id: {type: DataTypes.BIGINT, field: 'product_id', allowNull: true,defaultValue:0, comment:'产品id'},
		price: { type: DataTypes.BIGINT, field: 'price', allowNull: true, defaultValue:0,comment:'订单价格'},
    status: {type: DataTypes.INTEGER, field: 'status', allowNull: true,  defaultValue:'0',comment:'订单状态 业务进度' },
    assign_time: {type: DataTypes.DATE, field: 'assign_time', allowNull: true, defaultValue:null, comment:'分配时间' },
    assign_user_id: {type: DataTypes.BIGINT, field: 'assign_user_id', allowNull: true, defaultValue:'0', comment:'分配人id' },
    deliver_id: {type: DataTypes.STRING, field: 'deliver_id', allowNull: true, defaultValue:'', comment:'交付商id common微服务下' },
    desc: {type: DataTypes.STRING, field: 'desc', allowNull: true, defaultValue:'', comment:'订单信息' },
    bd_id: {type: DataTypes.STRING, field: 'bd_id', allowNull: true, defaultValue:'', comment:'业务员id' },
    bd_path: {type: DataTypes.BIGINT, field: 'bd_path', allowNull: true, defaultValue:'', comment:'业务员权限路径' },
    service_items: {type: DataTypes.STRING, field: 'service_items', allowNull: true, defaultValue:'', comment:'服务项json' },
    service_remark: {type: DataTypes.STRING, field: 'service_remark', allowNull: true, defaultValue:'', comment:'服务信息备注' },
    source_id: {type: DataTypes.BIGINT, field: 'source_id', allowNull: true, defaultValue:0, comment:'来源id' },
    source_no: {type: DataTypes.STRING, field: 'source_no', allowNull: true, defaultValue:'', comment:'来源订单号' },
    contact_mobile: {type: DataTypes.STRING, field: 'contact_mobile', allowNull: true, defaultValue:'', comment:'联系电话' },
    created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
    updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
    deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true }
	},
	{
		paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    tableName: 'o_order',
  });
}

