'use strict'
/**
 * 订单流程表
 */
module.exports = function (db, DataTypes) {
	return db.define('oorderprocess', {
    product_id: {type: DataTypes.BIGINT, field: 'product_id', allowNull: true, comment:'产品ID' },
    order_id: {type: DataTypes.BIGINT, field: 'order_id', allowNull: true, comment:'订单号' },
		name: { type: DataTypes.STRING, field: 'name', allowNull: false, defaultValue:"", comment:'产品名称'},
		status: {type: DataTypes.STRING, field: 'status', allowNull: true, comment:'状态' },
		func: { type: DataTypes.STRING, field: 'func', allowNull: false, comment:'状态执行方法名称'},
		next_status: {type: DataTypes.STRING, field: 'next_status', allowNull: true, comment:'下一个状态'},
		name1: { type: DataTypes.STRING, field: 'name1', allowNull: true, comment:'状态1'},
		name2: {type: DataTypes.STRING, field: 'name2', allowNull: true, comment:'状态2' },
		name3: { type: DataTypes.STRING, field: 'name3', allowNull: true, comment:'状态3'},
		name4: {type: DataTypes.STRING, field: 'name4', allowNull: true, comment:'状态4' },
		sort: {type: DataTypes.BIGINT, field: 'sort', allowNull: false, defaultValue:1000, comment:'排序' },
    created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
    updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
    deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true },
	},
	{
		timestamps: false,
		underscore: true,
    paranoid: true,
    version: true,
		tableName: 'o_order_process',
		comment: '产品状态表',
	});
}