'use strict'
/**
 * 订单信息明细表
 */
module.exports = function (db, DataTypes) {
	return db.define('oorderinforeg', {
    legal_name: {type: DataTypes.STRING, field: 'legal_name', allowNull: true, defaultValue:'',comment:'法人姓名' },
    id_card: {type: DataTypes.STRING, field: 'id_card', allowNull: true, comment:'法人身份证' },
    legal_mobile: { type: DataTypes.STRING, field: 'legal_mobile', allowNull: true, defaultValue:'', comment:'法人电话'},
		names: {type: DataTypes.STRING, field: 'names', allowNull: true,defaultValue:'', comment:'个体户名称' },
    capital: { type: DataTypes.STRING, field: 'capital', allowNull: false,defaultValue:'', comment:'注册资本'},
		domicile_id: {type: DataTypes.STRING, field: 'domicile_id', allowNull: true,defaultValue:'', comment:'注册地id'},
		domicile_name: { type: DataTypes.STRING, field: 'domicile_name', allowNull: true, defaultValue:'',comment:'注册地名称'},
    business_scope_id: {type: DataTypes.STRING, field: 'business_scope_id', allowNull: true,  defaultValue:'',comment:'经营范围id' },
    business_type: { type: DataTypes.STRING, field: 'business_type', allowNull: true, defaultValue:'', comment:'经营范围'},
    business_scope: {type: DataTypes.STRING, field: 'business_scope', allowNull: true, defaultValue:'', comment:'经营范围详情' },
    idcard_front: {type: DataTypes.STRING, field: 'idcard_front', allowNull: true, defaultValue:'', comment:'身份证正面照片' },
    idcard_back: {type: DataTypes.STRING, field: 'idcard_back', allowNull: true, defaultValue:'', comment:'身份证反面照片' },
    other_file: {type: DataTypes.STRING, field: 'other_file', allowNull: true, defaultValue:'', comment:'其他文件' },
    notes: {type: DataTypes.STRING, field: 'notes', allowNull: true, defaultValue:'', comment:'备注' },
    guest_mail_addr: {type: DataTypes.STRING, field: 'guest_mail_addr', allowNull: true, defaultValue:'', comment:'邮寄客户地址' },
    guest_mail_to: {type: DataTypes.STRING, field: 'guest_mail_to', allowNull: true, defaultValue:'', comment:'客户收件人' },
    guest_mail_mobile: {type: DataTypes.STRING, field: 'guest_mail_mobile', allowNull: true, defaultValue:'', comment:'客户收件人电话' },
    guest_mail_no: {type: DataTypes.STRING, field: 'guest_mail_no', allowNull: true, defaultValue:'', comment:'客户快递单号' },
    guest_mail_img: {type: DataTypes.STRING, field: 'guest_mail_img', allowNull: true, defaultValue:'', comment:'交付商交付快递单号图片' },
    guest_accpet_file: {type: DataTypes.STRING, field: 'guest_accpet_file', allowNull: true, defaultValue:'', comment:'客户验收文件' },
    created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
    updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
    deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true }
	},
	{
		timestamps: false,
		underscore: true,
    paranoid: true,
    version: true,
		tableName: 'o_order_info_reg',
		comment: '订单信息明细表',
	});
}

