'use strict'
/**
 * 订单交付表
 */
module.exports = function (db, DataTypes) {
	return db.define('oorderdeliver', {
		order_id: {type: DataTypes.STRING, field: 'order_id', allowNull: false,comment:'订单ID' },
    deliver_id: {type: DataTypes.STRING, field: 'deliver_id', allowNull: false, comment:'交付商id' },
    deliver_name: { type: DataTypes.STRING, field: 'deliver_name', allowNull: false, comment:'交付商名称'},
		deliver_divide: {type: DataTypes.STRING, field: 'deliver_divide', allowNull: false,comment:'订单分成' },
    audit_result: { type: DataTypes.STRING, field: 'audit_result', allowNull: true,defaultValue:'', comment:'审核结果'},
    audit_remark: {type: DataTypes.STRING, field: 'audit_remark', allowNull: true,defaultValue:'', comment:'交付审核备注'},
    deliver_mail_addr: { type: DataTypes.STRING, field: 'deliver_mail_addr', allowNull: true, defaultValue:'',comment:'交付地址'},
    deliver_mail_to: {type: DataTypes.STRING, field: 'deliver_mail_to', allowNull: true,  defaultValue:'',comment:'收件人' },
		deliver_mail_mobile: { type: DataTypes.STRING, field: 'deliver_mail_mobile', allowNull: true, defaultValue:'', comment:'联系电话'},
    deliver_content: {type: DataTypes.STRING, field: 'deliver_content', allowNull: true, defaultValue:'', comment:'交付内容' },
    deliver_mail_no: {type: DataTypes.STRING, field: 'deliver_mail_no', allowNull: true, defaultValue:'', comment:'交付商交付快递单号' },
    deliver_mail_img: {type: DataTypes.STRING, field: 'deliver_mail_img', allowNull: true, defaultValue:'', comment:'交付商交付快递单号图片' },
    completed_at: { type: DataTypes.DATE, field: 'completed_at', allowNull: true, comment:'订单的完成时间'  },
    operator_id: { type: DataTypes.STRING, field: 'operator_id', allowNull: true, comment:'业务员id'  },

    created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
    updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
    deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true }
	},
	{
		timestamps: false,
		underscore: true,
    paranoid: true,
    version: true,
		tableName: 'o_order_deliver',
		comment: '订单交付表',
	});
}

