'use strict'
/**
 * 订单信息明细表
 */
module.exports = function (db, DataTypes) {
	return db.define('obusinessmen', {
    order_id: {type: DataTypes.STRING, field: 'order_id', allowNull: true, defaultValue:'',comment:'订单id' },
    merchant_id: {type: DataTypes.STRING, field: 'merchant_id', allowNull: true, comment:'商户id 为了司机宝' },
    channel_order_no: { type: DataTypes.STRING, field: 'channel_order_no', allowNull: true, defaultValue:'', comment:'渠道订单号 为了司机宝'},
    legal_name: { type: DataTypes.STRING, field: 'legal_name', allowNull: false,defaultValue:'', comment:'法人姓名'},
		legal_mobile: {type: DataTypes.STRING, field: 'legal_mobile', allowNull: true,defaultValue:'', comment:'法人电话'},
		legal_idcard: { type: DataTypes.STRING, field: 'legal_idcard', allowNull: true, defaultValue:'',comment:'法人身份证号'},
    name: {type: DataTypes.STRING, field: 'name', allowNull: true,  defaultValue:'',comment:'个体工商户名称' },
    credit_code: { type: DataTypes.STRING, field: 'credit_code', allowNull: true, defaultValue:'', comment:'统一社会信用代码'},
    business_place: {type: DataTypes.STRING, field: 'business_place', allowNull: true, defaultValue:'', comment:'经营场所' },
    business_scope: {type: DataTypes.STRING, field: 'business_scope', allowNull: true, defaultValue:'', comment:'经营范围' },
    reg_date: {type: DataTypes.DATE, field: 'reg_date', allowNull: true, defaultValue:'', comment:'注册日期' },
    business_img: {type: DataTypes.STRING, field: 'business_img', allowNull: true, defaultValue:'', comment:'执照照片' },
    business_gov_file: {type: DataTypes.STRING, field: 'business_gov_file', allowNull: true, defaultValue:'', comment:'工商官方文件' },
    gongzhang: {type: DataTypes.STRING, field: 'gongzhang', allowNull: true, defaultValue:'', comment:'公章' },
    caiwuzhang: {type: DataTypes.STRING, field: 'caiwuzhang', allowNull: true, defaultValue:'', comment:'财务章' },
    fapiaozhang: {type: DataTypes.STRING, field: 'fapiaozhang', allowNull: true, defaultValue:'', comment:'发票章' },
    hetongzhang: {type: DataTypes.STRING, field: 'hetongzhang', allowNull: true, defaultValue:'', comment:'合同章' },
    farenzhang: {type: DataTypes.STRING, field: 'farenzhang', allowNull: true, defaultValue:'', comment:'法人章' },
    zhang_gov_file: {type: DataTypes.STRING, field: 'zhang_gov_file', allowNull: true, defaultValue:'', comment:'刻章官方文件' },
    is_bank: {type: DataTypes.BOOLEAN, field: 'is_bank', allowNull: true, defaultValue:false, comment:'是否开户' },
    bank_name: {type: DataTypes.STRING, field: 'bank_name', allowNull: true, defaultValue:'', comment:'账户名称' },
    bank_no: {type: DataTypes.STRING, field: 'bank_no', allowNull: true, defaultValue:'', comment:'账户号' },
    bank: {type: DataTypes.STRING, field: 'bank', allowNull: true, defaultValue:'', comment:'开户行' },
    bank_img: {type: DataTypes.STRING, field: 'bank_img', allowNull: true, defaultValue:'', comment:'账户信息' },
    bank_gov_file: {type: DataTypes.STRING, field: 'bank_gov_file', allowNull: true, defaultValue:'', comment:'银行开户官方文件' },
    ca_img: {type: DataTypes.STRING, field: 'ca_img', allowNull: true, defaultValue:'', comment:'CA照片' },
    tax_reg_day: {type: DataTypes.DATE, field: 'tax_reg_day', allowNull: true,  comment:'税务登记日' },
    tax_org: {type: DataTypes.STRING, field: 'tax_org', allowNull: true, defaultValue:'', comment:'税务机构名称' },
    tax_gov_file: {type: DataTypes.STRING, field: 'tax_gov_file', allowNull: true, defaultValue:'', comment:'税务报道官方文件' },
    notes: {type: DataTypes.STRING, field: 'notes', allowNull: true, defaultValue:'', comment:'备注' },
    common_tax_ladder: {type: DataTypes.STRING, field: 'common_tax_ladder', allowNull: true, defaultValue:'', comment:'普票个税阶梯' },
    common_other_ladder: {type: DataTypes.STRING, field: 'common_other_ladder', allowNull: true, defaultValue:'', comment:'普票增值税、附加税阶梯' },
    special_tax_ladder: {type: DataTypes.STRING, field: 'special_tax_ladder', allowNull: true, defaultValue:'', comment:'专票个税阶梯' },
    special_other_ladder: {type: DataTypes.STRING, field: 'special_other_ladder', allowNull: true, defaultValue:'', comment:'专票增值税、附加税阶梯' },
    service_begin_time: {type: DataTypes.DATE, field: 'service_begin_time', allowNull: true, defaultValue:null, comment:'服务开始时间' },
    service_end_time: {type: DataTypes.DATE, field: 'service_end_time', allowNull: true, defaultValue:null, comment:'服务结束时间' },
    cost_rate: {type: DataTypes.INTEGER, field: 'cost_rate', allowNull: true, defaultValue:0, comment:'核定成本费用率' },
    tax_rate: {type: DataTypes.INTEGER, field: 'tax_rate', allowNull: true, defaultValue:0, comment:'含税价百分比' },
    add_value_up_type: {type: DataTypes.STRING, field: 'add_value_up_type', allowNull: true, defaultValue:'1', comment:'增值税累计类型 1按月 2按季度' },
    tax_up_type: {type: DataTypes.STRING, field: 'tax_up_type', allowNull: true, defaultValue:'1', comment:'个税累计类型 1按月累计 2按年累计' },
    service_rate: {type: DataTypes.INTEGER, field: 'service_rate', allowNull: true, defaultValue:0, comment:'服务费比例' },
    sign_notes: {type: DataTypes.STRING, field: 'sign_notes', allowNull: true, defaultValue:'', comment:'签约备注' },
    sign_time: {type: DataTypes.DATE, field: 'sign_time', allowNull: true, defaultValue:null, comment:'签约时间' },
    is_create_account: {type: DataTypes.BOOLEAN, field: 'is_create_account', allowNull: true, defaultValue:false, comment:'是否建帐' },
    bd_id: {type: DataTypes.INTEGER, field: 'bd_id', allowNull: true, defaultValue:'', comment:'业务员id' },
    bd_path: {type: DataTypes.STRING, field: 'bd_path', allowNull: true, defaultValue:'', comment:'业务员权限路径' },
    created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
    updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
    deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true }
	},
	{
    timestamps: false,
		underscore: true,
    paranoid: true,
    version: true,
		tableName: 'o_businessmen',
		comment: '个体户表',
	});
}

