const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("iborderdk", {
    merchant_id: DataTypes.STRING(32),
    businessmen_id: DataTypes.STRING(32),
    orderpay_id: DataTypes.STRING(32),
    price: DataTypes.BIGINT,
    status: DataTypes.STRING,
    notes: DataTypes.STRING,
    orderDeliverId: DataTypes.STRING(32),

    legalName: DataTypes.STRING(20),
    legalMobile: DataTypes.STRING(20),
    names: DataTypes.STRING(300),
    creditCode: DataTypes.STRING(100),
    isBank: {
      type: DataTypes.BOOLEAN,
      defaultValue: false
    },
    businessScope: DataTypes.STRING(500),
    isInfoComplete: {
      type: DataTypes.BOOLEAN,
      defaultValue: false
    },
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'ib_orderdk',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}