const system = require("../../../system");
const Dao = require("../../dao.base");

class OproductprocessDao extends Dao {
  constructor() {
    super(Dao.getModelName(OproductprocessDao));
  }

  /**
   * 根据 productId 和 status 查询 商品
   * @param {*} productId
   * @param {*} status
   */
  async findByProductIdAndStatus(productId, status) {
    try {
      let _productProcess = await this.model.findOne({
        where: {
          productId: productId,
          status: status
        }
      });
      return _productProcess || {};
    } catch (error) {
      console.log(`系统错误 错误信息 ${error}`);
      return {};
    }
  }

  async findMapByProductProductIds(productPid, productIds) {
    let result = {};
    let sql = [];
    sql.push("SELECT");
    sql.push("*");
    sql.push("FROM o_product_process");
    sql.push("WHERE product_pid = :productPid");

    if (productIds && productIds.length > 0) {
      sql.push("AND product_id IN (:productIds)");
    }
    sql.push("ORDER BY sort ASC");

    let list = await this.customQuery(sql.join(" "), {productPid: productPid, productIds: productIds});
    if (!list || list.length == 0) {
      return result;
    }

    for (let item of list) {
      let productId = item.product_id;
      let items = result[productId];
      if (!items) {
        items = [];
      }
      items.push(item);
      result[productId] = items;
    }
    return result;
  }

}

module.exports = OproductprocessDao;