const system = require("../../../system");
const Dao = require("../../dao.base");
class OprocessDao extends Dao {
  constructor() {
    super(Dao.getModelName(OprocessDao));
  }

  async getAll(attrs) {
    attrs = attrs || "*";
    let sql = "SELECT " + attrs + " FROM `o_process` ORDER BY `status` ASC";
    return await this.customQuery(sql);
  }

  async mapAll(attrs) {
    let result = {};
    let list = await this.getAll(attrs);
    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      result[item.id] = item;
    }
    return result;
  }

  async findMapByIds(ids, attrs) {
    let result = {};
    if (!ids || ids.length == 0) {
      return result;
    }
    attrs = attrs || "*";
    let sql = "SELECT " + attrs + " FROM `o_process` WHERE id IN (:ids)";

    let list = await this.customQuery(sql, {
      ids: ids
    });

    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.id] = item;
    }
    return result;
  }
}
module.exports = OprocessDao;