const system = require("../../../system");
const Dao = require("../../dao.base");

class OorderprocessDao extends Dao {
  constructor() {
    super(Dao.getModelName(OorderprocessDao));
  }

  async delByOrderId(order_id) {
    if (!order_id) {
      return;
    }

    let sql = "DELETE FROM o_order_process WHERE order_id = :order_id";
    await this.customUpdate(sql, {order_id: order_id});
  }

  async findByOrderIdAndStatus(orderId, status) {
    if (!orderId || !status) {
      return null;
    }
    let sql = [];
    sql.push("SELECT");
    sql.push("*");
    sql.push("FROM `o_order_process`");
    sql.push("WHERE order_id = :orderId");
    sql.push("AND `status` = :status");

    let list = await this.customQuery(sql.join(" "), {orderId: orderId, status: status});
    if (!list || list.length == 0) {
      return null;
    }
    return list[0];
  }

  async listByOrderIdsAndStatus(orderIds, statuses) {
    var result = {};
    if (!orderIds || orderIds.length == 0 || !statuses || statuses.length == 0) {
      return result;
    }
    let sql = [];
    sql.push("SELECT");
    sql.push("*");
    sql.push("FROM `o_order_process`");
    sql.push("WHERE order_id IN (:orderIds)");
    sql.push("AND `status` IN (:statuses)");

    return await this.customQuery(sql.join(" "), {orderIds: orderIds, statuses: statuses});
  }

  async mapByOrderIdsAndStatus(orderIds, statuses) {
    var result = {};
    let list = await this.listByOrderIdsAndStatus(orderIds, statuses);
    if (!list || list.length == 0) {
      return result;
    }

    for (let item of list) {
      result[item.order_id + "_" + item.status] = item;
    }
    return result;
  }
}

module.exports = OorderprocessDao;
