const system = require("../../../system");
const Dao = require("../../dao.base");
class OorderdeliverDao extends Dao {
  constructor() {
    super(Dao.getModelName(OorderdeliverDao));
    this.ORDER_HANDING = ['1030', '1040', '1050', '1060', '1070', '1080', '1090', '1100', '1110', '1120', '1130'];
  }

  /**
   * 条件查询所有符合条件的产品
   * @param {*} params 
   */
  async orderIdsByDeliverId(deliver_id) {
    if (!deliver_id) {
      return [];
    }
    let sql = `SELECT order_id FROM o_order_deliver WHERE deliver_id = :deliver_id`;
    let list = await this.customQuery(sql, { deliver_id: deliver_id });
    let rs = [];
    if (!list) {
      return rs;
    }
    for (let item of list) {
      rs.push(item.order_id);
    }
    return rs;
  }
  /**
   * 条件查询所有符合条件的产品
   * @param {*} params
   */
  async orderIdsByOperatorId(operator_id) {
    if (!operator_id) {
      return [];
    }
    let sql = `SELECT order_id FROM o_order_deliver WHERE operator_id = :operator_id`;
    let list = await this.customQuery(sql, { operator_id: operator_id });
    let rs = [];
    if (!list) {
      return rs;
    }
    for (let item of list) {
      rs.push(item.order_id);
    }
    return rs;
  }

  async listByIds(ids) {
    if (!ids || ids.length == 0) {
      return [];
    }
    let sql = `SELECT * FROM o_order_deliver WHERE id in (:deliverIdList)`;
    return await this.customQuery(sql, { deliverIdList: ids });
  }

  async mapByIds(params) {
    let list = await this.listByIds(params);
    var result = {};
    for (let item of list) {
      result[item.id] = item;
    }
    return result;
  }

  /**
 * 订单管理列表 分页总数查询
 * @param {*} params 
 */
  async ordersdeliverCount(params) {
    let sql = [];
    sql.push(`SELECT COUNT(1) AS orderCount FROM o_order_deliver b INNER JOIN o_order a on
    b.order_id=a.id WHERE  b.deliver_id = '${params.deliver_id}' `);
    this.setOrderCount(sql, params);
    return await this.customQuery(sql.join(" "), params);
  }

  /**
   * 订单列表 分页
   * @param {*} params 
   */
  async findOrders(params) {
    let sql = [];
    sql.push(`SELECT a.id,b.created_at,a.service_items,a.status,b.deliver_divide,b.operator_id,b.completed_at,
    a.desc, a.service_remark,
    b.deliver_name FROM o_order_deliver b INNER JOIN o_order a on
    b.order_id=a.id WHERE  b.deliver_id = '${params.deliver_id}' `);
    this.setOrderCount(sql, params);
    sql.push(` order by id desc `);
    sql.push(`limit ${params.startRow} ,${params.pageSize}`);
    return await this.customQuery(sql.join(" "), params);
  }

  /**
   * 订单管理列表查询条件参数设置
   * @param {*} params 
   */
  async setOrderCount(sql, params) {
    if (params.id) {
      sql.push(`AND b.id = :id `);
    }
    if (params.order_id) {
      sql.push(`AND b.order_id = :order_id `);
    }
    if (params.operator_id) {
      sql.push(`AND b.operator_id = :operator_id `);
    }
    if (params.status) {
      sql.push(`AND a.status = :status `);
    }
    if (params.createdBegin) {
      sql.push(`AND a.created_at >= :createdBegin `);
    }
    if (params.createdEnd) {
      sql.push(`AND a.created_at <= :createdEnd`);
    }
  }

  /**
   * 交付商统计交付商服务费用
   */
  async deliverList(begin, end) {
    var sql = [];
    sql.push("SELECT");
    sql.push("SUM(deliver_divide) AS serivce_price, deliver_name,deliver_id");
    sql.push("FROM `o_order_deliver`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }
    sql.push(" GROUP BY deliver_id");
    return await this.customQuery(sql.join(" "), params);
  }

  /**
   * 统计完成的订单
   * @param {*} deliverSet 
   * @param {*} begin 
   * @param {*} end 
   */
  async orderCompletesCount(deliverSet, begin, end) {
    var sql = [];
    sql.push("SELECT");
    sql.push("COUNT(1) as order_complete_count ,b.deliver_id");
    sql.push("FROM `o_order_deliver` b inner join o_order a on b.id = a.deliver_id");
    sql.push("WHERE 1 = 1 and a.status = '1080' ");

    var params = {
      begin: begin,
      end: end,
      deliverSet: deliverSet
    };
    if (begin) {
      sql.push("AND a.created_at >= :begin");
    }
    if (end) {
      sql.push("AND a.created_at <= :end");
    }
    if (deliverSet) {
      sql.push(`AND b.deliver_id in (:deliverSet)`);
    }

    sql.push(" GROUP BY b.deliver_id");
    let res = await this.customQuery(sql.join(" "), params);
    let result = {};
    for (let item of res) {
      result[item.deliver_id] = item.order_complete_count;
    }
    return result;
  }

  /**
   * 订单办理中
   * @param {*} params 
   */
  async orderHandingCount(deliverSet, begin, end) {
    var sql = [];
    sql.push("SELECT");
    sql.push("COUNT(1) as order_handing_count ,b.deliver_id");
    sql.push("FROM `o_order_deliver` b inner join o_order a on b.id = a.deliver_id");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND a.created_at >= :begin");
    }
    if (end) {
      sql.push("AND a.created_at <= :end");
    }

    sql.push(`AND a.status in (${this.ORDER_HANDING}) `);

    sql.push(" GROUP BY b.deliver_id");
    let res = await this.customQuery(sql.join(" "), params);
    let result = {};
    for (let item of res) {
      result[item.deliver_id] = item.order_handing_count;
    }
    return result;
  }

  /**
   * 交付上数据概览
   * @param {*} begin 
   * @param {*} end 
   */
  async statDayByTime(begin, end,deliver_id) {
    var result = {};
    var sql = [];
    sql.push("SELECT");
    sql.push("DATE_FORMAT(a.created_at, '%Y-%m-%d') AS `day`, SUM(b.deliver_divide) AS orderPrice, COUNT(1) AS orderCount");
    sql.push("from o_order a inner join o_order_deliver b on a.deliver_id = b.id where 1=1 and b.deliver_id = :deliver_id");
    var params = {
      begin: begin,
      end: end,
      deliver_id:deliver_id
    };
    if (begin) {
      sql.push("AND a.created_at >= :begin");
    }
    if (end) {
      sql.push("AND a.created_at <= :end");
    }
    sql.push("GROUP BY `day` ORDER BY `day` ASC");
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      result[item.day] = item;
    }
    return result;
  }

    /**
   * 交付商数据概览
   * @param {*} begin 
   * @param {*} end 
   */
  async statOrderByTime(begin, end,deliver_id) {
    var result = {};
    var sql = [];
    sql.push("SELECT");
    sql.push("DATE_FORMAT(a.created_at, '%Y-%m') AS `month`, SUM(b.deliver_divide) AS orderPrice, COUNT(1) AS orderCount");
    sql.push("FROM `o_order` a inner join o_order_deliver b on a.deliver_id = b.id");
    sql.push(`WHERE 1 = 1  and b.deliver_id = '${deliver_id}'`);

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND a.created_at >= :begin");
    }
    if (end) {
      sql.push("AND a.created_at <= :end");
    }

    sql.push("GROUP BY `month` ORDER BY `month` ASC");
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return result;
    }

    for (var idx = 0; idx < list.length; idx++) {
      var item = list[idx];
      result[item.month] = item;

      if (idx == 0) {
        result.begin = item.month;
      }

      if (idx == list.length - 1) {
        result.end = item.month;
      }
    }

    return result;
  }

/*********************************************以下是交付商首页**************************************************** */

  /**
   * 完成订单
   * @param {*} begin 
   * @param {*} end 
   * @param {*} deliver_id 
   */
  async orderComplete(begin, end,deliver_id){
    var sql = [];
    sql.push("SELECT count(1) as count from o_order a inner join o_order_deliver b on a.deliver_id = b.id");
    sql.push(`WHERE 1 = 1  and b.deliver_id = '${deliver_id}' and a.status="1180"`);

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND a.created_at >= :begin");
    }
    if (end) {
      sql.push("AND a.created_at <= :end");
    }

    return await this.customQuery(sql.join(" "), params);
  }

  /**
   * 订单办理中
   * @param {*} begin 
   * @param {*} end 
   * @param {*} deliver_id 
   */
  async orderHanding(begin, end,deliver_id){
    var sql = [];
    sql.push("SELECT count(1) as count from o_order a inner join o_order_deliver b on a.deliver_id = b.id");
    sql.push(`WHERE 1 = 1  and b.deliver_id = '${deliver_id}'`);

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND a.created_at >= :begin");
    }
    if (end) {
      sql.push("AND a.created_at <= :end");
    }
    sql.push(`AND a.status in (${this.ORDER_HANDING}) `);
    return await this.customQuery(sql.join(" "), params);
  }

}
module.exports = OorderdeliverDao;