const system = require("../../../system");
const Dao = require("../../dao.base");
class OorderDao extends Dao {
  constructor() {
    super(Dao.getModelName(OorderDao));
  }

  /**
   * 订单管理列表 分页总数查询
   * @param {*} params 
   */
  async ordersCount(params){
    let sql = [];
    sql.push('SELECT COUNT(1) AS orderCount FROM o_order WHERE 1 = 1 ');
    this.setOrderCount(sql,params);
    return await this.customQuery(sql.join(" "), params);
  }

  /**
   * 订单列表 分页
   * @param {*} params 
   */
  async findAll(params){
    let sql = [];
    sql.push(`SELECT * FROM o_order WHERE 1=1 `);
    this.setOrderCount(sql,params);
    sql.push(`limit ${params.startRow} ,${params.pageSize}`);
    return await this.customQuery(sql.join(" "), params);

  }

  /**
   * 订单管理列表查询条件参数设置
   * @param {*} params 
   */
  async setOrderCount(sql,params){
    if(params.id){
      sql.push(`AND id = :id `);
    }
    if(params.progress){
      sql.push(`AND progress = :progress `);
    }
    if(params.deliver_id){
      sql.push(`AND deliver_id = :deliver_id `);
    }
    if (params.begin) {
      sql.push(`AND created_at >= :begin `);
    }
    if (params.end) {
      sql.push(`AND created_at <= :end`);
    }
    
  }

  async findMapByIds(ids, attrs) {
    var result = {};
    if (!ids || ids.length == 0) {
      return result;
    }
    attrs = attrs || "*";
    var sql = "SELECT " + attrs + " FROM `o_order` WHERE id IN (:ids)";

    var list = await this.customQuery(sql, {
      ids: ids
    });

    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.id] = item;
    }
    return result;
  }

  /**
   * 平台数据概览
   * @param {*} begin 
   * @param {*} end 
   */
  async statOrderByTime(begin, end) {
    var result = {};
    var sql = [];
    sql.push("SELECT");
    sql.push("DATE_FORMAT(created_at, '%Y-%m') AS `month`, SUM(price) AS orderPrice, COUNT(1) AS orderCount");
    sql.push("FROM `o_order`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }

    sql.push("GROUP BY `month` ORDER BY `month` ASC");
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return result;
    }

    for (var idx = 0; idx < list.length; idx++) {
      var item = list[idx];
      result[item.month] = item;

      if (idx == 0) {
        result.begin = item.month;
      }

      if (idx == list.length - 1) {
        result.end = item.month;
      }
    }

    return result;
  }

  async statDayByTime(begin, end) {
    var result = {};
    var sql = [];
    sql.push("SELECT");
    sql.push("DATE_FORMAT(created_at, '%Y-%m-%d') AS `day`, SUM(price) AS orderPrice, COUNT(1) AS orderCount");
    sql.push("FROM `o_order`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }
    sql.push("GROUP BY `day` ORDER BY `day` ASC");
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      result[item.day] = item;
    }
    return result;
  }

}
module.exports = OorderDao;