const system = require("../../../system");
const Dao = require("../../dao.base");

class ObusinessmenDao extends Dao {
  constructor() {
    super(Dao.getModelName(ObusinessmenDao));
  }

  async countByCondition(params) {
    let sql = [];
    sql.push("SELECT");
    sql.push("COUNT(1) AS num");
    sql.push("FROM `o_businessmen` t1");
    sql.push("WHERE 1 = 1");

    this.setCondition(sql, params);

    let rs = await this.customQuery(sql.join(" "), params);
    if (!rs || rs.length == 0) {
      return 0;
    }
    return rs[0].num || 0;
  }

  async listByCondition(params) {
    let sql = [];
    sql.push("SELECT");
    sql.push("t1.*");
    sql.push("FROM `o_businessmen` t1");
    sql.push("WHERE 1 = 1");

    this.setCondition(sql, params);

    sql.push("ORDER BY t1.id DESC");
    sql.push("LIMIT :startRow, :pageSize");

    return await this.customQuery(sql.join(" "), params);
  }

  setCondition(sql, params) {
    if (params.order_id) {
      sql.push("AND t1.order_id = :order_id");
    }
    if (params.orderIds && params.orderIds.length > 0) {
      sql.push("AND t1.order_id IN (:orderIds)");
    }
    if (params.name) {
      params.name_like = "%" + params.name + "%";
      sql.push("AND t1.name LIKE :name_like");
    }
    if (params.bd_id) {
      sql.push("AND t1.bd_id = :bd_id");
    }
    if (params.bd_path) {
      params.bd_path_like = params.bd_path + "%";
      sql.push("AND t1.bd_path LIKE :bd_path_like");
    }
    if (params.order_id) {
      sql.push("AND t1.order_id = :order_id");
    }
    if (params.legal_name) {
      sql.push("AND t1.legal_name = :legal_name");
    }
    if (params.legal_mobile) {
      sql.push("AND t1.legal_mobile = :legal_mobile");
    }
    if (params.legal_idcard) {
      sql.push("AND t1.legal_idcard = :legal_idcard");
    }
    if (params.credit_code) {
      sql.push("AND t1.credit_code = :credit_code");
    }

    if (params.hasOwnProperty("isSign")) {
      if (params.isSign) {
        sql.push("AND t1.sign_time IS NOT NULL");
      } else {
        sql.push("AND t1.sign_time IS NULL");
      }
    }
  }
}

module.exports = ObusinessmenDao;