const system = require("../../../system");
const Dao = require("../../dao.base");
class IborderbaseDao extends Dao {
  constructor() {
    super(Dao.getModelName(IborderbaseDao));
    this.statusMap = {};
  }

  async findMapByIds(ids, attrs) {
    var result = {};
    if (!ids || ids.length == 0) {
      return result;
    }
    attrs = attrs || "*";
    var sql = "SELECT " + attrs + " FROM `ib_orderbase` WHERE id IN (:ids)";

    var list = await this.customQuery(sql, {
      ids: ids
    });

    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.id] = item;
    }
    return result;
  }
}
module.exports = IborderbaseDao;