const system = require("../../../system");
const Dao = require("../../dao.base");
class OsourceDao extends Dao {
  constructor() {
    super(Dao.getModelName(OsourceDao));
  }

  /**
   * 条件查询所有符合条件的来源数据
   * @param {*} params 
   */
  async listByIds(ids){
    if(!ids || ids.length == 0) {
      return [];
    }
    let sql = [];
    sql.push(`SELECT * FROM o_source WHERE id in (:sourceIdList)`);
    
    return await this.customQuery(sql.join(" "), {sourceIdList: ids});
  }

  async mapByIds(params) {
    let list = await this.listByIds(params);
    var result = {};
    for(let item of list) {
      result[item.id] = item;
    }
    return result;
  }

}
module.exports = OsourceDao;