const system=require("../../../system");
const Dao=require("../../dao.base");
class BusinessmeninvoicecontentDao extends Dao{
  constructor(){
    super(Dao.getModelName(BusinessmeninvoicecontentDao));
  }

  async delByBusinessmenId(businessmenId, t) {
    var sql = "DELETE FROM " + this.model.tableName + " WHERE businessmen_id = :businessmenId";
    var list = await this.customUpdate(sql, {
      businessmenId: businessmenId
    }, t) || [null];

    return list[0];
  }
  async mapByBusinessmenIds(businessmenIds, attrs) {
    var result = {};
    if (!businessmenIds || businessmenIds.length == 0) {
      return result;
    }
    attrs = attrs || "*";
    var sql = "SELECT businessmen_id, invoicecontent_id, invoicecontentName FROM " + this.model.tableName + " where businessmen_id IN (:businessmenIds) ";
    var list = await this.customQuery(sql, {
      businessmenIds: businessmenIds
    });
    if(!list) {
      return result;
    }
    for(var item of list) {
      var lst = result[item.businessmen_id];
      if(!lst) {
        lst = [];
      }
      lst.push(item);
      result[item.businessmen_id] = lst;
    }
    return result;
  }
}
module.exports=BusinessmeninvoicecontentDao;
