var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ActionAPI extends APIBase {
    constructor() {
        super();
        this.iborderbaseSve = system.getObject("service.order.iborderbaseSve");
        this.ibdeliverbaseSve = system.getObject("service.order.ibdeliverbaseSve");

        this.iborderSve = system.getObject("service.order.iborderSve");
        this.iborderdeliverSve = system.getObject("service.order.iborderdeliverSve");

        this.businessmenSve = system.getObject("service.business.businessmenSve");
        this.businessmencontractSve = system.getObject("service.business.businessmencontractSve");

        //-----------------------------------------------------------------------------------------

        this.oorderSve = system.getObject("service.order.oorderSve");
        this.oorderdeliverSve = system.getObject("service.order.oorderdeliverSve");
        this.oorderstatusSve = system.getObject("service.order.oorderstatusSve");
        this.oprocessSve = system.getObject("service.product.oprocessSve");
        this.oproductSve = system.getObject("service.product.oproductSve");
        this.obusinessmenSve = system.getObject("service.order.obusinessmenSve");
    }
    /**
     * 接口跳转
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springboard(pobj, qobj, req) {
        var result;
        if (!pobj.action_process) {
            return system.getResult(null, "action_process参数不能为空");
        }
        if (!pobj.action_type) {
            return system.getResult(null, "action_type参数不能为空");
        }
        console.log(pobj.action_process, pobj.action_type, pobj.action_body, "---------------- this is order micro sve --------------------");
        try {
            result = await this.handleRequest(pobj.action_process, pobj.action_type, pobj.action_body);
        } catch (error) {
            console.log(error);
        }
        return result;
    }

    async handleRequest(action_process, action_type, action_body) {
        var opResult = null;
        try{
            switch (action_type) {
                case "orderInfo":   // 查订单信息
                    opResult = await this.oorderSve.info(action_body);
                    break;
                    case "orderInfoAll":   // 查订单信息
                    opResult = await this.oorderSve.infoAll(action_body);
                    break;

                case "orders":           //订单管理（平台）
                    opResult = await this.oorderSve.orders(action_body);
                    break;

                case "orderDelivers":    //订单管理（交付商）
                    opResult = await this.oorderdeliverSve.orderDelivers(action_body);
                    break;

                case "handleStatus":     //进度处理
                    opResult = await this.oorderstatusSve.handleStatus(action_body);
                    break;

                case "addSourceOrder":    // 创建来源订单
                    opResult = await this.oorderSve.addSourceOrder(action_body);
                    break;

                    
                case "productDics":    // 查询产品字典
                    opResult = await this.oproductSve.productDics(action_body);
                    break;

                case "allProcess":    // 查询业务进度
                    opResult = await this.oprocessSve.allNames(action_body);
                    break;
                // 个体户
                case "queryObusinessmen":  //查询个体工商户信息
                    opResult = await this.obusinessmenSve.queryObusinessmen(action_body);
                    break;
                case "businessmenPage":
                    opResult = await this.obusinessmenSve.businessmenPage(action_body);
                    break;
                case "createAccount":
                    opResult = await this.obusinessmenSve.createAccount(action_body);
                    break;
                case "signing":
                    opResult = await this.obusinessmenSve.signing(action_body);
                    break;
                // 统计数据（平台）
                case "statTransData":     //数据简报  
                    opResult = await this.oorderSve.statTransData(action_body);
                    break;
                case "needToBeDealtWith":  //待办事项
                    opResult = await this.oorderSve.needToBeDealtWith(action_body);
                    break;
                case "statDeliverData":    //交付商统计
                    opResult = await this.oorderdeliverSve.statDeliverData(action_body);
                    break;
                    
                // 统计数据（交付商）
                case "deliverStatTransData":    //交付商统计
                    opResult = await this.oorderdeliverSve.deliverStatTransData(action_body);
                    break;
                case "businessManagement":       //业务办理
                    opResult = await this.oorderdeliverSve.businessManagement(action_body);
                    break;
                //******************************************************************** */

                // // 订单
                // case "createOrder":    //创建订单
                //     opResult = await this.iborderbaseSve.apiCreateOrder(action_body);
                //     break;
                // case "completedOrder": //完善信息接口
                //     opResult = await this.iborderbaseSve.apiCompletedOrder(action_body);
                //     break;
                // case "handling":       //订单办理接口
                //     opResult = await this.iborderbaseSve.apiHandling(action_body);
                //     break;
                // // case "orders":           //订单列表
                // //     opResult = await this.iborderbaseSve.apiOrders(action_body);
                // //     break;
                // case "addOrder":
                //     opResult = await this.iborderSve.apiAdd(action_body);
                //     break;
                // case "updOrder":
                //     opResult = await this.iborderSve.apiUpd(action_body);
                //     break;
                //
                // // -------------------
                // case "allOrderList":
                //     opResult = await this.iborderSve.apiAllList(action_body);
                //     break;
                // // case "orderInfo":
                // //     opResult = await this.iborderSve.apiInfo(action_body);
                // //     break;
                // // case "orderInfoAll":
                // //     opResult = await this.iborderSve.apiAllInfo(action_body);
                // //     break;
                // case "byChannelOrderId":
                //     opResult = await this.iborderSve.apiByChannelOrderId(action_body);
                //     break;
                //
                //
                // case "orderEdit":
                //     opResult = await this.iborderSve.apiEdit(action_body);
                //     break;
                // case "orderAssign":
                //     opResult = await this.iborderSve.apiAssign(action_body);
                //     break;
                // case "myOrderPage":
                //     opResult = await this.iborderSve.apiMyPage(action_body);
                //     break;
                // case "orderPay":
                //     opResult = await this.iborderSve.apiOrderPay(action_body);
                //     break;
                // case "orderClose":
                //     opResult = await this.iborderSve.apiOrderClose(action_body);
                //     break;
                // case "closeOrderById":
                //     opResult = await this.iborderSve.apiCloseById(action_body);
                //     break;
                // case "orderComplete":
                //     opResult = await this.iborderSve.apiComplete(action_body);
                //     break;
                // case "orderByDeliverId":
                //     opResult = await this.iborderSve.apiByDeliverId(action_body);
                //     break;
                //
                //
                // // 订单办理
                // case "orderDeliverList":
                //     opResult = await this.iborderdeliverSve.apiPage(action_body);
                //     break;
                // case "orderDeliverHandle":
                //     opResult = await this.iborderdeliverSve.apiHandle(action_body);
                //     break;
                // case "orderDeliverInfo":
                //     opResult = await this.iborderdeliverSve.apiInfo(action_body);
                //     break;
                // case "orderDeliverEdit":
                //     opResult = await this.iborderdeliverSve.apiEdit(action_body);
                //     break;
                //
                // case "orderDeliverAudit":
                //     opResult = await this.iborderdeliverSve.apiAudit(action_body);
                //     break;
                //
                // case "orderDeliverClose":
                //     opResult = await this.iborderdeliverSve.apiClose(action_body);
                //     break;
                //
                // // 个体户管理
                // case "businessmenByOrderId":
                //     opResult = await this.businessmenSve.apiByOrderId(action_body);
                //     break;
                // case "businessmenByChannelOrderNo":
                //     opResult = await this.businessmenSve.apiByChannelOrderNo(action_body);
                //     break;
                // case "businessmenNameList":
                //     opResult = await this.businessmenSve.apiNameList(action_body);
                //     break;
                // case "businessmenPage":
                //     opResult = await this.businessmenSve.apiPage(action_body);
                //     break;
                // case "businessmenInfo":
                //     opResult = await this.businessmenSve.apiInfo(action_body);
                //     break;
                // case "businessmenSign":
                //     opResult = await this.businessmenSve.apiSign(action_body);
                //     break;
                // case "businessmenSignPage":
                //     opResult = await this.businessmenSve.apiSignPage(action_body);
                //     break;
                // case "businessmenInfoPage":
                //     opResult = await this.businessmenSve.apiInfoPage(action_body);
                //     break;
                // case "businessmenUserPage":
                //     opResult = await this.businessmenSve.apiUserPage(action_body);
                //     break;
                // case "businessmenDeliverPage":
                //     opResult = await this.businessmenSve.apiDeliverPage(action_body);
                //     break;
                // case "addBusinessmenContract":
                //     opResult = await this.businessmenSve.apiAddContract(action_body);
                //     break;
                //
                // case "businessmenCompleteMapByCreditCodes":
                //     opResult = await this.businessmenSve.apiCompleteMapByCreditCodes(action_body);
                //     break;
                //
                

                default:
                    opResult = system.getResult(null, "action_type参数错误");
                    break;
            }
            return opResult;
        } catch (e) {
            console.log(e);
            return system.getResult(null, "order服务异常");
        }
    }
    exam() {
        return `<pre><pre/>`;
    }
    classDesc() {
        return {
            groupName: "op",
            groupDesc: "元数据服务包",
            name: "ActionAPI",
            desc: "此类是对外提供接口服务",
            exam: "",
        };
    }
    methodDescs() {
        return [{
            methodDesc: `<pre><pre/>`,
            methodName: "springboard",
            paramdescs: [{
                    paramDesc: "请求的行为，传递如：sjb",
                    paramName: "action_process",
                    paramType: "string",
                    defaultValue: null,
                },
                {
                    paramDesc: "业务操作类型，详情见方法中的描述",
                    paramName: "action_type",
                    paramType: "string",
                    defaultValue: null,
                },
                {
                    paramDesc: "业务操作类型的参数，action_body必须传递的参数有，times_tamp（时间戳，类型int）、sign(签名,类型string)，其余的为业务需要的参数",
                    paramName: "action_body",
                    paramType: "json",
                    defaultValue: null,
                }
            ],
            rtnTypeDesc: `<pre><pre/>`,
            rtnType: `<pre><pre/>`
        }];
    }
}
module.exports = ActionAPI;