// var log4js = require('log4js');
var settings = require("../../config/settings");
const uuidv4 = require('uuid/v4');
const system = require("../system");
class LogClient {
  constructor() {
    // log4js.configure(settings.basepath+"/app/config/log4js.json");
    // this.logerApp=log4js.getLogger("app");
    // this.logerHttp=log4js.getLogger("http");
  }
  getUUID() {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }
  async log(pobj, req, rtninfo, errinfo) {
    rtninfo.requestId = this.getUUID()
    req.params.param = pobj
    if (!["findSystemMsgCount", "findUnreadCount"].includes(req.params && req.params.method || '')) {
      //第三个字段应该存公司id
      system.execLogs(settings.appname + "_" + req.xctx.codetitle, req.params, "_" + "center-manage" + (pobj.company_id || '') + "_", rtninfo, errinfo).then(res => {
        if (res && res.status == 1) {
          console.log("log.....success")
        } else {
          console.log("log.....fail")
        }
      }).catch(e => {
        console.log("log.....fail")
      })
    }
  }

  async logList(pobj) {
    let { search, pageInfo, company_id } = pobj;
    let { userName, errorInfo, messageBody, resultInfo, created_at, opTitle, requestId } = search;
    let query = {
      indexName: `logs-sytxpublic-msgq-${settings.logindex}`,
      pageSize: pageInfo.pageSize,
      currentPage: pageInfo.pageNo
    };
    if (company_id && company_id != 1) {
      query.identifyCode = `_${company_id}_`;
    }
    if (opTitle) {
      query.opTitle = opTitle;
    }
    if (requestId) {
      query.requestId = requestId;
    }
    if (userName) {
      query.messageBody = userName;
    }
    if (errorInfo) {
      query.errorInfo = errorInfo;
    }
    if (messageBody) {
      query.messageBody = messageBody;
    }
    if (resultInfo) {
      query.resultInfo = resultInfo;
    }
    if (created_at && created_at[0] && created_at[1]) {
      query.startTime = new Date(created_at[0]).getTime();
      query.entTime = new Date(created_at[1]).getTime();
    }
    let rtn = await system.postJsonTypeReq(settings.logUrl(), {
      "actionType": "queryLogsData",// Y 功能名称
      "actionBody": query
    });

    if (rtn.statusCode === 200) {
      rtn = rtn.data;
      if (rtn && rtn.status === 1) {
        return rtn.data;
      } else {
        throw new Error(rtn && rtn.message || '请联系管理员');
      }
    } else {
      throw new Error(rtn)
    }
  }
}
module.exports = LogClient;
