const ToQiFuTong = require('../../../utils/qifutong/baseClient').getInstance();
const _ = require("lodash");
class StatisticsService {
    async getAllChannels(pobj) {
        return ToQiFuTong.getAllChannels();
    }
    async getAllProducts(pobj) {
        return ToQiFuTong.getAllProducts();
    }
    async getPathName(pobj) {
        return ToQiFuTong.getPathName();
    }
    async getStatisticsByUappId(pobj) {
        const data = await ToQiFuTong.getStatisticsByUappId({
            start: pobj.start,
            end: pobj.end,
            type_name: pobj.type_code,
            status: pobj.status
        });
        const dates = ToQiFuTong.getAllDate(pobj.start, pobj.end);
        return {
            x: dates,
            data
        };
    }
    async getOrderStatisticsByUappId(pobj) {
        const data = await ToQiFuTong.getOrderStatisticsByUappId({
            start: pobj.start,
            end: pobj.end,
            pathName: pobj.type_code,
            status: pobj.status
        });
        const dates = ToQiFuTong.getAllDate(pobj.start, pobj.end);
        return {
            x: dates,
            data
        };
    }
    async getStatisticsByProduct(pobj) {
        const data = await ToQiFuTong.getStatisticsByProduct({
            start: pobj.start,
            end: pobj.end,
            // status: pobj.status,
        });
        let result = []; // 基础数据
        let channels = new Set(); //渠道
        let productList = []; //产品
        for (let val of data) {
            let productCount = 0;
            for (let info of val.data) {
                productCount += info.count;
                channels.add(info.uapp_id ? info.uapp_id.toString() : "");
                result.push({
                    uapp_id: info.uapp_id ? info.uapp_id.toString() : "",
                    count: info.count,
                    type_code: val.type_code
                })
            }
            productList.push({
                count: productCount,
                type_code: val.type_code
            })
        }
        productList = productList.sort(function (a, b) { return a.count - b.count });
        return {
            channelList: [...channels],
            productList: productList.map((item) => { return item.type_code }),
            data: result
        };
    }
    async getOrderStatisticsByProduct(pobj) {
        const data = await ToQiFuTong.getOrderStatisticsByProduct({
            start: pobj.start,
            end: pobj.end,
            // status: pobj.status,
        });
        let result = []; // 基础数据
        let channels = new Set(); //渠道
        let productList = []; //产品
        for (let val of data) {
            let productCount = 0;
            for (let info of val.data) {
                productCount += info.count;
                channels.add(info.uapp_id ? info.uapp_id.toString() : "");
                result.push({
                    uapp_id: info.uapp_id ? info.uapp_id.toString() : "",
                    count: info.count,
                    type_code: val.pathName
                })
            }
            productList.push({
                count: productCount,
                type_code: val.pathName
            })
        }
        productList = productList.sort(function (a, b) { return a.count - b.count });
        return {
            channelList: [...channels],
            productList: productList.map((item) => { return item.type_code }),
            data: result
        };
    }

    async getNeedFunnelStatistics(pobj) {
        return ToQiFuTong.getNeedFunnelStatistics({
            start: pobj.start,
            end: pobj.end,
            type_name: pobj.type_code,
            uapp_id: pobj.uapp_id
        });
    }

    async getStatisticsByArea(pobj) {
        const data = await ToQiFuTong.getStatisticsByArea({
            start: pobj.start,
            end: pobj.end,
            type_name: pobj.type_code,
            uapp_id: pobj.uapp_id
        });
        let result = {};
        for (let val of data) {
            const region = val.province.replace(/(.*)(市|省)$/, '$1');
            let sum = 0
            for (let info of val.data) {
                sum += info.count;
            }
            if (result[region]) {
                let productInfo = _.groupBy([...val.data, ...result[region].data], "type_code");
                let productInfoList = [];
                for (let key in productInfo) {
                    let count = 0;
                    for (let info of productInfo[key]) {
                        count += info.count;
                    }
                    productInfoList.push({
                        count,
                        type_code: key
                    });
                }
                result[region] = {
                    sum: result[region].sum + sum,
                    data: productInfoList
                }
            } else {
                result[region] = {
                    sum: sum,
                    data: val.data
                }
            }
        }
        return result;
    }

    async getNeedComparison(pobj) {
        const data = await ToQiFuTong.getNeedComparison({
            startNow: pobj.startNow,
            endNow: pobj.endNow,
            startLast: pobj.startLast,
            endLast: pobj.endLast,
            type_name: pobj.type_code,
            uapp_id: pobj.uapp_id
        });
        return {
            businessStatistics: {
                sum: data.now.total,
                lastSum: data.last.total,
                type: ToQiFuTong.judgeSize(data.now.total, data.last.total),
                contrast: (data.last.total === 0 ? (data.now.total === 0 ? 0 : 100) : ((data.now.total - data.last.total) / data.last.total * 100)).toFixed(2)

            },
            businessToOrderStatistics: {
                sum: data.now.order,
                lastSum: data.last.order,
                type: ToQiFuTong.judgeSize(data.now.order, data.last.order),
                contrast: (data.last.order === 0 ? (data.now.order === 0 ? 0 : 100) : ((data.now.order - data.last.order) / data.last.order * 100)).toFixed(2)

            }
        };
    }
    async getOrdersComparison(pobj) {
        const data = await ToQiFuTong.getOrdersComparison({
            startNow: pobj.startNow,
            endNow: pobj.endNow,
            startLast: pobj.startLast,
            endLast: pobj.endLast,
            pathName: pobj.type_code,
            uapp_id: pobj.uapp_id
        });
        return {
            orderStatistics: {
                sum: data.now.total,
                lastSum: data.last.total,
                type: ToQiFuTong.judgeSize(data.now.total, data.last.total),
                contrast: (data.last.total === 0 ? (data.now.total === 0 ? 0 : 100) : ((data.now.total - data.last.total) / data.last.total * 100)).toFixed(2)

            }
        };
    }

    async getStatisticsList(pobj) {
        const data = await ToQiFuTong.getStatisticsList({
            start: pobj.start,
            end: pobj.end,
            uapp_id: pobj.uapp_id,
            type_code: pobj.type_code,
            type_name: pobj.type_code,
            pathName: pobj.type_code,
            pageIndex: pobj.pageNum || 1,
            pageSize: pobj.pageSize || 10,
            listType: pobj.listType,
            fuzzy_code: pobj.fuzzy_code,
            status: pobj.status
        });
        return data;
    }

    async importTxNeeds(pobj) {
        const data = await ToQiFuTong.importTxNeeds(pobj);
        return data;
    }
    async getNeedProductType(pobj) {
        const data = await ToQiFuTong.getNeedProductType(pobj);
        return data;
    }
}
module.exports = StatisticsService;