const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
const fs = require("fs")
class PricestrategyService extends ServiceBase {
  constructor() {
    super("product", ServiceBase.getDaoName(PricestrategyService));
  }
  async buildPriceStrategy(pricetypes) {
    let dks = []
    let codeattr=[]
    let pricetypenames=[]
    pricetypes.forEach(item => {
      dks.push(item.options.split(","))
      codeattr.push(item.code)
      pricetypenames.push(item.name)
    })
    let codeunion=codeattr.join("~")
    //先按照codeunion检查是否已经生成
    let se=await this.dao.findOne({codeunion:codeunion})
    if(se!=null){
      return {status:-1,msg:'定价策略已经存在，无需再次生成'}
    }
    let nameunion=pricetypenames.join("~")
    let dkresults=this.makedks(dks)
    let strategys=[]
    for(let dk of dkresults){
      let tmp={
        "codeunion":codeunion,
        "nameunion":nameunion,
        "optionunion":dk.split("|").join(",")
      }
      strategys.push(tmp)
    }
    var self=this;
    return this.db.transaction(async function (t) {
      let r=await self.dao.bulkCreate(strategys,t)
      return {status:0};
    });
  }
  makedks(rows) {
    var mid = []
    if(rows.length==1){
      mid=rows[0]
      return mid
    }
    for (let i = 0; i < rows.length; i++) {
      if (mid.length == 0) {
        console.log("in..........")
        let one = rows[i]
        let two = rows[++i]
        console.log(two, "..........")
        one.forEach(item => {
          two.forEach(c => {
            mid.push(item + "|" + c)
          })
        })
      } else {
        let next = rows[i]
        let tmparray = []
        mid.forEach(m => {
          next.forEach(n => {
            tmparray.push(m + "|" + n)
          })
        })
        mid = tmparray
      }
    }
    return mid;
  }
}
module.exports = PricestrategyService;
// (async ()=>{
//   let u=new AppService();
//  //  let x=await u.cregister("jiangong")
//  //  console.log(x)
//  // let x=await u.cunregister("jiangong")
//  //  console.log(x)
//   // let t=await u.cmakejwt()
//   // console.log(t)
//   //let ux=await u.cjsonregister(AppService.newRouteUrl("test-service2"),{name:"test-service2",hosts:["ttest1.com"]})
//   //let ux=await u.cjsonregister(AppService.newServiceUrl(),{name:"test-service3",url:"http://zhichan.gongsibao.com"})
//   //let ux=await u.cdel(AppService.routeUrl("test-service2"))
//   //let ux=await u.cdel(AppService.serviceUrl("test-service2"))
//   //  let ux=await u.create({name:"test4-service",backend:"zhichan-service",domainName:"domain.com"})
//   //   console.log(ux);
//   // let delrtn=await u.delete({id:2,name:"test4-service"})
//   // console.log(delrtn);
// })()