const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
class RouteService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(RouteService));
  }

  //创建应用
  //每个应用建立两个路由，一个api路由
  //对api路由启用jwt插件
  async create(serviceName, routedata, req) {
    var self = this;
    return this.db.transaction(async function (t) {
      var rtn=null;
      try {
        //添加路由
        let routeobj = await self.cjsonregister(RouteService.newRouteUrl(serviceName), { name: routedata.name, hosts: routedata.hosts, paths: routedata.paths, strip_path: routedata.isstrip })
        routedata.center_id = routeobj.id;
        rtn = await self.dao.create(routedata, t);
      } catch (e) {
        console.log(e)
        await self.cdel(RouteService.routeUrl(routedata.name));
      }
      return rtn;
    });
  }
  async delete(qobj) {
    var self = this;
    return this.db.transaction(async function (t) {
      let a=await self.dao.delete(qobj,t);
      await self.cdel(RouteService.routeUrl(a.name));
      return a
    });
  }
  async findAndCountAll(obj) {
    var self = this;
    const apps = await super.findAndCountAll(obj);
    return apps;
  }
}
module.exports = RouteService;
// (async ()=>{
//   let u=new AppService();
//  //  let x=await u.cregister("jiangong")
//  //  console.log(x)
//  // let x=await u.cunregister("jiangong")
//  //  console.log(x)
//   // let t=await u.cmakejwt()
//   // console.log(t)
//   //let ux=await u.cjsonregister(AppService.newRouteUrl("test-service2"),{name:"test-service2",hosts:["ttest1.com"]})
//   //let ux=await u.cjsonregister(AppService.newServiceUrl(),{name:"test-service3",url:"http://zhichan.gongsibao.com"})
//   //let ux=await u.cdel(AppService.routeUrl("test-service2"))
//   //let ux=await u.cdel(AppService.serviceUrl("test-service2"))
//   //  let ux=await u.create({name:"test4-service",backend:"zhichan-service",domainName:"domain.com"})
//   //   console.log(ux);
//   // let delrtn=await u.delete({id:2,name:"test4-service"})
//   // console.log(delrtn);
// })()