var system = require("../../../../system");
const sha235 = require("sha256");
var settings = require("../../../../../config/settings");
class Zc360Handler {
  constructor() {
    this.icUrl = settings.icUrl() + "/web/bizchance";
    this.userService = system.getObject("service.auth.userSve");
    this.cmpService = system.getObject("service.common.companySve");
    this.cacheManager = system.getObject("db.common.cacheManager");
  }


  //交付单处理
  async pushOrderDelivery(datajson, channelobj) {
    try {
      var cachestr = sha235(JSON.stringify(datajson));
      var cacheInfo = await this.cacheManager["AliCache"].getCache(cachestr);
      if (cacheInfo && cacheInfo != 'undefined') {
        return {
          "status": 1,    //1代表成功，否则失败
          "msg": "已处理成功!",
          "data": "",
          "requestId": ""
        }
      }

      let rc = system.getObject("util.execClient");
      let obj = this.actionBodyHandler(datajson.actionBody);
      let requrl = this.icUrl + "/deliverybillCtl/createOrderByPush";


      //渠道名称和渠道编码
      obj.channelSource = channelobj.name;
      obj.channelNumber = channelobj.code;


      //如果订单状态为已支付
      //查询业务员信息并填充到obj
      if (datajson.actionBody.needsolution.salesmanInfo.salesmanId || datajson.actionBody.needsolution.salesmanInfo.salesmanChannelId) {
        let userId = datajson.actionBody.needsolution.salesmanInfo.salesmanId || datajson.actionBody.needsolution.salesmanInfo.salesmanChannelId;
        obj.salesmanOpcode = `root10/bizgroup01/g1members/${userId}`;
        //去数据库查询该业务员信息
        try {
          let resInfo = await this.userService.getSalesmanInfo(userId);
          if (resInfo) {
            obj.salesmanOpcode = resInfo.opath;
            obj.salesmanName = obj.salesmanName || resInfo.nickName;
            obj.servicerCode = resInfo.company_id;
          }
        } catch (error) {
          console.log("salesmanId: " + userId + "获取业务员opcode失败:" + error)
        }
      }

      //获取交付商id
      if (!obj.servicerCode) {
        let companyInfo = await this.userService.getCompanyIdByName(obj.servicerName);
        if (companyInfo && companyInfo.id) {
          obj.servicerCode = companyInfo.id;
        }
      }
      obj.servicerCode = obj.servicerCode ? obj.servicerCode : 10;

      //设置成本
      if (obj.skuCode) {
        obj.costPrice = await this.userService.findCostBySkuCode(obj.skuCode)
      }

      let rtn = await rc.execPost3({ "d": obj }, requrl);
      console.log("pushOrderDelivery插入数据成功---------------------------------" + rtn.stdout);
      if (rtn.stdout.status == 0) {
        rtn.stdout.status = 1;
        await this.cacheManager["AliCache"].cache(cachestr, JSON.stringify({ cachestr: cachestr }), 180);
      }
      return rtn.stdout
    }
    catch (error) {
      console.log("error-------------------------------------" + error);
      return system.getResultError(error);
    }
  }


  actionBodyHandler(actionBody) {
    let data = actionBody;
    let obj = {};
    obj.baseInfo = {};
    obj.companyInfo = {};
    obj.registeredInfo = {};
    obj.positionInfo = {};
    obj.regInfo = {};
    obj.express_info = {};

    if (data.orderNo) {//交付单编号
      obj.deliverNumber = data.orderNo;
    }
    if (data.servicer) {//服务商信息
      if (data.servicer.name) {//服务商名称
        obj.servicerName = data.servicer.name;
      }
    }
    // if (data.channelNeedNo) {//需求编号
    //   obj.businessMode = data.channelNeedNo;
    // }
    // if (data.channelSolutionNo) {//方案编号
    //   obj.schemeNumber = data.channelSolutionNo;
    // }
    if (data.needsolution.solution.Area) {//服务地区编码和服务地区
      obj.serviceCode = data.needsolution.solution.Area;
      obj.serviceName = data.needsolution.solution.Area;
      obj.baseInfo.serviceName = data.needsolution.solution.Area;
    }
    if (data.needsolution.solution.CompanyName) {//公司名称
      obj.baseInfo.companyName = data.needsolution.solution.CompanyName;
      obj.companyName = data.needsolution.solution.CompanyName;
    }
    if (data.needsolution.solution.CompanyAddress) {//公司地址
      obj.baseInfo.companyAddress = data.needsolution.solution.CompanyAddress;
    }
    if (data.needsolution.solution.companyLocation) {//服务地区编码和服务地区
      obj.serviceCode = data.needsolution.solution.companyLocation;
      obj.serviceName = data.needsolution.solution.companyLocation;
      obj.baseInfo.serviceName = data.needsolution.solution.companyLocation;
    }

    if (data.needsolution.solution.actionType) {//证件类型:新办 续期 变更
      obj.baseInfo.actionType = data.needsolution.solution.actionType;
    }
    if (data.needsolution.solution.licenseType) {//⽹⽂类型：⽹络表演
      obj.baseInfo.licenseType = data.needsolution.solution.licenseType;
    }

    if (data.needsolution.bizType) { //产品编码
      if (data.needsolution.bizType == "icpsq") {
        obj.businessType = "ICP";
      }
      if (data.needsolution.bizType == "edisq") {
        obj.businessType = "EDI";
      }
      if (data.needsolution.bizType == "wangwen") {
        obj.businessType = "wangwen";
      }
      if (data.needsolution.bizType == "food") {
        obj.businessType = "food";
      }
    }
    if (data.needsolution.typeName) { //产品名称
      if (data.needsolution.typeName == "icp申请") {
        obj.businessName = "icp";
      } else if (data.needsolution.typeName == "edi申请") {
        obj.businessName = "edi";
      } else if (data.needsolution.typeName == "文网文") {
        obj.businessName = "文网文";
      } else {
        obj.businessName = data.needsolution.typeName
      }
    }
    if (data.skuCode) { //产品的sku
      obj.skuCode = data.skuCode;
    }
    if (data.needsolution.status) { //交付单状态码
      if (data.needsolution.status == "PAID") {//已支付
        obj.deliverStatus = "received";
      }
      if (data.needsolution.status == "USER_PAY_PRODUCE") {//已支付
        obj.deliverStatus = "received";
      }
    }
    if (data.needsolution.customerRemark) { //状态原因
      obj.statusReason = data.needsolution.customerRemark;
    }
    if (data.needsolution.totalSum) { //价格
      obj.sellingPrice = data.needsolution.totalSum;
    }

    if (data.needsolution.salesmanInfo) {//业务员id
      if (data.needsolution.salesmanInfo.salesmanId) {
        obj.salesmanId = data.needsolution.salesmanInfo.salesmanId;
      }
      if (data.needsolution.salesmanInfo.salesmanName) {//业务员name
        obj.salesmanName = data.needsolution.salesmanInfo.salesmanName;
      }
      if (data.needsolution.salesmanInfo.salesmanMobile) {//业务员手机
        obj.salesmanPhone = data.needsolution.salesmanInfo.salesmanMobile;
      }
    }


    if (data.needsolution.customerInfo) {//联系人
      if (data.needsolution.customerInfo.publishName) {
        obj.baseInfo.contactsName = data.needsolution.customerInfo.publishName;
      }
      if (data.needsolution.customerInfo.publishMobile) {//联系电话
        obj.baseInfo.contactsPhone = data.needsolution.customerInfo.publishMobile;
      }
      if (data.needsolution.customerRemark) {//备注信息
        obj.baseInfo.memoInfo = data.needsolution.customerRemark;
      }
    }
    if (data.needsolution.customerMaterial) {//客户上传所有材料
      obj.baseInfo.customerMaterial = data.needsolution.customerMaterial;
    }
    if (data.needsolution.solutionFlowList) {//流程记录
      obj.baseInfo.solutionFlowList = data.needsolution.solutionFlowList;
    }
    return obj;
  }
}



module.exports = new Zc360Handler();