var system = require("../../../../system");
const sha235 = require("sha256");
var settings = require("../../../../../config/settings");
const rc = system.getObject("util.execClient");

class PannongHandler {
  constructor() {
    this.icpUrl = settings.icpUrl();
    this.cacheManager = system.getObject("db.common.cacheManager");
  }
  async submitService(datajson) {
    try {
      let cachestr = sha235(JSON.stringify(datajson));
      let cacheInfo = await this.cacheManager["AliCache"].getCache(cachestr);
      if (cacheInfo && cacheInfo != 'undefined') {
        return {
          "status": 1,    //1代表成功，否则失败
          "msg": "已处理成功!",
          "data": "",
          "requestId": ""
        }
      } else {
        let requrl = `${this.icpUrl}/web/agriculture/servicebillCtl/create`;
        let { actionBody } = datajson;
        let rtn = await rc.execPost3(actionBody, requrl);
        let j = JSON.parse(rtn.stdout);
        if (j.status == 0) {
          j.status = 1;
          await this.cacheManager["AliCache"].cache(cachestr, JSON.stringify({ cachestr: cachestr }), 180);//插入redis缓存
          j.status = 1;
        }
        return j;
      }
    } catch (error) {
      console.log(error);
      return system.getResultError(error);
    }
  }


  async notifyService(datajson) {
    try {
      let cachestr = sha235(JSON.stringify(datajson));
      let cacheInfo = await this.cacheManager["AliCache"].getCache(cachestr);
      if (cacheInfo && cacheInfo != 'undefined') {
        return {
          "status": 1,    //1代表成功，否则失败
          "msg": "已处理成功!",
          "data": "",
          "requestId": ""
        }
      } else {
        let requrl = `${this.icpUrl}/web/agriculture/servicebillCtl/updateStatus`;
        let { actionBody } = datajson;
        let rtn = await rc.execPost3(actionBody, requrl);
        let j = JSON.parse(rtn.stdout);
        if (j.status == 0) {
          j.status = 1;
          await this.cacheManager["AliCache"].cache(cachestr, JSON.stringify({ cachestr: cachestr }), 180);//插入redis缓存
        }
        return j;
      }
    } catch (error) {
      console.log(error);
      return system.getResultError(error);
    }
  }
}



module.exports = new PannongHandler();