const system = require("../../../system");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
module.exports = (db, DataTypes) => {
  //定价类型
  return db.define("productcost", {
    costdesc: {//成本描述
      type: DataTypes.STRING,
      allowNull: true,
    },
    expensetype: {//费用类型
      type: DataTypes.STRING,
      allowNull: true,
    },
    costratio: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: true,
    },
    costamount: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: true,
      set (value) {
        this.setDataValue('costamount', value * 100);
      },
      get () {
        const resValue = this.getDataValue('costamount');
        return resValue / 100;
      }
    },
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'p_productcost',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
