var system = require("../../../system");
const http = require("http");
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
class logCtl extends CtlBase {
    constructor() {
        super("common", CtlBase.getServiceName(logCtl));
        this.logClient = system.getObject("util.logClient");

    }

    async findAndCountAll(pobj, qobj, req) {
        try {
            let rtn = await this.logClient.logList(pobj);
            return system.getResult({
                results: {
                    count: rtn.totalCount,
                    rows: rtn && rtn.list && rtn.list.map(item => {
                        let { opTitle, identifyCode, messageBody, resultInfo, errorInfo, requestId, created_at } = item;
                        messageBody = messageBody ? JSON.parse(messageBody) : {}
                        resultInfo = resultInfo ? JSON.parse(resultInfo) : {}
                        let status;
                        if (resultInfo && (resultInfo.status === 0 || !resultInfo.status || resultInfo.status === 1)) {
                            status = "SUCCESS"
                        } else {
                            status = "FAIL"
                        }
                        if (errorInfo && errorInfo !== "null") {
                            status = "FAIL"
                        }
                        return {
                            opTitle: opTitle,
                            url: messageBody.url || `${messageBody.gname}/${messageBody.qname}/${messageBody.method}`,
                            user: messageBody.param && messageBody.param.username || '',
                            ip: messageBody.param && messageBody.param.clientIp,
                            created_at,
                            requestId,
                            status,
                            info: {
                                opTitle, identifyCode, messageBody, resultInfo, errorInfo, requestId, created_at
                            }
                        }
                    }) || []
                }
            });
        } catch (err) {
            return system.getResult(null, err.message);
        }
    }
}
module.exports = logCtl;
