var system = require("../../../system")
const CtlBase = require("../../ctl.base");
class TreearchCtl extends CtlBase {
  constructor() {
    super("common", CtlBase.getServiceName(TreearchCtl));
  }
  async getTreeArchByCode (p, q, req) {
    let code = p.code;
    let archName = p.archName;
    let rtn = await this.service.getTreeArchByCode(archName, code)
    return system.getResult(rtn)
  }
  async getRegions (p, q, req) {
    let regionjson = await this.service.getRegions();
    return system.getResult({ regionJson: regionjson })
  }
  async getSysArchJSON (p, q, req) {
    let sysArchJSON = await this.service.getSysArchJSON();
    return system.getResult({ sysArchJSON: sysArchJSON })
  }
  async saveSysArchJSON (p, q, req) {
    let sysArchJSON = await this.service.saveSysArchJSON(p.sysArchJSON, p);
    return system.getResult({ sysArchJSON: sysArchJSON })
  }
  async saveRegions (p, q, req) {
    let regionjson = await this.service.saveRegions(p.regionJson);
    return system.getResult({ regionJson: regionjson })
  }
  async getProductcats (p, q, req) {
    let productcatJson = await this.service.getProductcats();
    return system.getResult({ productcatJson: productcatJson })
  }
  async saveProductcats (p, q, req) {
    let productcatJson = await this.service.saveProductcats(p.productcatJson);
    return system.getResult({ productcatJson: productcatJson })
  }
}
module.exports = TreearchCtl;
