var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");

class PushCtl extends CtlBase {
    constructor() {
        super("common", CtlBase.getServiceName(PushCtl));
    }

    async findAndCountAll(pobj, qobj, req) {
        let query = {
            pageSize: pobj.pageInfo.pageSize,
            pageIndex: pobj.pageInfo.pageNo
        };
        let search = pobj.search;
        if (search.messageBody)
            query.messageBody = search.messageBody;

        if (search.identify_code)
            query.identifyCode = search.identify_code;

        if (search.request_id)
            query.requestIdInfo = search.request_id;

        let actionType;
        switch (pobj.bizpath) {
            case "/sysmag/pushfail":
                actionType = "getPushFailureList";
                break;
            case "/sysmag/pusherror":
                actionType = "getPushErrorList";
                break
        }
        let rtn = await system.postJsonTypeReq(settings.pushUrl(), {
            "actionType": actionType,
            "actionBody": query
        });
        if (rtn.statusCode === 200) {
            rtn = rtn.data;
            if (rtn && rtn.status === 1) {
                return system.getResult({
                    results: {
                        count: rtn.totalCount,
                        rows: rtn && rtn.data || []
                    }
                });
            } else {
                return system.getResultFail(rtn && rtn.message || '请联系管理员');
            }
        } else {
            return system.getResultFail(rtn)
        }
    }

    async repush(pobj, qobj, req) {
        let rtn = await system.postJsonTypeReq(settings.pushUrl(), {
            "actionType": "pushAgainFailureLog",
            "actionBody": {
                id: pobj.id
            }
        });
        if (rtn.statusCode === 200) {
            return rtn.data;
        } else {
            return system.getResultFail(rtn)
        }
    }
}

module.exports = PushCtl;
